/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth;

import com.adobe.csi.auth.IKeychainService;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.osgi.service.component.ComponentContext;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedFileKeychainService
implements IKeychainService {
    private static final Logger LOGGER = Logger.getLogger(EncryptedFileKeychainService.class);
    private static final String PROP_ENCRYPTION_ALGORITHM = "com.adobe.csi.auth.encryption.algorithm";
    private static final String PROP_KEY_STORE_FILE_LOCATION = "com.adobe.csi.auth.keystorefile.location";
    private static final String PROP_SECRET_KEY_DIR = "com.adobe.csi.auth.secretkeys.dir";
    private static final String PROPERTIES_KEY_PASSWORD = "pass";
    private static final String PROPERTIES_KEY_USER_NAME = "user";
    private String algorithm;
    private BASE64Decoder base64Decoder;
    private BASE64Encoder base64Encoder;
    private Cipher cipher;
    private String keyStoreFileLocation;
    private MessageDigest messageDigest;
    private Properties properties;
    private SecretKey secretKey;

    public Set<String> getAvailableAlgorithms() {
        Provider[] providers;
        HashSet<String> resultSet = new HashSet<String>();
        Provider[] providerArray = providers = Security.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            Provider provider = providerArray[n2];
            Set<Object> keySet = provider.keySet();
            for (Object object : keySet) {
                String key = object.toString().split(" ")[0];
                if (key.startsWith("Cipher.")) {
                    resultSet.add(key.substring("Cipher.".length()));
                    continue;
                }
                if (!key.startsWith("Alg.Alias.Cipher")) continue;
                resultSet.add(key.substring("Alg.Alias.Cipher.".length()));
            }
            ++n2;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] lookupCredentials(String serviceName) {
        Properties properties = this.properties;
        synchronized (properties) {
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Looking up credentials for: " + serviceName));
            }
            String[] credentials = null;
            String username = (String)this.properties.get(this.createPropertiesKey(serviceName, PROPERTIES_KEY_USER_NAME));
            String password = (String)this.properties.get(this.createPropertiesKey(serviceName, PROPERTIES_KEY_PASSWORD));
            if (username != null && password != null) {
                try {
                    username = this.decrypt(username);
                    password = this.decrypt(password);
                    credentials = new String[]{username, password};
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Error looking up the credentials for: " + serviceName), (Throwable)e);
                }
            }
            return credentials;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCredentials(String serviceName) {
        Properties properties = this.properties;
        synchronized (properties) {
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Removing credentials for: " + serviceName));
            }
            boolean success = false;
            String username = (String)this.properties.remove(this.createPropertiesKey(serviceName, PROPERTIES_KEY_USER_NAME));
            String password = (String)this.properties.remove(this.createPropertiesKey(serviceName, PROPERTIES_KEY_PASSWORD));
            this.persistsProperties();
            success = username != null && password != null;
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCredentials(String serviceName, String username, String password) {
        Properties properties = this.properties;
        synchronized (properties) {
            try {
                if (LOGGER.isLogging(Level.INFO)) {
                    LOGGER.info((Object)("Storeing credentials for: " + username));
                }
                this.properties.put(this.createPropertiesKey(serviceName, PROPERTIES_KEY_USER_NAME), this.encrypt(username));
                this.properties.put(this.createPropertiesKey(serviceName, PROPERTIES_KEY_PASSWORD), this.encrypt(password));
                this.persistsProperties();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while storing the credentials for: " + serviceName), (Throwable)e);
            }
        }
    }

    protected void activate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating EncryptedFileKeychainService: " + EncryptedFileKeychainService.class));
        }
        this.initEncoder();
        this.initAlgorithm(context);
        this.initMessageDigest();
        this.initCipher();
        this.initSecretKey(context);
        this.initKeyStoreFile(context);
        this.initShutdownHook();
    }

    protected void deactivate(ComponentContext context) {
        this.algorithm = null;
        this.base64Encoder = null;
        this.base64Decoder = null;
        this.cipher = null;
        this.keyStoreFileLocation = null;
        this.messageDigest = null;
        this.properties = null;
        this.secretKey = null;
    }

    private String createHash(String plain) {
        String hash = null;
        try {
            byte[] bytes = plain.getBytes("UTF-8");
            this.messageDigest.reset();
            bytes = this.messageDigest.digest(bytes);
            hash = this.base64Encoder.encode(bytes);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error creating hash for: " + plain), (Throwable)e);
        }
        return hash;
    }

    private String createPropertiesKey(String serviceName, String property) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.algorithm != null ? this.algorithm : "plain");
        buffer.append(".");
        buffer.append(serviceName);
        buffer.append(".");
        buffer.append(property);
        String hashed = this.createHash(buffer.toString());
        return hashed;
    }

    private File createSecretKeyFile(String secretKeyLocation) {
        assert (this.algorithm != null) : "Algorithm is null";
        String fileName = this.createHash(this.algorithm);
        fileName = fileName.replaceAll("\\\\", "_");
        fileName = fileName.replaceAll("/", "_");
        return new File(secretKeyLocation, "." + fileName);
    }

    private String decrypt(String encrypted) throws Exception {
        String decrypted = null;
        byte[] bytes = this.base64Decoder.decodeBuffer(encrypted);
        if (this.cipher != null) {
            this.cipher.init(2, this.secretKey);
            bytes = this.cipher.doFinal(bytes);
        }
        decrypted = new String(bytes, "UTF-8");
        return decrypted;
    }

    private String encrypt(String plain) throws Exception {
        String encrypted = null;
        byte[] bytes = plain.getBytes("UTF-8");
        if (this.cipher != null) {
            this.cipher.init(1, this.secretKey);
            bytes = this.cipher.doFinal(bytes);
        }
        encrypted = this.base64Encoder.encode(bytes);
        return encrypted;
    }

    private void initAlgorithm(ComponentContext context) {
        this.algorithm = (String)context.getProperties().get(PROP_ENCRYPTION_ALGORITHM);
        if (this.algorithm == null) {
            this.algorithm = "AES";
        }
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Using algorithm: " + this.algorithm));
        }
        if (!this.getAvailableAlgorithms().contains(this.algorithm)) {
            LOGGER.error((Object)("Algorithm (" + this.algorithm + ") is not supported. File will be written in plain text."));
            this.algorithm = null;
        }
    }

    private void initCipher() {
        if (this.algorithm != null) {
            try {
                this.cipher = Cipher.getInstance(this.algorithm);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while generating Cipher for: " + this.algorithm), (Throwable)e);
            }
        }
    }

    private void initEncoder() {
        this.base64Encoder = new BASE64Encoder();
        this.base64Decoder = new BASE64Decoder();
    }

    private void initKeyStoreFile(ComponentContext context) {
        this.keyStoreFileLocation = (String)context.getProperties().get(PROP_KEY_STORE_FILE_LOCATION);
        if (this.keyStoreFileLocation == null || this.keyStoreFileLocation.trim().equals("")) {
            this.keyStoreFileLocation = String.valueOf(System.getProperty("user.dir")) + "/auth/";
        }
        this.properties = new Properties();
        File file = new File(this.keyStoreFileLocation);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((file = new File(file, ".keyChain")).exists()) {
            this.loadProperties();
        }
    }

    private void initMessageDigest() {
        try {
            this.messageDigest = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Error creating MessageDigest", (Throwable)e);
        }
    }

    private void initSecretKey(ComponentContext context) {
        block25: {
            if (this.algorithm != null) {
                try {
                    File secretKeyFile;
                    File file;
                    String secretKeyLocation = (String)context.getProperties().get(PROP_SECRET_KEY_DIR);
                    if (secretKeyLocation == null || secretKeyLocation.trim().equals("")) {
                        secretKeyLocation = String.valueOf(System.getProperty("user.dir")) + "/auth/";
                    }
                    if (!(file = new File(secretKeyLocation)).exists()) {
                        file.mkdirs();
                    }
                    if ((secretKeyFile = this.createSecretKeyFile(secretKeyLocation)).exists()) {
                        ObjectInputStream ois = null;
                        try {
                            ois = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(secretKeyFile))));
                            this.secretKey = (SecretKey)ois.readObject();
                        }
                        catch (Throwable throwable) {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block25;
                    }
                    ObjectOutputStream oos = null;
                    try {
                        this.secretKey = KeyGenerator.getInstance(this.algorithm).generateKey();
                        oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(secretKeyFile))));
                        oos.writeObject(this.secretKey);
                    }
                    catch (Throwable throwable) {
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.error((Object)("Error while generating SecretKey for: " + this.algorithm), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initShutdownHook() {
    }

    private void loadProperties() {
        try {
            this.properties.load(new FileInputStream(String.valueOf(this.keyStoreFileLocation) + "/.keyChain"));
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Loaded keychain from: " + this.keyStoreFileLocation));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("The key store file could not be found: " + this.keyStoreFileLocation), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while loading the key store file: " + this.keyStoreFileLocation), (Throwable)e);
        }
    }

    private void persistsProperties() {
        try {
            this.properties.store(new FileOutputStream(String.valueOf(this.keyStoreFileLocation) + "/.keyChain"), "KeyChain for CSI");
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Saved keychain to: " + this.keyStoreFileLocation));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("The key store file could not be found: " + this.keyStoreFileLocation), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while saving the key store file: " + this.keyStoreFileLocation), (Throwable)e);
        }
    }
}

