/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth;

import com.adobe.csi.auth.AuthenticationException;
import com.adobe.csi.auth.AuthenticationRequest;
import com.adobe.csi.auth.AuthenticationResponse;
import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.DeleteCredentialsRequest;
import com.adobe.csi.auth.DeleteCredentialsResponse;
import com.adobe.csi.auth.IAuthenticationProvider;
import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.IKeychainService;
import com.adobe.csi.auth.LogoutRequest;
import com.adobe.csi.auth.LogoutResponse;
import com.adobe.csi.auth.RetrieveCredentialsRequest;
import com.adobe.csi.auth.RetrieveCredentialsResponse;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.auth.StoreCredentialsRequest;
import com.adobe.csi.auth.StoreCredentialsResponse;
import com.adobe.csi.core.IServiceRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class AuthenticationService
implements IAuthenticationService {
    private static final String PROVIDER_REF = "AUTHENTICATION_PROVIDER";
    private static final String PROP_PROVIDER_ID = "providerId";
    private final Map<String, AuthenticationToken> tokenMap = new HashMap<String, AuthenticationToken>();
    private IServiceRegistry serviceRegistry;
    private final Map<String, ServiceReference> providerRefMap = new HashMap<String, ServiceReference>();
    private final Map<String, IAuthenticationProvider> providerMap = new HashMap<String, IAuthenticationProvider>();
    private IKeychainService keychainService;
    private ComponentContext context;
    private Map<String, String[]> transientCredentialsMap = new HashMap<String, String[]>();

    public StoreCredentialsResponse storeCredentials(StoreCredentialsRequest request) {
        StoreCredentialsResponse response = new StoreCredentialsResponse();
        String serviceName = request.getExtensionId();
        String providerId = this.serviceRegistry.getAuthenticationProvider(serviceName);
        if (providerId == null) {
            response.setStatus(StatusCode.ERROR_NO_SUCH_PROVIDER);
        } else {
            AuthenticationToken authToken = request.getAuthenticationToken();
            if (authToken != null) {
                this.tokenMap.put(providerId, authToken);
            }
            String uid = request.getUserId();
            String password = request.getPassword();
            if (uid != null) {
                if (request.isStore()) {
                    this.keychainService.storeCredentials(providerId, uid, password);
                } else {
                    this.keychainService.removeCredentials(providerId);
                }
                this.transientCredentialsMap.put(providerId, new String[]{uid, password});
            }
            response.setStatus(StatusCode.OK);
        }
        return response;
    }

    public RetrieveCredentialsResponse retrieveCredentials(RetrieveCredentialsRequest request) {
        RetrieveCredentialsResponse response = new RetrieveCredentialsResponse();
        String serviceName = request.getExtensionId();
        String providerId = this.serviceRegistry.getAuthenticationProvider(serviceName);
        if (providerId == null) {
            response.setStatus(StatusCode.ERROR_NO_SUCH_PROVIDER);
        } else {
            String[] credentials = this.keychainService.lookupCredentials(providerId);
            if (credentials != null) {
                response.setUserId(credentials[0]);
                response.setPassword(credentials[1]);
                response.setStore(true);
            } else {
                credentials = this.transientCredentialsMap.get(providerId);
                if (credentials != null) {
                    response.setUserId(credentials[0]);
                    response.setPassword(credentials[1]);
                    response.setStore(false);
                }
            }
            AuthenticationToken authToken = this.tokenMap.get(providerId);
            if (authToken != null) {
                response.setAuthenticationToken(authToken);
            }
        }
        return response;
    }

    public DeleteCredentialsResponse deleteCredentials(DeleteCredentialsRequest request) {
        DeleteCredentialsResponse response = new DeleteCredentialsResponse();
        String serviceName = request.getExtensionId();
        String providerId = this.serviceRegistry.getAuthenticationProvider(serviceName);
        if (providerId == null) {
            response.setStatus(StatusCode.ERROR_NO_SUCH_PROVIDER);
        } else {
            if (request.isStore()) {
                this.keychainService.removeCredentials(providerId);
                this.transientCredentialsMap.remove(providerId);
            } else {
                this.keychainService.removeCredentials(providerId);
            }
            response.setStatus(StatusCode.OK);
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationResponse authenticate(AuthenticationRequest request) {
        AuthenticationResponse result = new AuthenticationResponse();
        String serviceName = request.getExtensionId();
        String providerId = this.serviceRegistry.getAuthenticationProvider(serviceName);
        if (!request.hasCredentials()) {
            AuthenticationToken token;
            AuthenticationToken authenticationToken = token = request.isSharedSession() ? this.tokenMap.get(providerId) : null;
            if (token == null) {
                String[] credentials = this.keychainService.lookupCredentials(providerId);
                if (credentials != null) {
                    request.setStoreCredentials(true);
                } else {
                    credentials = this.transientCredentialsMap.get(providerId);
                }
                if (credentials == null) {
                    result.setStatusCode(StatusCode.ERROR_UNAUTHORIZED);
                    return result;
                }
                request.setUserId(credentials[0]);
                request.setPassword(credentials[1]);
                return this.authenticate(request);
            }
            String[] credentials = this.keychainService.lookupCredentials(providerId);
            if (credentials != null) {
                result.setStore(true);
            } else {
                credentials = this.transientCredentialsMap.get(providerId);
                result.setStore(false);
            }
            result.setStatusCode(StatusCode.OK);
            result.setAuthenticationToken(token);
            result.setUserId(credentials[0]);
            result.setPassword(credentials[1]);
            return result;
        }
        IAuthenticationProvider provider = this.lookupAuthenticationProvider(providerId);
        if (provider == null) {
            result.setStatusCode(StatusCode.ERROR_NO_SUCH_PROVIDER);
            return result;
        }
        try {
            AuthenticationToken token = provider.authenticate(request.getUserId(), request.getPassword());
            assert (token != null);
            result.setStatusCode(StatusCode.OK);
            result.setAuthenticationToken(token);
            this.tokenMap.put(providerId, token);
            this.keychainService.removeCredentials(providerId);
            if (request.isStoreCredentials()) {
                this.keychainService.storeCredentials(providerId, request.getUserId(), request.getPassword());
                result.setStore(true);
            }
            this.transientCredentialsMap.put(providerId, new String[]{request.getUserId(), request.getPassword()});
            result.setUserId(request.getUserId());
            result.setPassword(request.getPassword());
            return result;
        }
        catch (AuthenticationException e) {
            result.setStatusCode(StatusCode.ERROR_UNAUTHORIZED);
            result.setErrorDetails(e.getMessage());
            return result;
        }
        catch (IOException e) {
            result.setStatusCode(StatusCode.ERROR);
            result.setErrorDetails(e.getMessage());
        }
        return result;
    }

    public LogoutResponse logout(LogoutRequest request) {
        LogoutResponse result = new LogoutResponse();
        String serviceName = request.getExtensionId();
        String providerId = this.serviceRegistry.getAuthenticationProvider(serviceName);
        IAuthenticationProvider provider = this.lookupAuthenticationProvider(providerId);
        if (provider == null) {
            result.setStatusCode(StatusCode.ERROR_NO_SUCH_PROVIDER);
        } else {
            result.setStatusCode(StatusCode.OK);
            AuthenticationToken token = this.tokenMap.remove(providerId);
            try {
                provider.logout(token);
            }
            catch (AuthenticationException authenticationException) {
                result.setStatusCode(StatusCode.ERROR_UNAUTHORIZED);
            }
            catch (IOException iOException) {
                result.setStatusCode(StatusCode.ERROR);
            }
            this.transientCredentialsMap.remove(providerId);
        }
        return result;
    }

    public void bindKeychainService(IKeychainService keychainService) {
        if (this.keychainService == null) {
            this.keychainService = keychainService;
        }
    }

    public void unbindKeychainService(IKeychainService keychainService) {
        if (this.keychainService == keychainService) {
            this.keychainService = null;
        }
    }

    public void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }

    public void addAuthenticationProvider(String providerId, IAuthenticationProvider provider) {
        this.providerMap.put(providerId, provider);
    }

    public void removeAuthenticationProvider(String providerId) {
        this.providerMap.remove(providerId);
    }

    protected void activate(ComponentContext context) {
        this.context = context;
    }

    protected void deactivate(ComponentContext context) {
        this.context = null;
        this.providerMap.clear();
        this.providerRefMap.clear();
    }

    protected void addAuthenticationProvider(ServiceReference reference) {
        String providerId = (String)reference.getProperty(PROP_PROVIDER_ID);
        if (providerId != null) {
            this.providerRefMap.put(providerId, reference);
            if (this.context != null) {
                IAuthenticationProvider provider = (IAuthenticationProvider)this.context.locateService(PROVIDER_REF, reference);
                this.addAuthenticationProvider(providerId, provider);
            }
        }
    }

    protected void removeAuthenticationProvider(ServiceReference reference) {
        String providerId = (String)reference.getProperty(PROP_PROVIDER_ID);
        if (providerId != null) {
            this.providerRefMap.remove(providerId);
            this.removeAuthenticationProvider(providerId);
        }
    }

    private IAuthenticationProvider lookupAuthenticationProvider(String providerId) {
        ServiceReference providerRef;
        IAuthenticationProvider result = this.providerMap.get(providerId);
        if (result == null && (providerRef = this.providerRefMap.get(providerId)) != null) {
            if (this.context == null) {
                throw new IllegalStateException();
            }
            result = (IAuthenticationProvider)this.context.locateService(PROVIDER_REF, providerRef);
            this.providerMap.put(providerId, result);
        }
        return result;
    }
}

