/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.identity.VersionIdentityCollector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VersionIdentityCollectorByVersionId
extends VersionIdentityCollector<Integer> {
    VersionIdentityCollectorByVersionId() {
    }

    @Override
    protected Map<Integer, IVersion> resolve(List<Integer> values) throws ModelException {
        HashMap<Integer, IVersion> result = new HashMap<Integer, IVersion>();
        for (Integer versionId : values) {
            IVersion found;
            try {
                found = AssetFactory.findVersionById(versionId);
            }
            catch (DriveException e) {
                throw new ModelException(e.getMessage());
            }
            if (found == null) continue;
            result.put(versionId, found);
        }
        return result;
    }
}

