/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.identity.VersionIdentityCollector;
import com.adobe.drive.utils.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionIdentityCollectorByPath
extends VersionIdentityCollector<Path> {
    @Override
    protected Map<Path, IVersion> resolve(List<Path> values) throws ModelException {
        HashMap<Path, IVersion> result = new HashMap<Path, IVersion>();
        for (Path path : values) {
            String versionName = path.lastSegment();
            String versionIdStr = versionName.substring(0, versionName.lastIndexOf("."));
            try {
                IVersion version;
                Integer versionId = Integer.parseInt(versionIdStr);
                try {
                    version = AssetFactory.findVersionById(versionId);
                }
                catch (DriveException e) {
                    throw new ModelException(e.getMessage());
                }
                if (version == null) continue;
                result.put(path, version);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModelException("Could not parse version local id from URI: " + path);
            }
        }
        return result;
    }
}

