/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.ErrorCodeEnum;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.identity.AssetIdentity;
import com.adobe.drive.data.model.identity.VersionIdentity;

public final class IdentityResolver {
    public static IAsset resolve(AssetIdentity assetIdentity) throws ModelException {
        return assetIdentity.resolve();
    }

    public static IAsset resolveDE(AssetIdentity assetIdentity) throws DriveException {
        try {
            return assetIdentity.resolve();
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.ASSET_NOT_FOUND, (Throwable)e);
        }
        catch (ModelException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_PARAMETER, (Throwable)e);
        }
    }

    public static IVersion resolve(VersionIdentity versionIdentity) throws ModelException {
        return versionIdentity.resolve();
    }

    public static IVersion resolveDE(VersionIdentity versionIdentity) throws DriveException {
        try {
            return versionIdentity.resolve();
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.VERSION_NOT_FOUND, (Throwable)e);
        }
        catch (ModelException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_PARAMETER, (Throwable)e);
        }
    }

    public static IAsset unresolve(AssetIdentity identity) {
        return identity.unresolve();
    }
}

