/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.identity.AssetIdentity;
import com.adobe.drive.data.model.identity.AssetIdentityCollectorByAssetId;
import com.adobe.drive.data.model.identity.AssetIdentityCollectorByPath;
import com.adobe.drive.data.model.identity.AssetIdentityCollectorByReference;
import com.adobe.drive.data.model.identity.AssetIdentityCollectorByVNodeId;
import com.adobe.drive.data.model.identity.VersionIdentity;
import com.adobe.drive.data.model.identity.VersionIdentityCollectorByPath;
import com.adobe.drive.data.model.identity.VersionIdentityCollectorByVersionId;
import com.adobe.drive.utils.Path;

public final class Identities {
    private AssetIdentityCollectorByAssetId byAssetId;
    private AssetIdentityCollectorByReference byReference;
    private AssetIdentityCollectorByPath byAssetPath;
    private AssetIdentityCollectorByVNodeId byVNodeId;
    private VersionIdentityCollectorByVersionId byVerisonId;
    private VersionIdentityCollectorByPath byVerisonPath;

    public AssetIdentity createAssetIdentity(Integer assetId) {
        if (this.byAssetId == null) {
            this.byAssetId = new AssetIdentityCollectorByAssetId();
        }
        return new AssetIdentity<Integer>(this.byAssetId, assetId);
    }

    public AssetIdentity createAssetIdentity(Path path) {
        if (this.byAssetPath == null) {
            this.byAssetPath = new AssetIdentityCollectorByPath();
        }
        return new AssetIdentity<Path>(this.byAssetPath, path);
    }

    public AssetIdentity createAssetIdentity(VNodeId vNodeId) {
        if (this.byVNodeId == null) {
            this.byVNodeId = new AssetIdentityCollectorByVNodeId();
        }
        return new AssetIdentity<VNodeId>(this.byVNodeId, vNodeId);
    }

    public AssetIdentity createAssetIdentity(String reference) {
        if (this.byReference == null) {
            this.byReference = new AssetIdentityCollectorByReference();
        }
        return new AssetIdentity<String>(this.byReference, reference);
    }

    public static AssetIdentity createAssetIdentity(IAsset asset) {
        return new AssetIdentity(asset);
    }

    public VersionIdentity createVersionIdentity(Integer versionId) {
        if (this.byVerisonId == null) {
            this.byVerisonId = new VersionIdentityCollectorByVersionId();
        }
        return new VersionIdentity<Integer>(this.byVerisonId, versionId);
    }

    public VersionIdentity createVersionIdentity(Path path) {
        if (this.byVerisonPath == null) {
            this.byVerisonPath = new VersionIdentityCollectorByPath();
        }
        return new VersionIdentity<Path>(this.byVerisonPath, path);
    }
}

