/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.identity.AssetIdentityCollector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssetIdentityCollectorByVNodeId
extends AssetIdentityCollector<VNodeId> {
    AssetIdentityCollectorByVNodeId() {
    }

    @Override
    protected Map<VNodeId, IAsset> resolve(List<VNodeId> values) throws ModelException {
        HashMap<VNodeId, IAsset> result = new HashMap<VNodeId, IAsset>();
        for (VNodeId vNodeId : values) {
            IAsset found;
            try {
                found = AssetFactory.findAssetByVNodeId(vNodeId);
            }
            catch (DriveException e) {
                throw new ModelException(e.getMessage());
            }
            if (found == null) continue;
            result.put(vNodeId, found);
        }
        return result;
    }
}

