/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.identity.AssetIdentityCollector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssetIdentityCollectorByReference
extends AssetIdentityCollector<String> {
    AssetIdentityCollectorByReference() {
    }

    @Override
    protected Map<String, IAsset> resolve(List<String> values) throws ModelException {
        HashMap<String, IAsset> result = new HashMap<String, IAsset>();
        for (String reference : values) {
            IAsset found;
            try {
                found = AssetFactory.findAssetByReference(reference);
            }
            catch (DriveException e) {
                throw new ModelException(e.getMessage());
            }
            if (found == null) continue;
            result.put(reference, found);
        }
        return result;
    }
}

