/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.MountPointFactory;
import com.adobe.drive.data.model.identity.AssetIdentityCollector;
import com.adobe.drive.utils.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssetIdentityCollectorByPath
extends AssetIdentityCollector<Path> {
    AssetIdentityCollectorByPath() {
    }

    @Override
    protected Map<Path, IAsset> resolve(List<Path> values) throws ModelException {
        HashMap<Path, IAsset> result = new HashMap<Path, IAsset>();
        for (Path path : values) {
            IMountPoint currentMountPoint = MountPointFactory.findMountPointByLocalPath(path);
            if (currentMountPoint == null) continue;
            result.put(path, AssetFactory.findAssetByPath(currentMountPoint.getId(), Path.newInstance((String)currentMountPoint.getLocalPath(), (boolean)false).forcePathToFolder().calculateRelativePath(path).forceAbsolute().toString()));
        }
        return result;
    }
}

