/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.identity;

import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.identity.AssetIdentityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssetIdentity<T> {
    private final T value;
    private IAsset resolved;
    protected final AssetIdentityCollector<T> collector;

    AssetIdentity(AssetIdentityCollector<T> collector, T value) {
        this.collector = collector;
        this.value = value;
        collector.add(value);
    }

    AssetIdentity(IAsset asset) {
        this.value = null;
        this.collector = null;
        this.resolved = asset;
    }

    IAsset resolve() throws ModelException {
        if (this.resolved == null) {
            this.resolved = (IAsset)this.collector.resolve(this.value);
        }
        return this.resolved;
    }

    IAsset unresolve() {
        IAsset unresolved = this.resolved;
        if (this.value != null && this.collector != null) {
            this.resolved = null;
            this.collector.setToUnresolved();
        }
        return unresolved;
    }

    public String toString() {
        return this.value.toString();
    }
}

