/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.asset;

import com.adobe.drive.data.model.IServer;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.utils.Path;
import java.net.URI;

public class MountPointFactory {
    private static IFactory factory;

    public static void setFactory(IFactory factory) {
        MountPointFactory.factory = factory;
    }

    public static IMountPoint[] findAllMountPoints() throws ModelException {
        return factory.findAllMountPoints();
    }

    public static IMountPoint findMountPointById(int id) throws ModelObjectNotFoundException, ModelException {
        return factory.findMountPointById(id);
    }

    public static IMountPoint[] findMountPointsByServerGuid(String guid) throws ModelObjectNotFoundException, ModelException {
        return factory.findMountPointsByServerGuid(guid);
    }

    public static IMountPoint findMountPointByLocalPath(Path localPath) throws ModelException {
        return factory.findMountPointByLocalPath(localPath);
    }

    public static IMountPoint findMountPointByRemoteUriAndUsername(URI remoteUri, String username) throws ModelException {
        return factory.findMountPointByRemoteUriAndUsername(remoteUri, username);
    }

    public static IMountPoint createMountPoint(Path localPath, IServer server, String username, String password) throws ModelException {
        return factory.createMountPoint(localPath, server, username, password);
    }

    public static void remove(IMountPoint mountPoint) throws ModelException {
        factory.remove(mountPoint);
    }

    public static void setMountPointsAsDeactivated() throws ModelException {
        factory.setMountPointsAsDeactivated();
    }

    private MountPointFactory() {
    }

    public static interface IFactory {
        public IMountPoint[] findAllMountPoints() throws ModelException;

        public IMountPoint findMountPointById(int var1) throws ModelObjectNotFoundException, ModelException;

        public IMountPoint[] findMountPointsByServerGuid(String var1) throws ModelObjectNotFoundException, ModelException;

        public IMountPoint findMountPointByLocalPath(Path var1) throws ModelException;

        public IMountPoint findMountPointByRemoteUriAndUsername(URI var1, String var2) throws ModelException;

        public IMountPoint createMountPoint(Path var1, IServer var2, String var3, String var4) throws ModelException;

        public void remove(IMountPoint var1) throws ModelException;

        public void setMountPointsAsDeactivated() throws ModelException;
    }
}

