/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model.asset;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.ErrorCodeEnum;
import com.adobe.drive.data.model.asset.AssetTypeEnum;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IAssetProperty;
import com.adobe.drive.data.model.asset.ILock;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.IProject;
import com.adobe.drive.data.model.asset.IVNode;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.IVersionProperty;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.asset.Visibility;
import com.adobe.drive.utils.Path;

public final class AssetFactory {
    private static IFactory factory;

    public static void setFactory(IFactory factory) {
        AssetFactory.factory = factory;
    }

    public static IFactory getFactory() {
        return factory;
    }

    public static IAsset findAssetById(int assetId) throws DriveException {
        try {
            return factory.findAssetById(assetId);
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_ID, (Throwable)e);
        }
    }

    public static IAsset findAssetByReference(String reference) throws DriveException {
        try {
            return factory.findAssetByReference(reference);
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_REFERENCE, (Throwable)e);
        }
    }

    public static IAsset findAssetByVNodeId(VNodeId vnodeId) throws DriveException {
        try {
            IVNode result = factory.findVNodeById(vnodeId);
            if (result.getType() == IVNode.Type.VERSION_NODE) {
                return result.getVersion().getAsset();
            }
            return result.getAsset();
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_ID, (Throwable)e);
        }
    }

    public static IAsset findAssetByRemoteId(int mountId, String remoteId, String namespace) {
        return factory.findAssetByRemoteId(mountId, remoteId, namespace);
    }

    public static IAsset findAssetByPath(int mountPointId, String path) {
        return factory.findAssetByPath(mountPointId, path);
    }

    public static IAsset createAsset(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        return factory.createAsset(mountPoint, namespace, name, creationDate);
    }

    public static IAsset createLocalAsset(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        return factory.createLocalAsset(mountPoint, namespace, name, creationDate);
    }

    public static IAssetProperty createAssetProperty(IAsset asset, String key, Object value) throws ModelException {
        return factory.createAssetProperty(asset, key, value);
    }

    public static IVersion findVersionById(int versionId) throws DriveException {
        try {
            return factory.findVersionById(versionId);
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.ASSET_NOT_FOUND, (Throwable)e);
        }
    }

    public static IAsset createAssetContainer(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        return factory.createAssetContainer(mountPoint, namespace, name, creationDate);
    }

    public static IProject createProject(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        return factory.createProject(mountPoint, namespace, name, creationDate);
    }

    public static IVersion createVersion(IAsset asset, boolean isHead) throws ModelException {
        return factory.createVersion(asset, isHead);
    }

    public static IVersionProperty createVersionProperty(IVersion version, String key, Object value) throws ModelException {
        return factory.createVersionProperty(version, key, value);
    }

    public static ILock createLock(String lockToken, String owner, boolean myLock) throws ModelException {
        return factory.createLock(lockToken, owner, myLock);
    }

    public static ILock findLockById(int lockId) throws ModelObjectNotFoundException {
        return factory.findLockById(lockId);
    }

    public static IAsset[] findLockedAssets(Integer[] mountPointIds, Path[] pathFilter, boolean onlyLockedByMe) throws ModelException {
        return factory.findLockedAssets(mountPointIds, pathFilter, onlyLockedByMe);
    }

    public static IAsset[] findAssetsByType(Path[] pathFilter, AssetTypeEnum type) throws ModelException {
        return factory.findAssetsByType(pathFilter, type);
    }

    public static IProject[] findProjectsByMountPoint(int mountPointId) {
        return factory.findProjectsByMountPointId(mountPointId);
    }

    public static IProject findProjectByName(int mountPointId, String name) {
        return factory.findProjectByName(mountPointId, name);
    }

    public static IAsset findParent(IAsset asset) {
        assert (asset != null) : "asset != null";
        String path = asset.getPath();
        if (path == null || path.equals("/")) {
            return null;
        }
        int pos = path.lastIndexOf(47);
        if (pos != 0) {
            return AssetFactory.findAssetByPath(asset.getMountPointId(), path.substring(0, pos));
        }
        return AssetFactory.findAssetByPath(asset.getMountPointId(), "/");
    }

    public static IAsset[] findChildren(IAsset asset) {
        return factory.findChildren(asset);
    }

    public static IAsset[] findChildren(IAsset asset, int offset, int count, Visibility[] visibility) throws ModelException {
        return factory.findChildren(asset, offset, count, visibility);
    }

    public static IVNode findVNodeById(VNodeId nodeId) throws DriveException {
        try {
            return factory.findVNodeById(nodeId);
        }
        catch (ModelObjectNotFoundException e) {
            throw new DriveException(ErrorCodeEnum.INVALID_ID, (Throwable)e);
        }
    }

    public static void createVNode(IVersion version) throws ModelException {
        factory.createVNode(version);
    }

    public static boolean removeVersion(IVersion version) {
        return factory.removeVersion(version);
    }

    public static int[] findWorkingCopyIds(boolean includeLocal) throws ModelException {
        return factory.findWorkingCopyIds(includeLocal);
    }

    public static int[] findWorkingCopyIds(int mountPointId, boolean includeLocal) throws ModelException {
        return factory.findWorkingCopyIds(mountPointId, includeLocal);
    }

    public static int[] findVersionIds(int mountPointId) throws ModelException {
        return factory.findVersionIds(mountPointId);
    }

    public static void killHorizontalRefs(int projectId) throws ModelException {
        factory.killHorizontalRefs(projectId);
    }

    public static IAsset findAssetByParentIdAndName(int parentId, String name) throws DriveException {
        try {
            return factory.findAssetByParentIdAndName(parentId, name);
        }
        catch (ModelException e) {
            throw new DriveException(ErrorCodeEnum.SERVICE_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private AssetFactory() {
    }

    public static interface IFactory {
        public void createVNode(IVersion var1) throws ModelException;

        public IAsset findAssetByParentIdAndName(int var1, String var2) throws ModelException;

        public IVNode findVNodeById(VNodeId var1) throws ModelObjectNotFoundException;

        public ILock findLockById(int var1) throws ModelObjectNotFoundException;

        public IAsset[] findLockedAssets(Integer[] var1, Path[] var2, boolean var3) throws ModelException;

        public IAsset[] findAssetsByType(Path[] var1, AssetTypeEnum var2) throws ModelException;

        public IAsset findAssetById(int var1) throws ModelObjectNotFoundException;

        public IAsset findAssetByReference(String var1) throws ModelObjectNotFoundException;

        public IAsset findAssetByRemoteId(int var1, String var2, String var3);

        public IAsset findAssetByPath(int var1, String var2);

        public IAsset createAsset(IMountPoint var1, String var2, String var3, long var4) throws ModelException;

        public IAsset createLocalAsset(IMountPoint var1, String var2, String var3, long var4) throws ModelException;

        public IAssetProperty createAssetProperty(IAsset var1, String var2, Object var3) throws ModelException;

        public IVersion findVersionById(int var1) throws ModelObjectNotFoundException;

        public IAsset createAssetContainer(IMountPoint var1, String var2, String var3, long var4) throws ModelException;

        public IProject createProject(IMountPoint var1, String var2, String var3, long var4) throws ModelException;

        public IVersion createVersion(IAsset var1, boolean var2) throws ModelException;

        public IVersionProperty createVersionProperty(IVersion var1, String var2, Object var3) throws ModelException;

        public boolean removeVersion(IVersion var1);

        public ILock createLock(String var1, String var2, boolean var3) throws ModelException;

        public IProject[] findProjectsByMountPointId(int var1);

        public IProject findProjectByName(int var1, String var2);

        public IAsset[] findChildren(IAsset var1);

        public IAsset[] findChildren(IAsset var1, int var2, int var3, Visibility[] var4) throws ModelException;

        public int[] findWorkingCopyIds(boolean var1) throws ModelException;

        public int[] findWorkingCopyIds(int var1, boolean var2) throws ModelException;

        public int[] findVersionIds(int var1) throws ModelException;

        public void killHorizontalRefs(int var1) throws ModelException;
    }
}

