/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model;

import com.adobe.drive.data.internal.model.Script;
import com.adobe.drive.data.model.IScript;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.asset.ScriptTypeEnum;
import java.io.IOException;
import java.io.InputStream;

public class ScriptFactory {
    private static IPersistentFactory persistentFacotry;
    private static ITransientFactory transientFacotry;

    public static void setFactory(IPersistentFactory myfactory) {
        persistentFacotry = myfactory;
        transientFacotry = new TransientFactory();
    }

    public static ITransientFactory transientOnly() {
        return transientFacotry;
    }

    public static IPersistentFactory useModelCache() {
        return persistentFacotry;
    }

    public static interface IPersistentFactory
    extends ITransientFactory {
        public IScript findScriptById(int var1) throws ModelObjectNotFoundException;

        public IScript[] findScript(int var1, ScriptTypeEnum var2);
    }

    public static interface ITransientFactory {
        public static final int UNDEF_ID = -1;
        public static final String UNDEF_MIME_TYPE = "undef/undef";

        public IScript createScript(IAsset var1, ScriptTypeEnum var2, String var3, boolean var4, InputStream var5) throws ModelException;

        public IScript createFromTemplate(IScript var1) throws ModelException;
    }

    public static class TransientFactory
    implements ITransientFactory {
        public IScript createScript(IAsset asset, ScriptTypeEnum type, String mimetype, boolean isCompiled, InputStream data) throws ModelException {
            Script script = new Script(-1);
            script.setAsset(asset);
            script.setType(type);
            script.setMimetype(mimetype);
            script.setIsCompiled(isCompiled);
            script.setDataStream(data);
            return script;
        }

        public IScript createFromTemplate(IScript template) throws ModelException {
            Script script = new Script(template.getId());
            script.setAsset(template.getAsset());
            script.setType(template.getType());
            script.setMimetype(template.getMimetype());
            script.setIsCompiled(template.isCompiled());
            try {
                InputStream inputStream = template.getDataStream();
                int maxLen = 131072;
                byte[] buff = new byte[maxLen];
                int len = inputStream.read(buff, 0, maxLen);
                if (len >= maxLen) {
                    throw new ModelException("Script truncated");
                }
                byte[] data = new byte[len];
                System.arraycopy(buff, 0, data, 0, len);
                script.setDataBytes(data);
            }
            catch (IOException e) {
                throw new ModelException(e.getMessage());
            }
            return script;
        }
    }
}

