/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.model;

public final class EventData {
    private final EventType type;
    private final int sourceId;
    private final int parentId;
    private final Object data;
    private final boolean checked;
    private volatile int hashCode;

    public EventData(EventType type, int sourceId, Object data, boolean checked) {
        this(type, sourceId, -1, data, checked);
    }

    public EventData(EventType type, int sourceId, int parentId, Object data, boolean checked) {
        this.parentId = parentId;
        assert (type != null) : "type != null";
        this.type = type;
        this.sourceId = sourceId;
        this.data = data;
        this.checked = checked;
    }

    public EventType getType() {
        return this.type;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventData)) {
            return false;
        }
        EventData o = (EventData)other;
        return this.type == o.type && this.sourceId == o.sourceId && (this.data == null ? o.data == null : this.data.equals(o.data)) && this.checked == o.checked;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 42;
            result = result * 11 + this.type.hashCode();
            result = result * 11 + this.sourceId;
            result = result * 11 + (this.data == null ? 0 : this.data.hashCode());
            this.hashCode = result = result * 11 + (this.checked ? 1 : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("(type=").append((Object)this.type);
        result.append(" | sourceId=").append(this.sourceId);
        result.append(" | parentId=").append(this.parentId);
        result.append(" | data=").append(this.data);
        result.append(" | checked=").append(this.checked);
        result.append(')');
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        SERVER_MOUNTED(1001),
        SERVER_UNMOUNTED(1002),
        SERVER_OFFLINE(1003),
        SERVER_ONLINE(1004),
        SERVER_CHANGED(1005),
        ASSET_CREATED(2001),
        ASSET_CHANGED(2002),
        ASSET_DELETED(2003);

        private final int id;

        private EventType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

