/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.metadata.IXMPMetadata;
import com.adobe.drive.data.model.metadata.XMPMetadataTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.Hibernate;

public class XMPMetadata
extends ModelObject
implements IXMPMetadata {
    private IVersion version;
    private XMPMetadataTypeEnum type;
    private Blob xmpPacket;

    public XMPMetadata() {
    }

    public XMPMetadata(int id) {
        super(id);
    }

    public byte[] getBytes() throws ModelException {
        assert (this.xmpPacket != null) : "xmpPacket != null";
        try {
            return this.xmpPacket.getBytes(1L, (int)this.xmpPacket.length());
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public InputStream getInputStream() throws ModelException {
        assert (this.xmpPacket != null) : "xmpPacket != null";
        try {
            return this.xmpPacket.getBinaryStream();
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public XMPMetadataTypeEnum getType() {
        return this.type;
    }

    public void setData(byte[] bytes) {
        this.assertModifiableInvariant();
        assert (bytes != null) : "bytes != null";
        this.xmpPacket = Hibernate.createBlob((byte[])bytes);
    }

    public void setData(InputStream inputStream) throws IOException {
        this.assertModifiableInvariant();
        assert (inputStream != null) : "inputStream != null";
        this.xmpPacket = Hibernate.createBlob((InputStream)inputStream);
    }

    public void setType(XMPMetadataTypeEnum type) {
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        this.type = type;
    }

    public void setVersion(IVersion version) {
        this.assertModifiableInvariant();
        this.version = version;
    }
}

