/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.internal.model.Thumbnail;
import com.adobe.drive.data.internal.model.VersionProperty;
import com.adobe.drive.data.internal.model.XMPMetadata;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IThumbnail;
import com.adobe.drive.data.model.asset.IVNode;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.IVersionProperty;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ThumbnailTypeEnum;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.metadata.IXMPMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Version
extends ModelObject
implements IVersion {
    private IVNode vnode;
    public String remoteId;
    private IAsset asset;
    private int versionNumber;
    private IVersion baseVersion;
    private String mimetype;
    private long contentSize;
    private long modificationTime;
    private String modificationUserName;
    private String comment;
    private Map<ThumbnailTypeEnum, IThumbnail> thumbnails = new HashMap<ThumbnailTypeEnum, IThumbnail>();
    private IXMPMetadata xmpMetadata;
    private Map<String, IVersionProperty> properties = new HashMap<String, IVersionProperty>();
    private String propertiesCache;
    private String thumbnailCache;
    private String xmpCache;
    private boolean deleted;
    private boolean explicit;

    public Version() {
    }

    public Version(int id, IAsset asset, IVNode vnode) {
        super(id);
        assert (asset != null) : "asset != null";
        assert (vnode != null) : "vnode != null";
        this.asset = asset;
        this.vnode = vnode;
        vnode.setVersion(this);
    }

    public VNodeId getVNodeId() {
        return this.vnode != null ? this.vnode.getVNodeId() : null;
    }

    public IVNode getVNode() {
        return this.vnode;
    }

    public void setVNode(IVNode vnode) {
        this.vnode = vnode;
    }

    public IAsset getAsset() {
        return this.asset;
    }

    public void setAsset(IAsset asset) {
        this.assertModifiableInvariant();
        assert (asset != null) : "asset != null";
        this.asset = asset;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        assert (remoteId != null) : "remoteId != null";
        this.remoteId = remoteId;
    }

    public void setVersionNumber(int versionNumber) {
        this.assertModifiableInvariant();
        this.versionNumber = versionNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.assertModifiableInvariant();
        assert (mimetype != null) : "mimetype != null";
        this.mimetype = mimetype;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(long contentSize) {
        this.assertModifiableInvariant();
        this.contentSize = contentSize;
    }

    public IThumbnail addThumbnail(IThumbnail thumbnail) {
        this.assertModifiableInvariant();
        assert (thumbnail != null) : "thumbnail != null";
        IThumbnail oldThumbnail = this.thumbnails.put(thumbnail.getType(), thumbnail);
        ((Thumbnail)thumbnail).setVersion(this);
        if (oldThumbnail != null) {
            ((Thumbnail)oldThumbnail).setVersion(null);
        }
        return oldThumbnail;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(80);
        result.append("(ID: ").append(this.getId());
        result.append(" | Version: ").append(this.versionNumber);
        result.append(" | Size: ").append(this.contentSize);
        if (this.mimetype != null) {
            result.append(" | Mimetype: ").append(this.mimetype);
        }
        result.append(')');
        return result.toString();
    }

    public String getModificationUserName() {
        return this.modificationUserName;
    }

    public void setModificationUserName(String modificationUser) {
        this.modificationUserName = modificationUser;
    }

    public void setProperty(String key, Object value) throws ModelException {
        this.assertModifiableInvariant();
        assert (key != null) : "key != null";
        assert (value != null) : "value != null";
        IVersionProperty versionProperty = this.properties.get(key);
        if (versionProperty == null) {
            versionProperty = AssetFactory.createVersionProperty(this, key, value);
            this.properties.put(key, versionProperty);
        } else {
            assert (versionProperty instanceof VersionProperty);
            ((VersionProperty)versionProperty).setValue(value);
        }
    }

    public void removeProperty(String key) {
        this.assertModifiableInvariant();
        assert (key != null) : "key != null";
        this.properties.remove(key);
    }

    public IVersionProperty[] getProperties() {
        Collection<IVersionProperty> values = this.properties.values();
        return values.toArray(new IVersionProperty[values.size()]);
    }

    public IVersionProperty getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean isWorkingCopy() {
        if (this.asset == null) {
            return false;
        }
        return this.asset.hasWorkingCopy() && this.equals(this.asset.getWorkingCopy());
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.assertModifiableInvariant();
        this.modificationTime = modificationTime / 1000L;
        this.modificationTime *= 1000L;
    }

    public IThumbnail getThumbnail(ThumbnailTypeEnum type) {
        return this.thumbnails.get((Object)type);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public IXMPMetadata getXmpMetadata() {
        return this.xmpMetadata;
    }

    public void setXmpMetadata(IXMPMetadata xmpMetadata) {
        this.assertModifiableInvariant();
        this.xmpMetadata = xmpMetadata;
        if (xmpMetadata != null) {
            ((XMPMetadata)xmpMetadata).setVersion(this);
        }
    }

    public String getPropertiesCache() {
        return this.propertiesCache;
    }

    public void setPropertiesCache(String propertiesCache) {
        this.assertModifiableInvariant();
        this.propertiesCache = propertiesCache;
    }

    public String getThumbnailCache() {
        return this.thumbnailCache;
    }

    public void setThumbnailCache(String thumbnailCache) {
        this.assertModifiableInvariant();
        this.thumbnailCache = thumbnailCache;
    }

    public String getXmpCache() {
        return this.xmpCache;
    }

    public void setXmpCache(String xmpCache) {
        this.assertModifiableInvariant();
        this.xmpCache = xmpCache;
    }

    public IVersion getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(IVersion baseVersion) {
        this.assertModifiableInvariant();
        this.baseVersion = baseVersion;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }
}

