/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.Asset;
import com.adobe.drive.data.internal.model.IPersistenceHook;
import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.internal.model.Version;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.IVNode;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.VNodeId;

public class VNode
extends ModelObject
implements IVNode,
IPersistenceHook {
    private IMountPoint mountPoint;
    private int mountPointId;
    private IAsset asset;
    private IVersion version;

    public VNode() {
    }

    public VNode(int id, IMountPoint mountPoint) {
        super(id);
        assert (mountPoint != null) : "mountPoint != null";
        this.mountPoint = mountPoint;
        this.mountPointId = mountPoint.getId();
    }

    public VNodeId getVNodeId() {
        return new VNodeId(this.getId());
    }

    public IMountPoint getMountPoint() {
        return this.mountPoint;
    }

    public int getMountPointId() {
        return this.mountPointId;
    }

    public IAsset getAsset() {
        if (this.asset == null) {
            throw new NullPointerException();
        }
        return this.asset;
    }

    public void setAsset(IAsset asset) {
        this.assertModifiableInvariant();
        assert (asset != null) : "asset != null";
        if (this.version != null) {
            ((Version)this.version).setVNode(null);
            this.version = null;
        }
        this.asset = asset;
    }

    public IVNode.Type getType() {
        return this.asset != null ? IVNode.Type.ASSET_NODE : IVNode.Type.VERSION_NODE;
    }

    public IVersion getVersion() {
        if (this.version == null) {
            throw new NullPointerException();
        }
        return this.version;
    }

    public void setVersion(IVersion version) {
        this.assertModifiableInvariant();
        assert (version != null) : "version != null";
        if (this.asset != null) {
            ((Asset)this.asset).setVNode(null);
            this.asset = null;
        }
        this.version = version;
    }

    public void onDelete() {
    }
}

