/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.model.asset.IThumbnail;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ThumbnailTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.Hibernate;

public class Thumbnail
extends ModelObject
implements IThumbnail {
    private IVersion version;
    private ThumbnailTypeEnum type;
    private int width;
    private int height;
    private String format;
    private Blob data;

    public Thumbnail() {
    }

    public Thumbnail(int id) {
        super(id);
        this.type = ThumbnailTypeEnum.SMALL;
    }

    public ThumbnailTypeEnum getType() {
        return this.type;
    }

    public void setType(ThumbnailTypeEnum type) {
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.assertModifiableInvariant();
        assert (width > 0) : "width > 0";
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.assertModifiableInvariant();
        assert (height > 0) : "height > 0";
        this.height = height;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.assertModifiableInvariant();
        assert (format != null) : "format != null";
        this.format = format;
    }

    public void setData(byte[] bytes) {
        this.assertModifiableInvariant();
        assert (bytes != null) : "bytes != null";
        this.data = Hibernate.createBlob((byte[])bytes);
    }

    public void setData(InputStream inputStream) throws IOException {
        this.assertModifiableInvariant();
        assert (inputStream != null) : "inputStream != null";
        this.data = Hibernate.createBlob((InputStream)inputStream);
    }

    public byte[] getBytes() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBytes(1L, (int)this.data.length());
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public InputStream getInputStream() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBinaryStream();
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public void setVersion(IVersion version) {
        this.version = version;
    }
}

