/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.internal.model.MountPoint;
import com.adobe.drive.data.model.IServer;
import com.adobe.drive.data.model.asset.IMountPoint;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class Server
extends ModelObject
implements IServer {
    private String name;
    private URI url;
    private String version;
    private String guid;
    private boolean local;
    private boolean autoMounted = false;
    private Set<IMountPoint> mountpoints = new HashSet<IMountPoint>();

    public Server() {
    }

    public Server(int id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean isLocal) {
        this.local = isLocal;
    }

    public boolean isAutoMounted() {
        return this.autoMounted;
    }

    public void setAutoMounted(boolean autoMounted) {
        this.autoMounted = autoMounted;
    }

    public IMountPoint[] getMountPoints() {
        return this.mountpoints.toArray(new IMountPoint[this.mountpoints.size()]);
    }

    public void addMountPoint(IMountPoint mountPoint) {
        this.internalAddMountPoint(mountPoint);
        ((MountPoint)mountPoint).internalSetServer(this);
    }

    public void internalAddMountPoint(IMountPoint mountPoint) {
        assert (mountPoint.getId() >= 0);
        this.mountpoints.add(mountPoint);
    }

    public void removeMountPoint(IMountPoint mountPoint) {
        this.internalRemoveMountPoint(mountPoint);
        ((MountPoint)mountPoint).internalSetServer(null);
    }

    private void internalRemoveMountPoint(IMountPoint mountPoint) {
        assert (mountPoint.getId() >= 0);
        this.mountpoints.remove(mountPoint);
    }
}

