/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.model.IScript;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ScriptTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.Hibernate;

public class Script
extends ModelObject
implements IScript {
    private IAsset asset;
    private ScriptTypeEnum type;
    private String mimetype;
    private boolean isCompiled;
    private Blob data;

    public Script() {
    }

    public Script(int id) {
        super(id);
    }

    public IAsset getAsset() {
        return this.asset;
    }

    public void setAsset(IAsset asset) {
        this.assertModifiableInvariant();
        assert (asset != null) : "asset != null";
        this.asset = asset;
    }

    public ScriptTypeEnum getType() {
        return this.type;
    }

    public void setType(ScriptTypeEnum type) {
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        this.type = type;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.assertModifiableInvariant();
        assert (mimetype != null) : "mimetype != null";
        this.mimetype = mimetype;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setIsCompiled(boolean isCompiled) {
        this.assertModifiableInvariant();
        this.isCompiled = isCompiled;
    }

    public void setDataBytes(byte[] bytes) {
        this.assertModifiableInvariant();
        assert (bytes != null) : "bytes != null";
        this.data = Hibernate.createBlob((byte[])bytes);
    }

    public void setDataStream(InputStream inputStream) throws ModelException {
        this.assertModifiableInvariant();
        assert (inputStream != null) : "inputStream != null";
        try {
            this.data = Hibernate.createBlob((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public byte[] getDataBytes() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBytes(1L, (int)this.data.length());
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public InputStream getDataStream() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBinaryStream();
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(80);
        result.append("(ID: ").append(this.getId());
        result.append(" | Asset: ").append(this.asset.getName());
        result.append(" | Type: ").append((Object)this.type);
        result.append(" | Mime-Type: ").append(this.mimetype);
        result.append(this.isCompiled() ? " | IsCompiled " : " | UnCompiled ");
        result.append(')');
        return result.toString();
    }
}

