/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.model.IResource;
import com.adobe.drive.data.model.asset.ModelException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.Hibernate;

public class Resource
extends ModelObject
implements IResource {
    private String name;
    private String type;
    private String mimetype;
    private Blob data;

    public Resource() {
    }

    public Resource(int id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public void setFormat(String name) {
        this.assertModifiableInvariant();
        assert (name != null) : "name != null";
        this.name = name;
    }

    public void setData(byte[] bytes) {
        this.assertModifiableInvariant();
        assert (bytes != null) : "bytes != null";
        this.data = Hibernate.createBlob((byte[])bytes);
    }

    public void setData(InputStream inputStream) throws IOException {
        this.assertModifiableInvariant();
        assert (inputStream != null) : "inputStream != null";
        this.data = Hibernate.createBlob((InputStream)inputStream);
    }

    public byte[] getBytes() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBytes(1L, (int)this.data.length());
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public InputStream getInputStream() throws ModelException {
        assert (this.data != null) : "data != null";
        try {
            return this.data.getBinaryStream();
        }
        catch (SQLException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        this.type = type;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.assertModifiableInvariant();
        assert (mimetype != null) : "mimetype != null";
        this.mimetype = mimetype;
    }
}

