/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.csi.core.logging.Logger;
import com.adobe.drive.data.internal.model.IPersistenceHook;
import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.internal.model.Server;
import com.adobe.drive.data.model.IServer;
import com.adobe.drive.data.model.asset.IMountPoint;
import java.net.URI;

public class MountPoint
extends ModelObject
implements IMountPoint,
IPersistenceHook {
    private static final transient Logger LOGGER = Logger.getLogger(MountPoint.class);
    private String localPath;
    private String username;
    private String password;
    private IServer server;
    private boolean active;

    public MountPoint() {
    }

    public MountPoint(int id) {
        super(id);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        if (this.localPath == null || localPath == null || this.localPath.equals(localPath)) {
            this.localPath = localPath;
        } else {
            StringBuffer logMsg = new StringBuffer(100);
            logMsg.append("Illegal change of Local URI:");
            logMsg.append(" Was: " + this.localPath);
            logMsg.append(" Is:  " + localPath);
            LOGGER.warn((Object)logMsg);
            this.localPath = localPath;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer server) {
        this.internalSetServer(server);
        ((Server)server).internalAddMountPoint(this);
    }

    void internalSetServer(IServer server) {
        this.server = server;
    }

    public URI getRemoteUri() {
        return this.getServer().getUrl();
    }

    public String getServerGuid() {
        return this.getServer().getGuid();
    }

    public void onDelete() {
        if (this.server != null) {
            ((Server)this.server).removeMountPoint(this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Local: ").append(this.localPath);
        result.append(" | Username: ").append(this.username);
        return result.toString();
    }
}

