/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.model.IModelObjectProperty;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import org.hibernate.Hibernate;

public class ModelObjectProperty
extends ModelObject
implements IModelObjectProperty {
    private String name;
    private IModelObjectProperty.Type type;
    private Integer intValue;
    private Float floatValue;
    private Date dateValue;
    private Boolean booleanValue;
    private String stringValue;
    private Blob binValue;

    public ModelObjectProperty() {
    }

    public ModelObjectProperty(int id) {
        super(id);
    }

    public String getKey() {
        return this.name;
    }

    public void setKey(String key) {
        this.assertModifiableInvariant();
        assert (key != null) : "key != null";
        this.name = key;
    }

    public Object getValue() {
        switch (this.type) {
            case INTEGER: {
                return this.intValue;
            }
            case FLOAT: {
                return this.floatValue;
            }
            case DATE: {
                return this.dateValue;
            }
            case BOOLEAN: {
                return this.booleanValue;
            }
            case STRING: {
                return this.stringValue;
            }
            case BINARY: {
                try {
                    return this.binValue.getBytes(1L, (int)this.binValue.length());
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
        }
        throw new IllegalStateException("Unknown value type.");
    }

    public void setValue(Object value) {
        this.assertModifiableInvariant();
        this.resetValueHolders();
        if (value instanceof Integer) {
            this.type = IModelObjectProperty.Type.INTEGER;
            this.intValue = (Integer)value;
        } else if (value instanceof Float) {
            this.type = IModelObjectProperty.Type.FLOAT;
            this.floatValue = (Float)value;
        } else if (value instanceof String) {
            this.type = IModelObjectProperty.Type.STRING;
            this.stringValue = (String)value;
        } else if (value instanceof Date) {
            this.type = IModelObjectProperty.Type.DATE;
            this.dateValue = (Date)value;
        } else if (value instanceof Boolean) {
            this.type = IModelObjectProperty.Type.BOOLEAN;
            this.booleanValue = (Boolean)value;
        } else if (value instanceof byte[]) {
            this.type = IModelObjectProperty.Type.BINARY;
            this.binValue = Hibernate.createBlob((byte[])((byte[])value));
        } else {
            if (value instanceof Serializable) {
                throw new UnsupportedOperationException("Serializable not yet supported.");
            }
            throw new IllegalStateException("Unknown value type.");
        }
    }

    public IModelObjectProperty.Type getType() {
        return this.type;
    }

    public Blob getBinaryValue() {
        if (this.type == IModelObjectProperty.Type.BINARY) {
            return this.binValue;
        }
        throw new IllegalStateException("Bad type: " + (Object)((Object)this.type));
    }

    private void resetValueHolders() {
        this.assertModifiableInvariant();
        if (this.type != null) {
            switch (this.type) {
                case INTEGER: {
                    this.intValue = null;
                    break;
                }
                case FLOAT: {
                    this.floatValue = null;
                    break;
                }
                case DATE: {
                    this.dateValue = null;
                    break;
                }
                case BOOLEAN: {
                    this.booleanValue = null;
                    break;
                }
                case STRING: {
                    this.stringValue = null;
                    break;
                }
                case BINARY: {
                    this.binValue = null;
                    break;
                }
            }
        }
    }
}

