/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IAssetReference;
import com.adobe.drive.utils.Base64Strategy;

public class AssetReference
implements IAssetReference {
    public static final String DELIMITER = "\u0000";
    private String encodedRefString;
    private String decodedRefString;
    private String serverGUID;
    private String path;
    private String remoteProjectId;
    private String remoteAssetId;
    private String namespace;

    public AssetReference(IAsset asset) {
        assert (asset != null) : "asset != null";
        this.serverGUID = asset.getMountPoint().getServer().getGuid();
        this.remoteProjectId = "";
        if (asset.getProjectId() != null) {
            try {
                IAsset project = AssetFactory.findAssetById(asset.getProjectId());
                this.remoteProjectId = project.getRemoteId();
            }
            catch (DriveException e) {
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.remoteAssetId = asset.getRemoteId();
        this.path = asset.getPath();
        this.namespace = asset.getNamespace();
        this.createReference();
    }

    public AssetReference(String reference) {
        assert (reference != null) : "reference != null";
        this.encodedRefString = reference;
        this.createFromReference();
    }

    protected void createReference() {
        assert (this.serverGUID != null) : "assert serverGUID != null";
        assert (this.remoteProjectId != null) : "assert projectId != null";
        assert (this.remoteAssetId != null) : "assert assetId != null";
        assert (this.path != null) : "assert path != null";
        StringBuilder result = new StringBuilder(80);
        result.append(this.serverGUID).append(DELIMITER).append(this.namespace != null ? this.namespace : "").append(DELIMITER).append(this.remoteAssetId).append(DELIMITER).append(this.remoteProjectId).append(DELIMITER).append(this.path);
        this.decodedRefString = result.toString();
        this.encodedRefString = Base64Strategy.encodeToString((byte[])this.decodedRefString.getBytes());
    }

    protected void createFromReference() {
        assert (this.encodedRefString != null) : "encodedRefString != null";
        byte[] decodedBytes = Base64Strategy.decodeFromString((String)this.encodedRefString);
        this.decodedRefString = new String(decodedBytes);
        String[] parts = this.decodedRefString.split(DELIMITER);
        if (parts.length == 5) {
            this.serverGUID = parts[0];
            this.namespace = parts[1];
            this.remoteAssetId = parts[2];
            this.remoteProjectId = parts[3];
            this.path = parts[4];
            if (this.namespace.length() == 0) {
                this.namespace = null;
            }
        }
    }

    public String getReference() {
        return this.encodedRefString;
    }

    public String getServerGUID() {
        return this.serverGUID;
    }

    public String getPath() {
        return this.path;
    }

    public String getRemoteProjectId() {
        return this.remoteProjectId;
    }

    public String getRemoteAssetId() {
        return this.remoteAssetId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append(this.getClass().getName()).append(":\n");
        buffer.append("asset id: ").append(this.remoteAssetId).append("\n");
        buffer.append("asset namespace: ").append(this.namespace).append("\n");
        buffer.append("project id: ").append(this.remoteProjectId).append("\n");
        buffer.append("server guid: ").append(this.serverGUID).append("\n");
        buffer.append("asset path: ").append(this.path).append("\n");
        buffer.append("asset reference decoded: ").append(this.decodedRefString).append("\n");
        buffer.append("asset reference encoded: ").append(this.encodedRefString).append("\n");
        return buffer.toString();
    }

    protected boolean isComplete() {
        return this.encodedRefString != null && this.decodedRefString != null && this.serverGUID != null && this.remoteAssetId != null && this.remoteProjectId != null && this.path != null;
    }
}

