/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.model;

import com.adobe.drive.data.internal.model.AssetProperty;
import com.adobe.drive.data.internal.model.ModelObject;
import com.adobe.drive.data.internal.model.Version;
import com.adobe.drive.data.internal.model.VersionComparator;
import com.adobe.drive.data.model.IScript;
import com.adobe.drive.data.model.ScriptFactory;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.AssetTypeEnum;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IAssetProperty;
import com.adobe.drive.data.model.asset.ILock;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.IVNode;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.IVersionProperty;
import com.adobe.drive.data.model.asset.LockState;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ScriptTypeEnum;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.asset.Visibility;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Asset
extends ModelObject
implements IAsset {
    private IVNode vnode;
    private String remoteId;
    private AssetTypeEnum type;
    private String namespace;
    private String name;
    private long creationTime;
    private long modificationTime;
    private ILock lock;
    private Integer lockId;
    private Integer projectId;
    private String path;
    private Integer parentId;
    private String reference;
    private IVersion headVersion;
    private IVersion workingCopy;
    private Integer workingCopyId;
    private Set<IVersion> versions;
    private Map<String, IAssetProperty> properties = new HashMap<String, IAssetProperty>();
    private Visibility visibility = Visibility.VISIBLE;
    private boolean isProtected;
    private IAsset linkedAsset;
    private String basicCache;
    private String propertiesCache;
    private String versionsCache;
    private Integer childBasicCache;
    private Integer childPropertiesCache;
    private Integer childVersionsCache;
    private Set<IScript> scripts = new HashSet<IScript>();

    public Asset() {
    }

    public Asset(int id, AssetTypeEnum type, String namespace, IVNode vnode) {
        super(id);
        assert (type != null) : "type != null";
        assert (vnode != null) : "vnode != null";
        this.namespace = namespace;
        this.vnode = vnode;
        vnode.setAsset(this);
        this.type = type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public VNodeId getVNodeId() {
        return this.vnode.getVNodeId();
    }

    public IVNode getVNode() {
        return this.vnode;
    }

    public void setVNode(IVNode vnode) {
        this.vnode = vnode;
        vnode.setAsset(this);
    }

    public IMountPoint getMountPoint() {
        return this.vnode.getMountPoint();
    }

    public int getMountPointId() {
        return this.vnode.getMountPointId();
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.assertModifiableInvariant();
        assert (name != null) : "name != null";
        this.name = name;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.assertModifiableInvariant();
        this.creationTime = creationTime / 1000L;
        this.creationTime *= 1000L;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.assertModifiableInvariant();
        this.modificationTime = modificationTime / 1000L;
        this.modificationTime *= 1000L;
    }

    public boolean isContainer() {
        return this.type.isContainer();
    }

    public IVersion getHeadVersion() {
        return this.headVersion;
    }

    public void addVersion(IVersion version, boolean isHead) {
        this.assertModifiableInvariant();
        assert (version != null) : "version != null";
        assert (this.type == AssetTypeEnum.FILE || this.type == AssetTypeEnum.FILE_LOCAL) : "assetType == AssetTypeEnum.FILE";
        if (this.versions == null) {
            this.versions = new TreeSet<IVersion>(new VersionComparator());
        }
        this.versions.add(version);
        if (isHead) {
            this.headVersion = version;
        }
    }

    public boolean removeVersion(IVersion version) {
        this.assertModifiableInvariant();
        assert (this.type == AssetTypeEnum.FILE || this.type == AssetTypeEnum.FILE_LOCAL) : "assetType == AssetTypeEnum.FILE";
        if (this.versions == null || version == null || !this.versions.contains(version)) {
            return false;
        }
        if (version.equals(this.headVersion)) {
            this.headVersion = null;
        }
        if (version.equals(this.workingCopy)) {
            this.workingCopy = null;
            this.workingCopyId = null;
        }
        this.versions.remove(version);
        return true;
    }

    public IVersion[] getVersions() {
        if (this.versions == null || this.versions.size() == 0) {
            return new IVersion[0];
        }
        IVersion[] result = new IVersion[this.versions.size()];
        this.versions.toArray(result);
        return result;
    }

    public boolean hasLock() {
        return this.lockId != null;
    }

    public ILock getLock() {
        return this.lock;
    }

    public void setLock(ILock lock) {
        this.assertModifiableInvariant();
        assert (lock != null) : "lock != null";
        assert (this.lock == null) : "this.lock == null";
        this.lock = lock;
        this.lockId = lock.getId();
    }

    public ILock removeLock() {
        this.assertModifiableInvariant();
        assert (this.lock != null) : "lock != null";
        assert (this.lock != null) : "this.lock != null";
        ILock result = this.lock;
        this.lock = null;
        this.lockId = null;
        return result;
    }

    public void setProperty(String key, Object value) throws ModelException {
        this.assertModifiableInvariant();
        assert (key != null) : "key != null";
        assert (value != null) : "value != null";
        IAssetProperty assetProperty = this.properties.get(key);
        if (assetProperty == null) {
            assetProperty = AssetFactory.createAssetProperty(this, key, value);
            this.properties.put(key, assetProperty);
        } else {
            assert (assetProperty instanceof AssetProperty);
            ((AssetProperty)assetProperty).setValue(value);
        }
    }

    public void removeProperty(String key) {
        this.assertModifiableInvariant();
        assert (key != null) : "key != null";
        this.properties.remove(key);
    }

    public IAssetProperty[] getProperties() {
        Collection<IAssetProperty> values = this.properties.values();
        return values.toArray(new IAssetProperty[values.size()]);
    }

    public IAssetProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(80);
        result.append("(ID: ").append(this.getId());
        result.append(" | ").append(this.name);
        result.append(" | ").append((Object)this.type);
        result.append(" | ").append((Object)this.visibility);
        if (this.hasLock()) {
            result.append(" | Has Lock");
        }
        if (this.hasWorkingCopy()) {
            result.append(" | Has Working Copy");
        }
        result.append(')');
        return result.toString();
    }

    public AssetTypeEnum getType() {
        return this.type;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.assertModifiableInvariant();
        this.path = path;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.assertModifiableInvariant();
        this.parentId = parentId;
    }

    public boolean hasWorkingCopy() {
        return this.workingCopyId != null;
    }

    public IVersion createWorkingCopy() throws ModelException {
        IVersionProperty[] versionProperties;
        IVersion hd = this.getHeadVersion();
        IVersion wc = AssetFactory.createVersion(this, false);
        this.removeVersion(wc);
        wc.setContentSize(hd == null ? 0L : hd.getContentSize());
        wc.setModificationTime(this.getModificationTime());
        wc.setVersionNumber(hd == null ? 1 : hd.getVersionNumber() + 1);
        wc.setBaseVersion(hd);
        IVersionProperty[] iVersionPropertyArray = versionProperties = hd == null ? new IVersionProperty[]{} : hd.getProperties();
        int n = versionProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionProperty versionProperty = iVersionPropertyArray[n2];
            wc.setProperty(versionProperty.getKey(), versionProperty.getValue());
            ++n2;
        }
        this.addVersion(wc, false);
        this.setWorkingCopy(wc);
        return wc;
    }

    public IVersion removeWorkingCopy() throws ModelException {
        IVersion wc = null;
        if (this.hasWorkingCopy()) {
            wc = this.getWorkingCopy();
            this.removeVersion(wc);
            this.setWorkingCopy(null);
            wc.setBaseVersion(null);
        }
        return wc;
    }

    public IVersion getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(IVersion version) {
        this.assertModifiableInvariant();
        if (version != null && !this.equals(version.getAsset())) {
            throw new IllegalArgumentException("Cannot set " + version + " as working copy of " + this + ", belongs to " + version.getAsset());
        }
        this.workingCopy = version;
        this.workingCopyId = version != null ? Integer.valueOf(version.getId()) : null;
    }

    public void swapWorkingCopy(IAsset source) {
        this.assertModifiableInvariant();
        assert (source != null) : "source != null";
        if (this.equals(source)) {
            return;
        }
        Asset src = (Asset)source;
        Version srcWorkingCopy = (Version)src.getWorkingCopy();
        Version myWorkingCopy = (Version)this.workingCopy;
        src.removeVersion(srcWorkingCopy);
        this.removeVersion(myWorkingCopy);
        this.adoptWorkingCopy(srcWorkingCopy);
        src.adoptWorkingCopy(myWorkingCopy);
    }

    private void adoptWorkingCopy(Version version) {
        if (version == null) {
            this.setWorkingCopy(null);
            return;
        }
        version.setAsset(this);
        if (this.headVersion != null) {
            version.setVersionNumber(this.headVersion.getVersionNumber() + 1);
        } else {
            version.setVersionNumber(1);
        }
        this.addVersion(version, false);
        this.setWorkingCopy(version);
    }

    public void setHeadVersion(IVersion version) {
        this.assertModifiableInvariant();
        if (version != null && !this.equals(version.getAsset())) {
            throw new IllegalArgumentException("Cannot set " + version + " as head of " + this + ", belongs to " + version.getAsset());
        }
        this.headVersion = version;
    }

    public boolean isDeleted() {
        return this.visibility == Visibility.HIDDEN_DELETED || this.visibility == Visibility.DELETED;
    }

    public void setDeleted(boolean deleted) {
        if (deleted) {
            switch (this.visibility) {
                case VISIBLE: {
                    this.setVisibility(Visibility.DELETED);
                    break;
                }
            }
        } else {
            switch (this.visibility) {
                case DELETED: {
                    this.setVisibility(Visibility.VISIBLE);
                    break;
                }
            }
        }
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getReference() {
        return this.reference;
    }

    public LockState getLockState() {
        if (!this.hasLock()) {
            return LockState.UNLOCKED;
        }
        return this.lock.isMyLock() ? LockState.LOCKED_BY_ME : LockState.LOCKED_BY_OTHER;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        if (this.visibility != visibility) {
            this.visibility = visibility;
        }
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getBasicCache() {
        return this.basicCache;
    }

    public void setBasicCache(String basicCache) {
        this.assertModifiableInvariant();
        this.basicCache = basicCache;
    }

    public String getPropertiesCache() {
        return this.propertiesCache;
    }

    public void setPropertiesCache(String propertiesCache) {
        this.assertModifiableInvariant();
        this.propertiesCache = propertiesCache;
    }

    public String getVersionsCache() {
        return this.versionsCache;
    }

    public void setVersionsCache(String versionsCache) {
        this.assertModifiableInvariant();
        this.versionsCache = versionsCache;
    }

    public Integer getChildBasicCache() {
        return this.childBasicCache;
    }

    public void setChildBasicCache(Integer childBasicCache) {
        this.assertModifiableInvariant();
        this.childBasicCache = childBasicCache;
    }

    public Integer getChildPropertiesCache() {
        return this.childPropertiesCache;
    }

    public void setChildPropertiesCache(Integer childPropertiesCache) {
        this.assertModifiableInvariant();
        this.childPropertiesCache = childPropertiesCache;
    }

    public Integer getChildVersionsCache() {
        return this.childVersionsCache;
    }

    public void setChildVersionsCache(Integer childVersionsCache) {
        this.assertModifiableInvariant();
        this.childVersionsCache = childVersionsCache;
    }

    public IScript[] getScripts(ScriptTypeEnum scriptType) {
        assert (scriptType != null) : "scriptType != null";
        if (this.scripts != null) {
            HashSet<IScript> outScripts = new HashSet<IScript>();
            for (IScript script : this.scripts) {
                if (scriptType != ScriptTypeEnum.ALL && !script.getType().equals((Object)scriptType)) continue;
                outScripts.add(script);
            }
            IScript[] result = new IScript[outScripts.size()];
            return outScripts.toArray(result);
        }
        return new IScript[0];
    }

    public IScript addScript(ScriptTypeEnum type, String mimetype, boolean isCompiled, InputStream data) throws ModelException {
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        assert (mimetype != null) : "mimetype != null";
        assert (data != null) : "data != null";
        IScript script = ScriptFactory.useModelCache().createScript(this, type, mimetype, isCompiled, data);
        this.scripts.add(script);
        return script;
    }

    public void removeScript(ScriptTypeEnum type) {
        IScript[] toDelScripts;
        this.assertModifiableInvariant();
        assert (type != null) : "type != null";
        IScript[] iScriptArray = toDelScripts = this.getScripts(type);
        int n = toDelScripts.length;
        int n2 = 0;
        while (n2 < n) {
            IScript script = iScriptArray[n2];
            this.scripts.remove(script);
            ++n2;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.assertModifiableInvariant();
        this.isProtected = isProtected;
    }

    public void changeType(AssetTypeEnum type) {
        this.type = type;
    }

    public IAsset getLinkedAsset() {
        return this.linkedAsset;
    }

    public void setLinkedAsset(IAsset asset) {
        this.assertModifiableInvariant();
        this.linkedAsset = asset;
    }
}

