/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.webos;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.ProcessResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;

public class WebOsEmulator
extends DreamweaverBase {
    public String host = "localhost";
    public int port = 5522;
    String user = "root";
    String password = "";
    long MAX_TIME = 420L;
    public String path;
    public String emulator_type;
    public String log_file = null;
    static boolean DEBUG = true;
    public String palm_install = null;
    public String palm_emulator = null;
    public String palm_launch = null;

    public static void main(String[] stringArray) throws Exception {
        WebOsEmulator webOsEmulator = new WebOsEmulator();
        webOsEmulator.path = "/opt/PalmSDK/0.1/bin";
        webOsEmulator.emulator_type = "SDK 3.0.5.676 (1024x768)";
        webOsEmulator.log_file = "/Users/hardeep/webos_log.txt";
        String string = "/Users/hardeep/Downloads/com.example.app_1.0.0_all.ipk";
        String string2 = "com.example.app";
        try {
            webOsEmulator.start_install_and_run(string, string2);
            WebOsEmulator.debug_log("complete");
        }
        catch (Exception exception) {
            WebOsEmulator.debug_log(exception.getMessage());
        }
    }

    public WebOsEmulator() {
        if (WebOsEmulator.isMac()) {
            this.palm_emulator = "palm-emulator";
            this.palm_install = "palm-install";
            this.palm_launch = "palm-launch";
        } else {
            this.palm_emulator = "palm-emulator.bat";
            this.palm_install = "palm-install.bat";
            this.palm_launch = "palm-launch.bat";
        }
    }

    static String buildCommand(String string, String string2) throws Exception {
        if (WebOsEmulator.isMac()) {
            return string + "/" + string2;
        }
        return string + "\\" + string2;
    }

    public void launchEmulator() throws Exception {
        ProcessResult processResult = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_emulator), "--start", this.emulator_type});
        if (processResult.process.exitValue() > 0) {
            throw new Exception(processResult.errOut.replaceAll("\r\n", ""));
        }
    }

    public HashMap<Integer, String> listEmulators() throws Exception {
        ProcessResult processResult = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_emulator), "--list"});
        String string = processResult.stdOut;
        String[] stringArray = string.split("\\r?\\n");
        if (stringArray.length < 1) {
            throw new Exception("No valid images found");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 1; i < stringArray.length; ++i) {
            hashMap.put(i - 1, stringArray[i]);
        }
        return hashMap;
    }

    public void install(String string, long l) throws Exception {
        long l2;
        SshClient sshClient = null;
        boolean bl = false;
        boolean bl2 = false;
        ProcessResult processResult = null;
        try {
            sshClient = SshClient.setUpDefaultClient();
            WebOsEmulator.debug_log("starting client");
            sshClient.start();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.getMessage());
        }
        long l3 = l2 = System.currentTimeMillis() / 1000L;
        WebOsEmulator.debug_log("connecting to emulator.");
        WebOsEmulator.debug_log("waiting a total of " + l + " seconds ...");
        while (l3 < l2 + l) {
            WebOsEmulator.debug_log("current time " + l3 + " waiting until " + (l2 + l));
            ConnectFuture connectFuture = null;
            try {
                connectFuture = (ConnectFuture)sshClient.connect(this.host, this.port).await();
            }
            catch (Exception exception) {
                throw new Exception("failed to connect to the emulator");
            }
            try {
                if (connectFuture.isConnected()) {
                    boolean bl3;
                    WebOsEmulator.debug_log("current times " + l3 + " waiting until " + (l2 + l));
                    bl = true;
                    ClientSession clientSession = connectFuture.getSession();
                    bl2 = bl3 = ((AuthFuture)clientSession.authPassword(this.user, this.password).await()).isSuccess();
                    if (bl2) {
                        break;
                    }
                }
            }
            catch (Exception exception) {
                WebOsEmulator.debug_log(exception.getMessage());
                throw new Exception("failed to authenticate with the emulator: " + exception.getMessage());
            }
            l3 = System.currentTimeMillis() / 1000L;
        }
        if (!bl || !bl2) {
            throw new Exception("failed to connect to the emulator");
        }
        processResult = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_install), string});
        if (processResult.process.exitValue() > 0) {
            throw new Exception(processResult.errOut.replaceAll("\r\n", ""));
        }
        try {
            sshClient.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void install(String string) throws Exception {
        this.install(string, this.MAX_TIME);
    }

    public void run(String string) throws Exception {
        ProcessResult processResult = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_launch), string});
        if (processResult.process.exitValue() > 0) {
            throw new Exception(processResult.errOut.replaceAll("\r\n", ""));
        }
    }

    public boolean start_install_and_run(String string, String string2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            WebOsEmulator.debug_log("file does not exist");
            throw new Exception("file " + string + " does not exist.");
        }
        this.log(WebOsEmulator.build_json("pending", "trying to install application"));
        try {
            this.install(string, 2L);
            this.log(WebOsEmulator.build_json("pending", "installed: " + string2));
        }
        catch (Exception exception) {
            this.log(WebOsEmulator.build_json("pending", "emulator not running. launching emulator: " + this.emulator_type));
            this.launchEmulator();
            this.log(WebOsEmulator.build_json("pending", "trying to install application once emulator has booted"));
            this.install(string);
        }
        this.log(WebOsEmulator.build_json("pending", "attempting to run application"));
        this.run(string2);
        this.log(WebOsEmulator.build_json("complete", "running application"));
        return true;
    }

    public static String build_json(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", string);
        hashMap.put("message", string2);
        return WebOsEmulator.build_json(hashMap);
    }

    public static String build_json(HashMap hashMap) {
        String string = "";
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        String string2 = ",";
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof HashMap) {
                string = string + "\"" + entry.getKey() + "\":" + WebOsEmulator.build_json((HashMap)entry.getValue());
                string = string + (iterator.hasNext() ? "," : "");
                continue;
            }
            string = string + "\"" + entry.getKey() + "\": " + WebOsEmulator.return_correct_type(entry.getValue());
            string = string + (iterator.hasNext() ? "," : "");
        }
        return "{" + string + "}";
    }

    static Object return_correct_type(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Boolean) {
            return Boolean.toString((Boolean)object);
        }
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        return "\"" + object.toString() + "\"";
    }

    public static void debug_log(Object object) {
        if (DEBUG) {
            System.out.println("debug:\t" + object.toString());
        }
    }

    public void log(String string) throws Exception {
        WebOsEmulator.debug_log("writing to file: " + this.log_file + " \n\twith contents => " + string);
        FileWriter fileWriter = new FileWriter(this.log_file, false);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string);
        bufferedWriter.close();
    }
}

