/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.android;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.android.AndroidDevice;
import com.phonegap.build.android.AndroidException;
import com.phonegap.build.android.AndroidShell;
import com.phonegap.build.android.AndroidTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidState
extends DreamweaverBase {
    public ArrayList<AndroidDevice> devices = new ArrayList();
    public ArrayList<AndroidTarget> targets = new ArrayList();
    public ArrayList<AndroidTarget> avds = new ArrayList();

    public static AndroidState GetCurrent(String string) throws AndroidException {
        String string2 = System.getProperty("os.name").toLowerCase();
        Boolean bl = AndroidState.isMac();
        String string3 = string + File.separator + "tools" + File.separator + "android" + (bl != false ? "" : ".bat");
        String string4 = string + File.separator + "platform-tools" + File.separator + "adb" + (bl != false ? "" : ".exe");
        AndroidState.debug_log("Listing sdks");
        AndroidState.debug_log(string3);
        AndroidState.debug_log(string4);
        if (!new File(string4).exists()) {
            throw new AndroidException("noplatformtools");
        }
        AndroidState androidState = new AndroidState();
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{string3, "list"};
        try {
            Object object;
            String string5;
            String string6;
            Process process = runtime.exec(stringArray);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            Boolean bl2 = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string6 = bufferedReader.readLine()) != null) {
                if ((string6 = string6 + "\n").contains("Available Android targets:")) {
                    bl2 = true;
                }
                if (string6.contains("Available Android Virtual Devices:")) {
                    bl2 = false;
                }
                if (string6.contains("could not be loaded:")) break;
                if (bl2.booleanValue()) {
                    stringBuilder.append(string6);
                    continue;
                }
                stringBuilder2.append(string6);
            }
            bufferedReader.close();
            process.waitFor();
            AndroidState.debug_log("Parsing sdks");
            AndroidState.debug_log("----------------");
            Pattern pattern = Pattern.compile("id: ([0-9]*)", 8);
            Pattern pattern2 = Pattern.compile("Name: (.*)", 8);
            Pattern pattern3 = Pattern.compile("Based on (.*)\\(.*?", 8);
            Pattern pattern4 = Pattern.compile("Target: (.*)\\(.*?", 8);
            String[] stringArray2 = stringBuilder.toString().split("(?=\nid:)");
            for (int i = 0; i < stringArray2.length; ++i) {
                String string7 = "";
                string5 = "";
                if (stringArray2[i].contains("no ABIs.") || !((Matcher)(object = pattern.matcher(stringArray2[i]))).find()) continue;
                string7 = ((Matcher)object).group(1).trim();
                object = pattern2.matcher(stringArray2[i]);
                if (((Matcher)object).find()) {
                    string5 = ((Matcher)object).group(1).trim();
                }
                if (((Matcher)(object = pattern3.matcher(stringArray2[i]))).find()) {
                    string5 = ((Matcher)object).group(1).trim() + " - " + string5;
                }
                AndroidState.debug_log(string7 + " = " + string5);
                androidState.targets.add(new AndroidTarget(string7, string5));
            }
            AndroidState.debug_log(" = ");
            String[] stringArray3 = stringBuilder2.toString().split("(?=Name:)");
            for (int i = 0; i < stringArray3.length; ++i) {
                string5 = "";
                object = "";
                Matcher matcher = pattern2.matcher(stringArray3[i]);
                if (!matcher.find()) continue;
                string5 = matcher.group(1).trim();
                matcher = pattern4.matcher(stringArray3[i]);
                if (matcher.find()) {
                    object = matcher.group(1).trim();
                }
                if ((matcher = pattern3.matcher(stringArray3[i])).find()) {
                    object = matcher.group(1).trim() + " - " + (String)object;
                }
                AndroidState.debug_log(string5 + " = " + (String)object);
                androidState.avds.add(new AndroidTarget(string5, (String)object));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        androidState.updateDevices(string4);
        AndroidState.debug_log("Returning result");
        return androidState;
    }

    public void updateDevices(String string) {
        String string2;
        Object object;
        Runtime runtime = Runtime.getRuntime();
        AndroidState.debug_log("Listing devices");
        String[] stringArray = new String[]{string, "devices"};
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Process process = runtime.exec(stringArray);
            object = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (string2.trim().contentEquals("") || string2.startsWith("*") || string2.startsWith("List of")) continue;
                arrayList.add(string2);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AndroidState.debug_log("Parsing devices");
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            if (string2.startsWith("emulator")) {
                Object object2 = object = string2.split("\\s+")[0];
                try {
                    int n = Integer.parseInt(string2.split("\\s+")[0].split("-")[1]);
                    AndroidShell androidShell = new AndroidShell("localhost", n);
                    object2 = androidShell.sendCommand("avd name").split("\n")[1].trim();
                    androidShell.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.devices.add(new AndroidDevice((String)object2, (String)object, false));
                continue;
            }
            object = string2.split("\\s+")[0];
            this.devices.add(new AndroidDevice((String)object, (String)object, true));
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.targets.size(); ++i) {
            jSONArray.put(this.targets.get(i).toJSON());
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < this.avds.size(); ++i) {
            jSONArray2.put(this.avds.get(i).toJSON());
        }
        JSONArray jSONArray3 = new JSONArray();
        for (int i = 0; i < this.devices.size(); ++i) {
            jSONArray3.put(this.devices.get(i).toJSON());
        }
        jSONObject.put("targets", jSONArray);
        jSONObject.put("avds", jSONArray2);
        jSONObject.put("devices", jSONArray3);
        return jSONObject;
    }
}

