/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.android;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.ProcessResult;
import com.phonegap.build.android.AndroidDevice;
import com.phonegap.build.android.AndroidException;
import com.phonegap.build.android.AndroidLog;
import com.phonegap.build.android.AndroidState;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Android
extends DreamweaverBase {
    public static void listSDKs(String string, String string2) throws Exception {
        try {
            AndroidState androidState = AndroidState.GetCurrent(string);
            Android.write_json(string2, androidState.toJSON());
        }
        catch (AndroidException androidException) {
            Android.error(string2, androidException.getMessage());
        }
    }

    public static void launchAVDManager(String string) throws Exception {
        String string2 = string + File.separator + "tools" + File.separator + "android" + (Android.isMac() ? "" : ".bat");
        Android.debug_log("Launching AVD manager");
        try {
            Android.commandLine(new String[]{string2, "avd"}, true, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void run(String string, String string2, String string3, String string4) throws Exception {
        AndroidLog androidLog = new AndroidLog("running", "");
        try {
            Android.run(androidLog, string, string2, string3, string4);
            androidLog.state = "success";
            Android.writeAndroidLog(string4, androidLog, "Application running");
        }
        catch (AndroidException androidException) {
            androidLog.state = "error";
            Android.writeAndroidLog(string4, androidLog, androidException.getMessage());
        }
    }

    public static void createAVD(String string, String string2, String string3, String string4) throws Exception {
        try {
            Android.createAVD(string, string2, string3);
            Android.success(string4, "AVD created");
        }
        catch (AndroidException androidException) {
            Android.error(string4, androidException.getMessage());
        }
    }

    private static void writeAndroidLog(String string, AndroidLog androidLog, String string2) throws Exception {
        androidLog.AddLog(string2);
        Android.write_json(string, androidLog.toJSON());
    }

    private static void run(AndroidLog androidLog, String string, String string2, String string3, String string4) throws Exception {
        Object object;
        Object object2;
        int n;
        String string5 = string + File.separator + "tools" + File.separator + "emulator" + (Android.isMac() ? "" : ".exe");
        String string6 = string + File.separator + "platform-tools" + File.separator + "adb" + (Android.isMac() ? "" : ".exe");
        String string7 = string + File.separator + "platform-tools" + File.separator + "aapt" + (Android.isMac() ? "" : ".exe");
        Android.writeAndroidLog(string4, androidLog, "Finding device/emulator ...");
        AndroidState androidState = new AndroidState();
        androidState.updateDevices(string6);
        ProcessResult processResult = null;
        Android.debug_log("Finding device/emulator");
        AndroidDevice androidDevice = null;
        for (n = 0; n < androidState.devices.size(); ++n) {
            object2 = androidState.devices.get(n);
            if (!((AndroidDevice)object2).name.contentEquals(string3)) continue;
            androidDevice = object2;
            Android.debug_log("Found running device");
            if (androidDevice.isDevice.booleanValue()) {
                Android.writeAndroidLog(string4, androidLog, "Found device");
                continue;
            }
            Android.writeAndroidLog(string4, androidLog, "Found running emulator");
        }
        if (androidDevice == null) {
            Android.writeAndroidLog(string4, androidLog, "Starting emulator: " + string3);
            Android.debug_log("Running emulator: " + string3);
            try {
                processResult = Android.commandLine(new String[]{string5, "-avd", string3, "-memory", "256"}, true, "");
            }
            catch (Exception exception) {
                Android.debug_log(exception.toString());
                throw new AndroidException("Cannot start emulator");
            }
            Thread.sleep(2000L);
            try {
                processResult = Android.commandLine(new String[]{string6, "kill-server"}, false, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                processResult = Android.commandLine(new String[]{string6, "start-server"}, false, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Android.debug_log("Get serial");
            object2 = false;
            block7: for (n = 0; n < 12 && androidDevice == null; ++n) {
                Thread.sleep(5000L);
                androidState.updateDevices(string6);
                for (int i = 0; i < androidState.devices.size(); ++i) {
                    AndroidDevice androidDevice2 = androidState.devices.get(i);
                    if (!androidDevice2.name.contentEquals(string3)) continue;
                    androidDevice = androidDevice2;
                    object2 = true;
                    continue block7;
                }
            }
            if (!((Boolean)object2).booleanValue()) {
                throw new AndroidException("Cannot find emulator");
            }
            Android.debug_log("Wait for device");
            Android.writeAndroidLog(string4, androidLog, "Waiting for emulator ...");
            Android.debug_log("Wait for package manager");
            Thread.sleep(10000L);
            object = false;
            object2 = false;
            for (int i = 0; i < 60; ++i) {
                Thread.sleep(5000L);
                processResult = Android.commandLine(new String[]{string6, "-s", androidDevice.serial, "shell", "pm", "path", "android"});
                if (processResult.process.exitValue() == 0) {
                    object = true;
                    if (!processResult.stdOut.startsWith("package")) continue;
                    object2 = true;
                    break;
                }
                if (!((Boolean)object).booleanValue()) continue;
                throw new AndroidException("Cannot find emulator");
            }
            if (!((Boolean)object2).booleanValue()) {
                throw new AndroidException("Cannot find emulator");
            }
        }
        Android.debug_log("Unlocking emulator");
        processResult = Android.commandLine(new String[]{string6, "-s", androidDevice.serial, "shell", "input", "keyevent", "82"});
        Android.debug_log("Emulator unlocked");
        Android.debug_log("Install app");
        Android.writeAndroidLog(string4, androidLog, "Installing application ...");
        processResult = Android.commandLine(new String[]{string6, "-s", androidDevice.serial, "install", "-r", string2});
        if (processResult.process.exitValue() > 0) {
            throw new AndroidException("Could not install application");
        }
        Android.debug_log("App installed");
        Android.debug_log("Run app");
        Android.writeAndroidLog(string4, androidLog, "Running application ...");
        processResult = Android.commandLine(new String[]{string7, "dump", "badging", string2});
        Pattern pattern = Pattern.compile("launchable-activity: name='(.*?)'", 8);
        object2 = pattern.matcher(processResult.stdOut);
        object = "";
        if (((Matcher)object2).find()) {
            object = ((Matcher)object2).group(1).trim();
        }
        object = Android.replaceLast((String)object, ".", "/.");
        Android.debug_log(object);
        processResult = Android.commandLine(new String[]{string6, "-s", androidDevice.serial, "shell", "am", "start", "-a", "android.intent.action.MAIN", "-n", object});
        if (processResult.process.exitValue() > 0) {
            throw new AndroidException("Could not run application");
        }
        Android.debug_log("App running");
    }

    private static void createAVD(String string, String string2, String string3) throws Exception {
        String string4 = string + File.separator + "tools" + File.separator + "android" + (Android.isMac() ? "" : ".bat");
        Android.debug_log("Creating avd: " + string3 + " (id=" + string2 + ")");
        try {
            ProcessResult processResult = Android.commandLine(new String[]{string4, "create", "avd", "-n", string3, "-t", string2, "-f"}, false, "no");
            if (processResult.process.exitValue() > 0) {
                throw new AndroidException("Could not create AVD");
            }
        }
        catch (IOException iOException) {
            throw new AndroidException("Could not create AVD");
        }
    }

    private static String replaceLast(String string, String string2, String string3) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        String string4 = string.substring(n).replaceFirst(string2, string3);
        return string.substring(0, n) + string4;
    }
}

