/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.DreamweaverBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class PhoneGapBuildApi
extends DreamweaverBase {
    protected String auth_token = null;
    public String json_file = "";
    protected HttpClient http_client;
    protected String host = "https://build.phonegap.com";
    protected int port = 443;
    protected String api_version = "api/v1";
    public String appSource = "dw";
    final String default_title = "PhoneGap Build Project";
    final String default_package_name = "com.example.app";
    final String default_version = "1.0.0";
    final String default_description = "PhoneGap Application";
    final Boolean default_debug = Boolean.FALSE;
    final Integer default_ios_key = null;
    final Integer default_android_key = null;
    final Integer default_blackberry_key = null;

    public PhoneGapBuildApi() {
        this.http_client = new DefaultHttpClient();
    }

    protected int check_authentication(String string) throws Exception {
        HttpGet httpGet = new HttpGet(this.host + "/" + this.api_version + "?");
        this.auth_token = string;
        URI uRI = httpGet.getURI();
        httpGet.setURI(new URI(uRI.toString() + "&auth_token=" + URLEncoder.encode(this.auth_token, "UTF-8")));
        URI uRI2 = httpGet.getURI();
        httpGet.setURI(new URI(uRI2.toString() + "&app_source=" + URLEncoder.encode(this.appSource, "UTF-8")));
        HttpResponse httpResponse = this.http_client.execute((HttpUriRequest)httpGet);
        StatusLine statusLine = httpResponse.getStatusLine();
        return statusLine.getStatusCode();
    }

    protected void authenticate(String string, String string2) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string, string2);
        defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)usernamePasswordCredentials);
        PhoneGapBuildApi.debug_log("Accessing: " + this.host + "/token");
        HttpPost httpPost = new HttpPost(this.host + "/token");
        HttpParams httpParams = httpPost.getParams();
        httpParams.setParameter("app_source", (Object)this.appSource);
        httpPost.setParams(httpParams);
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            String string3 = EntityUtils.toString((HttpEntity)httpEntity);
            this.write_json(this.json_file, string3);
            JSONObject jSONObject = new JSONObject(string3);
            PhoneGapBuildApi.debug_log(jSONObject.toString());
            try {
                this.auth_token = jSONObject.get("token").toString();
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Exception exception) {
            String string4 = "{error:'Authentication Failure. Could not connect to server.'}";
            PhoneGapBuildApi.debug_log(string4);
            this.write_json(this.json_file, string4);
        }
    }

    protected String post_json_with_auth_token(HttpPost httpPost) throws IOException {
        HttpParams httpParams = httpPost.getParams();
        httpParams.setParameter("auth_token", (Object)this.auth_token);
        httpParams.setParameter("app_source", (Object)this.appSource);
        HttpResponse httpResponse = this.http_client.execute((HttpUriRequest)httpPost);
        String string = httpResponse.toString();
        return string;
    }

    protected String get_json_with_auth_token(HttpGet httpGet) throws Exception {
        URI uRI = httpGet.getURI();
        httpGet.setURI(new URI(uRI.toString() + "&auth_token=" + URLEncoder.encode(this.auth_token, "UTF-8")));
        URI uRI2 = httpGet.getURI();
        httpGet.setURI(new URI(uRI2.toString() + "&app_source=" + URLEncoder.encode(this.appSource, "UTF-8")));
        PhoneGapBuildApi.debug_log(httpGet.getURI().toString());
        HttpResponse httpResponse = this.http_client.execute((HttpUriRequest)httpGet);
        String string = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        System.out.println(string);
        return string;
    }

    protected void send_json(HttpPost httpPost) throws Exception {
        HttpParams httpParams = httpPost.getParams();
        httpParams.setParameter("auth_token", (Object)this.auth_token);
        httpParams.setParameter("app_source", (Object)this.appSource);
        httpPost.setParams(httpParams);
        this.http_client.execute((HttpUriRequest)httpPost);
    }

    public void write_json(String string, String string2) throws Exception {
        PhoneGapBuildApi.debug_log("writing to file: " + string + " \n\twith contents => " + string2);
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string2);
        bufferedWriter.close();
    }

    protected boolean string_empty(String string) {
        return string == null || string.length() == 0;
    }

    protected boolean is_null(Object object) {
        return object == null;
    }

    public String build_json(HashMap hashMap) {
        String string = "";
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        String string2 = ",";
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof HashMap) {
                string = string + "\"" + entry.getKey() + "\":" + this.build_json((HashMap)entry.getValue());
                string = string + (iterator.hasNext() ? "," : "");
                continue;
            }
            string = string + "\"" + entry.getKey() + "\": " + this.return_correct_type(entry.getValue());
            string = string + (iterator.hasNext() ? "," : "");
        }
        return "{" + string + "}";
    }

    protected Object return_correct_type(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Boolean) {
            return Boolean.toString((Boolean)object);
        }
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        return "\"" + object.toString() + "\"";
    }

    public ArrayList<File> list_files(String string) {
        File file = new File(string);
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        System.out.println("file " + fileArray.length);
        if (fileArray == null) {
            if (file.isFile()) {
                arrayList.add(file);
            }
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                System.out.println(fileArray[i].getAbsolutePath());
                arrayList.add(fileArray[i]);
                if (!fileArray[i].isDirectory()) continue;
                arrayList.addAll(this.list_files(fileArray[i].getAbsolutePath()));
            }
        }
        return arrayList;
    }

    public void create_zip(String string, String string2) throws Exception {
        ArrayList<File> arrayList = this.list_files(string);
        PhoneGapBuildApi.debug_log(arrayList.toString());
        this._create_zip(string2, string, arrayList);
    }

    private void _create_zip(String string, String string2, ArrayList<File> arrayList) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        byte[] byArray = new byte[2048];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            System.out.println("Adding: " + arrayList.get(i).getAbsolutePath());
            File file = new File(arrayList.get(i).getAbsolutePath());
            if (!file.isFile() || file.getName().equals("ProjectSettings")) continue;
            FileInputStream fileInputStream = new FileInputStream(arrayList.get(i).getAbsolutePath());
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(this.relative_path(string2, arrayList.get(i).getAbsolutePath()));
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
        zipOutputStream.close();
    }

    public String relative_path(String string, String string2) {
        String string3 = File.separator;
        ArrayList<String> arrayList = this.split_path(string);
        ArrayList<String> arrayList2 = this.split_path(string2);
        ArrayList arrayList3 = new ArrayList();
        String string4 = "";
        for (int i = 0; i < arrayList.size() && arrayList2.size() >= i && arrayList2.get(i).equals(arrayList.get(i)); ++i) {
            string4 = string4 + arrayList2.get(i) + string3;
        }
        string4 = System.getProperty("os.name").startsWith("Mac OS") ? "/" + string4 : string4;
        string4 = System.getProperty("os.name").startsWith("Windows") ? "c:\\" + string4 : string4;
        return "." + string2.substring(string4.length() - 1);
    }

    public ArrayList<String> split_path(String string) {
        File file;
        File file2 = new File(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file2.getName());
        while ((file = file2.getParentFile()) != null && file2.getParentFile().getName().length() > 0) {
            arrayList.add(file.getName());
            file2 = new File(file.getAbsolutePath());
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

