/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.PhoneGapBuildApi1;
import com.phonegap.build.android.Android;
import com.phonegap.build.android.AndroidLog;
import com.phonegap.build.webos.WebOsEmulator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DreamweaverPlugin
extends DreamweaverBase {
    private static final long MAX_TIME = 300L;
    private static final String[] all_platforms = new String[]{"ios", "android", "blackberry", "symbian", "webos"};

    public static void main(String[] stringArray) throws Exception {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < all_platforms.length; ++i) {
            arrayList.add(all_platforms[i]);
        }
        PhoneGapBuildApi1 phoneGapBuildApi1 = new PhoneGapBuildApi1();
        phoneGapBuildApi1.host = "https://build.phonegap.com";
        OptionParser optionParser = new OptionParser();
        optionParser.accepts("host").withRequiredArg();
        optionParser.accepts("output").withRequiredArg();
        optionParser.accepts("appVersion").withRequiredArg();
        optionParser.accepts("authorize");
        optionParser.accepts("username").withRequiredArg();
        optionParser.accepts("password").withRequiredArg();
        optionParser.accepts("checkAuth");
        optionParser.accepts("authToken").withRequiredArg();
        optionParser.accepts("delete");
        optionParser.accepts("file").withRequiredArg();
        optionParser.accepts("build");
        optionParser.accepts("create");
        optionParser.accepts("projectDir").withRequiredArg();
        optionParser.accepts("tmpDir").withRequiredArg();
        optionParser.accepts("iosKey").withRequiredArg();
        optionParser.accepts("androidKey").withRequiredArg();
        optionParser.accepts("blackberryKey").withRequiredArg();
        optionParser.accepts("iosPass").withRequiredArg();
        optionParser.accepts("androidCertPass").withRequiredArg();
        optionParser.accepts("androidKeyStorePass").withRequiredArg();
        optionParser.accepts("blackberryPass").withRequiredArg();
        optionParser.accepts("checkDefaultKeys");
        optionParser.accepts("listsdks");
        optionParser.accepts("platform").withRequiredArg();
        optionParser.accepts("sdkPath").withRequiredArg();
        optionParser.accepts("run");
        optionParser.accepts("device").withRequiredArg();
        optionParser.accepts("appPath").withRequiredArg();
        optionParser.accepts("createAVD");
        optionParser.accepts("name").withRequiredArg();
        optionParser.accepts("target").withRequiredArg();
        optionParser.accepts("launchavdmanager");
        optionParser.accepts("buildStatus");
        optionParser.accepts("appId").withRequiredArg();
        optionParser.accepts("download");
        optionParser.accepts("url").withRequiredArg();
        optionParser.accepts("dest").withRequiredArg();
        optionParser.accepts("listApps");
        optionParser.accepts("listKeys");
        OptionSet optionSet = optionParser.parse(stringArray);
        if (optionSet.has("host")) {
            phoneGapBuildApi1.host = (String)optionSet.valueOf("host");
        }
        if (optionSet.has("appVersion")) {
            phoneGapBuildApi1.appSource = (String)optionSet.valueOf("appVersion");
        }
        if (optionSet.has("checkAuth") && optionSet.hasArgument("authToken")) {
            int n = 401;
            String string = "Sorry, we were not able to log you in. The authentication token is invalid.";
            try {
                n = phoneGapBuildApi1.check_authentication((String)optionSet.valueOf("authToken"));
                if (n == 200) {
                    string = "Authenticated";
                }
            }
            catch (Exception exception) {
                n = 404;
                string = "Sorry, it looks like we are having some technical issues. Please try again.";
            }
            phoneGapBuildApi1.json_file = (String)optionSet.valueOf("output");
            object4 = new HashMap<String, Object>();
            ((HashMap)object4).put("statusCode", n);
            ((HashMap)object4).put("statusMessage", string);
            DreamweaverPlugin.debug_log(phoneGapBuildApi1.build_json((HashMap)object4));
            try {
                phoneGapBuildApi1.write_json(phoneGapBuildApi1.json_file, phoneGapBuildApi1.build_json((HashMap)object4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (optionSet.has("authorize") && optionSet.hasArgument("username") && optionSet.hasArgument("password") && optionSet.hasArgument("output")) {
            phoneGapBuildApi1.json_file = (String)optionSet.valueOf("output");
            try {
                phoneGapBuildApi1.authenticate((String)optionSet.valueOf("username"), (String)optionSet.valueOf("password"));
            }
            catch (Exception exception) {
                DreamweaverPlugin.debug_log("Failed to authenticate.");
            }
        }
        if (optionSet.has("delete") && optionSet.has("file")) {
            try {
                ArrayList<File> arrayList2 = phoneGapBuildApi1.list_files((String)optionSet.valueOf("file"));
                for (int i = 0; i < arrayList2.size(); ++i) {
                    DreamweaverPlugin.debug_log("deleting: " + arrayList2.get(i).getAbsolutePath());
                    arrayList2.get(i).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (optionSet.has("checkDefaultKeys")) {
            String string = (String)optionSet.valueOf("output");
            phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
            DreamweaverPlugin.debug_log("entered check default keys" + string);
            JSONObject jSONObject = phoneGapBuildApi1.verify_default_keys();
            try {
                DreamweaverPlugin.write_json(string, jSONObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (optionSet.has("build") && (optionSet.has("authToken") || optionSet.has("projectDir") || optionSet.has("tmpDir") || optionSet.has("output"))) {
            phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
            String string = (String)optionSet.valueOf("projectDir");
            String string2 = (String)optionSet.valueOf("output");
            object4 = (String)optionSet.valueOf("tmpDir") + File.separator + "www.zip";
            DreamweaverPlugin.debug_log("Creating app");
            DreamweaverPlugin.debug_log("Using token: " + phoneGapBuildApi1.auth_token);
            DreamweaverPlugin.debug_log("Attempting to zip: " + string);
            try {
                object3 = phoneGapBuildApi1.update_application_from_file(optionSet.has("create"), null, null, null, null, true, optionSet.has("iosKey") ? Integer.valueOf(Integer.parseInt((String)optionSet.valueOf("iosKey"))) : null, optionSet.has("androidKey") ? Integer.valueOf(Integer.parseInt((String)optionSet.valueOf("androidKey"))) : null, optionSet.has("blackberryKey") ? Integer.valueOf(Integer.parseInt((String)optionSet.valueOf("blackberryKey"))) : null, optionSet.has("iosPass") ? (String)optionSet.valueOf("iosPass") : null, optionSet.has("androidCertPass") ? (String)optionSet.valueOf("androidCertPass") : null, optionSet.has("androidKeyStorePass") ? (String)optionSet.valueOf("androidKeyStorePass") : null, optionSet.has("blackberryPass") ? (String)optionSet.valueOf("blackberryPass") : null, string, (String)object4, optionSet.has("appId") ? Integer.valueOf(Integer.parseInt((String)optionSet.valueOf("appId"))) : null);
                object2 = new JSONObject((String)object3);
                phoneGapBuildApi1.write_json(string2, (String)object3);
                if (((JSONObject)object2).has("id")) {
                    phoneGapBuildApi1.write_json(string + File.separator + "ProjectSettings", (String)object3);
                }
            }
            catch (Exception exception) {
                try {
                    object2 = new HashMap();
                    ((HashMap)object2).put((Integer)((Object)"error"), (String)((Object)Integer.valueOf(404)));
                    ((HashMap)object2).put((Integer)((Object)"message"), (String)("Failed to upload application. Reason:" + exception.getMessage()));
                    object = phoneGapBuildApi1.build_json((HashMap)object2);
                    DreamweaverPlugin.debug_log(object);
                    phoneGapBuildApi1.write_json(string2, (String)object);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (optionSet.has("buildStatus") && optionSet.has("authToken") && optionSet.has("output") && optionSet.has("appId")) {
            Serializable serializable;
            JSONObject jSONObject;
            long l;
            DreamweaverPlugin.debug_log("Cheking build status");
            phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
            String string = (String)optionSet.valueOf("output");
            Integer n = Integer.parseInt((String)optionSet.valueOf("appId"));
            long l2 = l = System.currentTimeMillis() / 1000L;
            hashMap2 = new HashMap();
            hashMap = new HashMap<String, Object>();
            while (l2 - l <= 300L && arrayList.size() > 0) {
                try {
                    jSONObject = phoneGapBuildApi1.get_app(n);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                        hashMap3.put("status", jSONObject.getJSONObject("status").get((String)arrayList.get(i)));
                        serializable = Boolean.valueOf(false);
                        if (jSONObject.getJSONObject("keys").has((String)arrayList.get(i))) {
                            serializable = Boolean.valueOf(!jSONObject.getJSONObject("keys").get((String)arrayList.get(i)).toString().equals("null"));
                        }
                        hashMap3.put("signed", ((Boolean)serializable).toString());
                        if (jSONObject.getJSONObject("error").has((String)arrayList.get(i))) {
                            hashMap3.put("error", jSONObject.getJSONObject("error").get((String)arrayList.get(i)));
                        }
                        if (jSONObject.getJSONObject("download").has((String)arrayList.get(i))) {
                            hashMap3.put("download", jSONObject.getJSONObject("download").get((String)arrayList.get(i)));
                        }
                        hashMap.put((String)arrayList.get(i), hashMap3);
                        if (jSONObject.getJSONObject("status").get((String)arrayList.get(i)).equals("pending")) continue;
                        arrayList.remove(i);
                    }
                    phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json(hashMap));
                    DreamweaverPlugin.debug_log(phoneGapBuildApi1.build_json(hashMap));
                }
                catch (Exception exception) {
                    String string3 = DreamweaverPlugin.failAllBuilds("Could not retrieve info. The connection may have been lost.");
                    phoneGapBuildApi1.write_json(string, string3);
                    return;
                }
                try {
                    Thread.sleep(7000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis() / 1000L;
            }
            jSONObject = phoneGapBuildApi1.get_app(n);
            HashMap<String, Serializable> hashMap4 = new HashMap<String, Serializable>();
            for (int i = 0; i < all_platforms.length; ++i) {
                serializable = new HashMap();
                String string4 = "";
                String string5 = "";
                if (((String)jSONObject.getJSONObject("status").get(all_platforms[i])).equals("pending")) {
                    string4 = "error";
                    string5 = "Failed to communitcate with build servers." + (String)jSONObject.getJSONObject("status").get(all_platforms[i]);
                } else {
                    string4 = (String)jSONObject.getJSONObject("status").get(all_platforms[i]);
                    if (jSONObject.getJSONObject("error").has(all_platforms[i])) {
                        string5 = (String)jSONObject.getJSONObject("error").get(all_platforms[i]);
                    }
                }
                Boolean bl = false;
                if (jSONObject.getJSONObject("keys").has(all_platforms[i])) {
                    bl = !jSONObject.getJSONObject("keys").get(all_platforms[i]).toString().equals("null");
                }
                ((HashMap)serializable).put("signed", bl.toString());
                ((HashMap)serializable).put("signed", jSONObject.getJSONObject("keys").has(all_platforms[i]));
                ((HashMap)serializable).put("status", string4);
                ((HashMap)serializable).put("error", string5);
                if (jSONObject.getJSONObject("download").has(all_platforms[i])) {
                    ((HashMap)serializable).put("download", jSONObject.getJSONObject("download").get(all_platforms[i]));
                }
                hashMap4.put(all_platforms[i], serializable);
            }
            try {
                phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json(hashMap4));
                DreamweaverPlugin.debug_log(phoneGapBuildApi1.build_json(hashMap4));
                DreamweaverPlugin.debug_log("done");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (optionSet.has("listApps") && optionSet.has("authToken") && optionSet.has("output")) {
            if (optionSet.has("appId")) {
                Integer n = Integer.parseInt((String)optionSet.valueOf("appId"));
                String string = (String)optionSet.valueOf("output");
                phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
                JSONObject jSONObject = phoneGapBuildApi1.get_app(n);
                DreamweaverBase.write_json(string, jSONObject);
            } else {
                JSONArray jSONArray;
                JSONObject jSONObject;
                String string = (String)optionSet.valueOf("output");
                phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
                DreamweaverPlugin.debug_log(phoneGapBuildApi1.auth_token);
                try {
                    jSONObject = phoneGapBuildApi1.get_apps();
                }
                catch (JSONException jSONException) {
                    object3 = jSONException.getMessage();
                    try {
                        phoneGapBuildApi1.write_json(string, (String)object3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    jSONArray = jSONObject.getJSONArray("apps");
                }
                catch (JSONException jSONException) {
                    object2 = jSONObject.toString();
                    try {
                        phoneGapBuildApi1.write_json(string, (String)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                object3 = new HashMap();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object = (JSONObject)jSONArray.get(i);
                    if (!((JSONObject)object).isNull("repo")) continue;
                    hashMap2 = new HashMap<String, Object>();
                    hashMap2.put("id", ((JSONObject)object).get("id"));
                    hashMap2.put("title", ((JSONObject)object).get("title"));
                    ((HashMap)object3).put(i, hashMap2);
                }
                try {
                    phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json((HashMap)object3));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (optionSet.has("listKeys") && optionSet.has("authToken") && optionSet.has("output")) {
            JSONObject jSONObject;
            JSONObject jSONObject2;
            String string = (String)optionSet.valueOf("output");
            phoneGapBuildApi1.auth_token = (String)optionSet.valueOf("authToken");
            try {
                jSONObject2 = phoneGapBuildApi1.get_keys();
            }
            catch (JSONException jSONException) {
                object3 = jSONException.getMessage();
                try {
                    phoneGapBuildApi1.write_json(string, (String)object3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                jSONObject = jSONObject2.getJSONObject("keys");
            }
            catch (JSONException jSONException) {
                object2 = jSONObject2.toString();
                try {
                    phoneGapBuildApi1.write_json(string, (String)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                PhoneGapBuildApi1.write_json(string, jSONObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (optionSet.has("listsdks")) {
            String string = (String)optionSet.valueOf("output");
            String string6 = (String)optionSet.valueOf("sdkPath");
            String string7 = (String)optionSet.valueOf("platform");
            if (string7.contentEquals("android")) {
                try {
                    Android.listSDKs(string6, string);
                }
                catch (Exception exception) {
                    DreamweaverPlugin.debug_log("EX " + exception.toString());
                }
            } else if (string7.contentEquals("webos")) {
                try {
                    object3 = new WebOsEmulator();
                    ((WebOsEmulator)object3).path = string6;
                    object2 = ((WebOsEmulator)object3).listEmulators();
                    object = new HashMap();
                    ((HashMap)object).put("status", "200");
                    ((HashMap)object).put("emulators", object2);
                    phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json((HashMap)object));
                }
                catch (Exception exception) {
                    object2 = new HashMap();
                    ((HashMap)object2).put((Integer)((Object)"status"), (String)"404");
                    ((HashMap)object2).put((Integer)((Object)"reason"), (String)"Could not find any valid emulators");
                    phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json((HashMap)object2));
                }
            }
        }
        if (optionSet.has("run")) {
            String string = (String)optionSet.valueOf("output");
            String string8 = (String)optionSet.valueOf("sdkPath");
            String string9 = (String)optionSet.valueOf("platform");
            object3 = (String)optionSet.valueOf("appPath");
            object2 = (String)optionSet.valueOf("device");
            object = (String)optionSet.valueOf("target");
            if (string9.contentEquals("android")) {
                try {
                    Android.run(string8, object3, object2, string);
                }
                catch (Exception exception) {}
            } else if (string9.contentEquals("webos")) {
                try {
                    hashMap2 = new WebOsEmulator();
                    if (string9.contentEquals("undefined") || string8.contentEquals("undefined") || string9.contentEquals("undefined") || ((String)object3).contentEquals("undefined") || ((String)object2).contentEquals("undefined") || ((String)object).contentEquals("undefined")) {
                        throw new Exception("could not launch the emulator");
                    }
                    ((WebOsEmulator)((Object)hashMap2)).path = string8;
                    ((WebOsEmulator)((Object)hashMap2)).emulator_type = object2;
                    ((WebOsEmulator)((Object)hashMap2)).log_file = string;
                    ((WebOsEmulator)((Object)hashMap2)).start_install_and_run((String)object3, (String)object);
                }
                catch (Exception exception) {
                    hashMap = new HashMap();
                    hashMap.put("status", "done");
                    hashMap.put("message", "Failed to run: " + exception.getMessage() + "; please try again.");
                    phoneGapBuildApi1.write_json(string, phoneGapBuildApi1.build_json(hashMap));
                }
            }
        }
        if (optionSet.has("createAVD")) {
            String string = (String)optionSet.valueOf("output");
            String string10 = (String)optionSet.valueOf("sdkPath");
            String string11 = (String)optionSet.valueOf("target");
            object3 = (String)optionSet.valueOf("name");
            try {
                Android.createAVD(string10, string11, object3, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (optionSet.has("launchavdmanager")) {
            String string = (String)optionSet.valueOf("sdkPath");
            try {
                Android.launchAVDManager(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (optionSet.has("download")) {
            String string = (String)optionSet.valueOf("output");
            String string12 = (String)optionSet.valueOf("dest");
            String string13 = (String)optionSet.valueOf("url");
            try {
                DreamweaverPlugin.downloadFile(string13, string12, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean downloadFile(String string, String string2, String string3) throws Exception {
        DefaultHttpClient defaultHttpClient = null;
        HttpGet httpGet = null;
        HttpResponse httpResponse = null;
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            Object object;
            JSONObject jSONObject = new JSONObject();
            Android.write_json(string3, jSONObject.put("state", "connecting"));
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)5000);
            defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
            httpGet = new HttpGet(string);
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            Header header = httpResponse.getFirstHeader("Content-Length");
            byte[] byArray = new byte[4096];
            int n2 = 0;
            if (header != null) {
                object = header.getValue();
                n2 = Integer.parseInt((String)object);
            }
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2, false));
            bufferedInputStream = new BufferedInputStream(httpResponse.getEntity().getContent());
            object = new AndroidLog("downloading", "");
            int n3 = 0;
            float f = 0.0f;
            int n4 = 0;
            long l = 0L;
            jSONObject.put("state", "downloading");
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                f = (float)(n3 += n) / (float)n2 * 100.0f;
                if ((int)f == n4 || !(f < 100.0f) || System.currentTimeMillis() - l < 1000L) continue;
                n4 = (int)f;
                Android.write_json(string3, jSONObject.put("progress", n4));
                l = System.currentTimeMillis();
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            jSONObject.put("progress", 100);
            Android.write_json(string3, jSONObject.put("state", "finished"));
            Boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Android.error(string3, "Download failed: " + socketTimeoutException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            Android.error(string3, "Download failed: " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            Android.error(string3, "Download failed: " + exception.getMessage());
        }
        finally {
            try {
                filterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    static String failAllBuilds(String string) {
        HashMap hashMap = new HashMap();
        PhoneGapBuildApi1 phoneGapBuildApi1 = new PhoneGapBuildApi1();
        for (int i = 0; i < all_platforms.length; ++i) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("status", "error");
            hashMap2.put("error", string);
            hashMap.put(all_platforms[i], hashMap2);
        }
        return phoneGapBuildApi1.build_json(hashMap);
    }
}

