/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.util.StringTokenizer;

class Platform {
    private static final String libNameMain = "jsound";
    private static final String libNameALSA = "jsoundalsa";
    private static final String libNameDSound = "jsoundds";
    private static final String libNameSolMIDI = "jsoundsolmidi";
    public static final int LIB_MAIN = 1;
    public static final int LIB_ALSA = 2;
    public static final int LIB_DSOUND = 4;
    public static final int LIB_SOLMIDI = 8;
    private static int loadedLibs = 0;
    public static final int FEATURE_MIDIIO = 1;
    public static final int FEATURE_PORTS = 2;
    public static final int FEATURE_DIRECT_AUDIO = 3;
    private static boolean signed8;
    private static boolean bigEndian;
    private static String javahome;
    private static String classpath;

    private Platform() {
    }

    static void initialize() {
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isSigned8() {
        return signed8;
    }

    static String getJavahome() {
        return javahome;
    }

    static String getClasspath() {
        return classpath;
    }

    private static void loadLibraries() {
        JSSecurityManager.loadLibrary(libNameMain);
        loadedLibs |= 1;
        String string = Platform.nGetExtraLibraries();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                JSSecurityManager.loadLibrary(string2);
                if (string2.equals(libNameALSA)) {
                    loadedLibs |= 2;
                    continue;
                }
                if (string2.equals(libNameDSound)) {
                    loadedLibs |= 4;
                    continue;
                }
                if (!string2.equals(libNameSolMIDI)) continue;
                loadedLibs |= 8;
            }
            catch (Throwable throwable) {}
        }
    }

    static boolean isMidiIOEnabled() {
        return Platform.isFeatureLibLoaded(1);
    }

    static boolean isPortsEnabled() {
        return Platform.isFeatureLibLoaded(2);
    }

    static boolean isDirectAudioEnabled() {
        return Platform.isFeatureLibLoaded(3);
    }

    private static boolean isFeatureLibLoaded(int n) {
        int n2 = Platform.nGetLibraryForFeature(n);
        boolean bl = n2 != 0 && (loadedLibs & n2) == n2;
        return bl;
    }

    private static native boolean nIsBigEndian();

    private static native boolean nIsSigned8();

    private static native String nGetExtraLibraries();

    private static native int nGetLibraryForFeature(int var0);

    private static void readProperties() {
        bigEndian = Platform.nIsBigEndian();
        signed8 = Platform.nIsSigned8();
        javahome = JSSecurityManager.getProperty("java.home");
        classpath = JSSecurityManager.getProperty("java.class.path");
    }

    static {
        Platform.loadLibraries();
        Platform.readProperties();
    }
}

