/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.visitor;

import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCField;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.ClassInstruction;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.ConstantInstruction;
import com.techtrader.modules.tools.bytecode.ConstantValueAttribute;
import com.techtrader.modules.tools.bytecode.Constants;
import com.techtrader.modules.tools.bytecode.ExceptionHandler;
import com.techtrader.modules.tools.bytecode.ExceptionsAttribute;
import com.techtrader.modules.tools.bytecode.GetFieldInstruction;
import com.techtrader.modules.tools.bytecode.IIncInstruction;
import com.techtrader.modules.tools.bytecode.InnerClass;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.JumpInstruction;
import com.techtrader.modules.tools.bytecode.LineNumber;
import com.techtrader.modules.tools.bytecode.LoadInstruction;
import com.techtrader.modules.tools.bytecode.LocalVariable;
import com.techtrader.modules.tools.bytecode.LookupSwitchInstruction;
import com.techtrader.modules.tools.bytecode.MethodInstruction;
import com.techtrader.modules.tools.bytecode.MultiANewArrayInstruction;
import com.techtrader.modules.tools.bytecode.NewArrayInstruction;
import com.techtrader.modules.tools.bytecode.PutFieldInstruction;
import com.techtrader.modules.tools.bytecode.RetInstruction;
import com.techtrader.modules.tools.bytecode.SourceFileAttribute;
import com.techtrader.modules.tools.bytecode.StoreInstruction;
import com.techtrader.modules.tools.bytecode.TableSwitchInstruction;
import com.techtrader.modules.tools.bytecode.UnknownAttribute;
import com.techtrader.modules.tools.bytecode.WideInstruction;
import com.techtrader.modules.tools.bytecode.lowlevel.ClassEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.ConstantPool;
import com.techtrader.modules.tools.bytecode.lowlevel.DoubleEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.Entry;
import com.techtrader.modules.tools.bytecode.lowlevel.FieldEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.FloatEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.IntEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.InterfaceMethodEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LongEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.MethodEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.NameAndTypeEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.StringEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.UTF8Entry;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import com.techtrader.modules.tools.bytecode.visitor.VisitAcceptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class PrettyPrintVisitor
extends BCVisitor
implements Constants {
    private PrintWriter _out = null;
    private String _prefix = "";
    private int _entryCount = 0;

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: PrettyPrintVisitor <classname>+");
            System.exit(1);
        }
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        int n = 0;
        while (n < stringArray.length) {
            BCClass bCClass = stringArray[n].endsWith(".class") ? new BCClass(new File(stringArray[n])) : new BCClass(Class.forName(stringArray[n]));
            prettyPrintVisitor.visit(bCClass);
            ++n;
        }
    }

    public void visit(VisitAcceptor visitAcceptor) {
        super.visit(visitAcceptor);
        this._out.flush();
    }

    public void enterBCClass(BCClass bCClass) {
        this.openBlock("Class");
        this.println("magic=" + bCClass.getMagic());
        this.println("minor=" + bCClass.getMinorVersion());
        this.println("major=" + bCClass.getMajorVersion());
        this.println("access=" + bCClass.getAccessFlags());
        this.println("name=" + bCClass.getIndex() + " <" + bCClass.getName() + ">");
        this.println("super=" + bCClass.getSuperclassIndex() + " <" + bCClass.getSuperclassName() + ">");
        int[] nArray = bCClass.getInterfaceIndexes();
        String[] stringArray = bCClass.getInterfaceNames();
        int n = 0;
        while (n < nArray.length) {
            this.println("interface=" + nArray[n] + " <" + stringArray[n] + ">");
            ++n;
        }
    }

    public void exitBCClass(BCClass bCClass) {
        this.closeBlock();
    }

    public void enterBCField(BCField bCField) {
        this.openBlock("Field");
        this.println("access=" + bCField.getAccessFlags());
        this.println("name=" + bCField.getNameIndex() + " <" + bCField.getName() + ">");
        this.println("descriptor=" + bCField.getDescriptorIndex() + " <" + bCField.getTypeName() + ">");
    }

    public void exitBCField(BCField bCField) {
        this.closeBlock();
    }

    public void enterBCMethod(BCMethod bCMethod) {
        this.openBlock("Method");
        this.println("access=" + bCMethod.getAccessFlags());
        this.println("name=" + bCMethod.getNameIndex() + " <" + bCMethod.getName() + ">");
        this.println("descriptor=" + bCMethod.getDescriptorIndex());
        this.println("return=" + bCMethod.getReturnTypeName());
        String[] stringArray = bCMethod.getParamTypeNames();
        int n = 0;
        while (n < stringArray.length) {
            this.println("param=" + stringArray[n]);
            ++n;
        }
    }

    public void exitBCMethod(BCMethod bCMethod) {
        this.closeBlock();
    }

    public void enterAttribute(Attribute attribute) {
        this.openBlock(attribute.getName());
    }

    public void exitAttribute(Attribute attribute) {
        this.closeBlock();
    }

    public void enterConstantValueAttribute(ConstantValueAttribute constantValueAttribute) {
        this.println("value=" + constantValueAttribute.getValueIndex() + " <" + constantValueAttribute.getTypeName() + "=" + constantValueAttribute.getValue() + ">");
    }

    public void enterExceptionsAttribute(ExceptionsAttribute exceptionsAttribute) {
        int[] nArray = exceptionsAttribute.getExceptionIndexes();
        String[] stringArray = exceptionsAttribute.getExceptionTypeNames();
        int n = 0;
        while (n < nArray.length) {
            this.println("exception=" + nArray[n] + " <" + stringArray[n] + ">");
            ++n;
        }
    }

    public void enterSourceFileAttribute(SourceFileAttribute sourceFileAttribute) {
        this.println("source=" + sourceFileAttribute.getSourceFileIndex() + " <" + sourceFileAttribute.getSourceFile() + ">");
    }

    public void enterUnknownAttribute(UnknownAttribute unknownAttribute) {
        this.println("value=" + new String(unknownAttribute.getValue()));
    }

    public void enterCode(Code code) {
        this.println("maxStack=" + code.getMaxStack());
        this.println("maxLocals=" + code.getMaxLocals());
        this.println("");
    }

    public void enterExceptionHandler(ExceptionHandler exceptionHandler) {
        this.openBlock("ExceptionHandler");
        this.println("startPc=" + exceptionHandler.getStartPc());
        this.println("endPc=" + exceptionHandler.getEndPc());
        this.println("handlerPc=" + exceptionHandler.getHandlerPc());
        this.println("catch=" + exceptionHandler.getCatchTypeIndex() + " <" + exceptionHandler.getCatchTypeName() + ">");
    }

    public void exitExceptionHandler(ExceptionHandler exceptionHandler) {
        this.closeBlock();
    }

    public void enterInnerClass(InnerClass innerClass) {
        this.openBlock("InnerClass");
        this.println("access=" + innerClass.getAccessFlags());
        this.println("name=" + innerClass.getNameIndex() + " <" + innerClass.getName() + ">");
        this.println("index=" + innerClass.getIndex());
        this.println("outer=" + innerClass.getOuterClassIndex());
    }

    public void exitInnerClass(InnerClass innerClass) {
        this.closeBlock();
    }

    public void enterLineNumber(LineNumber lineNumber) {
        this.openBlock("LineNumber");
        this.println("startPc=" + lineNumber.getStartPc());
        this.println("line=" + lineNumber.getLineNumber());
    }

    public void exitLineNumber(LineNumber lineNumber) {
        this.closeBlock();
    }

    public void enterLocalVariable(LocalVariable localVariable) {
        this.openBlock("LocalVariable");
        this.println("startPc=" + localVariable.getStartPc());
        this.println("length=" + localVariable.getLength());
        this.println("index=" + localVariable.getIndex());
        this.println("name=" + localVariable.getNameIndex() + " <" + localVariable.getName() + ">");
        this.println("descriptor=" + localVariable.getDescriptorIndex() + " <" + localVariable.getTypeName() + ">");
    }

    public void exitLocalVariable(LocalVariable localVariable) {
        this.closeBlock();
    }

    public void enterInstruction(Instruction instruction) {
        this._out.print(this._prefix + instruction.getByteIndex() + " " + instruction.getName() + " ");
    }

    public void exitInstruction(Instruction instruction) {
        this._out.println();
    }

    public void enterClassInstruction(ClassInstruction classInstruction) {
        this._out.print(classInstruction.getClassIndex() + " <" + classInstruction.getClassName() + ">");
    }

    public void enterConstantInstruction(ConstantInstruction constantInstruction) {
        switch (constantInstruction.getOpCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this._out.print(constantInstruction.getConstant().toString());
            }
        }
    }

    public void enterGetFieldInstruction(GetFieldInstruction getFieldInstruction) {
        this._out.print(getFieldInstruction.getFieldIndex() + " <" + getFieldInstruction.getFieldOwnerTypeName() + "." + getFieldInstruction.getFieldName() + ">");
    }

    public void enterIIncInstruction(IIncInstruction iIncInstruction) {
        this._out.print(iIncInstruction.getIndex() + " ");
        if (iIncInstruction.getIncrement() > 0) {
            this._out.print("+");
        }
        this._out.print(iIncInstruction.getIncrement());
    }

    public void enterJumpInstruction(JumpInstruction jumpInstruction) {
        this._out.print(jumpInstruction.getOffset());
    }

    public void enterLoadInstruction(LoadInstruction loadInstruction) {
        switch (loadInstruction.getOpCode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this._out.print(loadInstruction.getIndex());
            }
        }
    }

    public void enterLookupSwitchInstruction(LookupSwitchInstruction lookupSwitchInstruction) {
        this._out.println();
        this._prefix = this._prefix + "  ";
        int[] nArray = lookupSwitchInstruction.getOffsets();
        int[] nArray2 = lookupSwitchInstruction.getMatches();
        int n = 0;
        while (n < nArray.length) {
            this.println("case " + nArray2[n] + "=" + nArray[n]);
            ++n;
        }
        this._out.print(this._prefix + "default=" + lookupSwitchInstruction.getDefaultOffset());
        this._prefix = this._prefix.substring(2);
    }

    public void enterMethodInstruction(MethodInstruction methodInstruction) {
        this._out.print(methodInstruction.getMethodIndex() + " <" + methodInstruction.getMethodOwnerTypeName() + "." + methodInstruction.getMethodName() + "(");
        String[] stringArray = methodInstruction.getMethodParamTypeNames();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].lastIndexOf(46);
            if (n2 != -1) {
                stringArray[n] = stringArray[n].substring(n2 + 1);
            }
            this._out.print(stringArray[n]);
            if (n != stringArray.length - 1) {
                this._out.print(", ");
            }
            ++n;
        }
        this._out.print(")>");
    }

    public void enterMultiANewArrayInstruction(MultiANewArrayInstruction multiANewArrayInstruction) {
        this._out.print(multiANewArrayInstruction.getClassIndex() + " " + multiANewArrayInstruction.getDimensions() + " <" + multiANewArrayInstruction.getClassName());
        String string = "";
        int n = 0;
        while (n < multiANewArrayInstruction.getDimensions()) {
            string = string + "[]";
            ++n;
        }
        this._out.print(string + ">");
    }

    public void enterNewArrayInstruction(NewArrayInstruction newArrayInstruction) {
        this._out.print(newArrayInstruction.getArrayTypeCode() + " <" + newArrayInstruction.getArrayTypeName() + "[]>");
    }

    public void enterPutFieldInstruction(PutFieldInstruction putFieldInstruction) {
        this._out.print(putFieldInstruction.getFieldIndex() + " <" + putFieldInstruction.getFieldOwnerTypeName() + "." + putFieldInstruction.getFieldName() + ">");
    }

    public void enterRetInstruction(RetInstruction retInstruction) {
        this._out.print(retInstruction.getIndex());
    }

    public void enterStoreInstruction(StoreInstruction storeInstruction) {
        switch (storeInstruction.getOpCode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this._out.print(storeInstruction.getIndex());
            }
        }
    }

    public void enterTableSwitchInstruction(TableSwitchInstruction tableSwitchInstruction) {
        this._out.println();
        this._prefix = this._prefix + "  ";
        this.println("low=" + tableSwitchInstruction.getLow());
        this.println("high=" + tableSwitchInstruction.getHigh());
        int[] nArray = tableSwitchInstruction.getOffsets();
        int n = 0;
        while (n < nArray.length) {
            this.println("case=" + nArray[n]);
            ++n;
        }
        this._out.print(this._prefix + "default=" + tableSwitchInstruction.getDefaultOffset());
        this._prefix = this._prefix.substring(2);
    }

    public void enterWideInstruction(WideInstruction wideInstruction) {
        int n = wideInstruction.getInstruction();
        this._out.print(n + " <" + Constants.OPCODE_NAMES[n] + ">");
    }

    public void enterConstantPool(ConstantPool constantPool) {
        this._entryCount = 0;
        this.openBlock("ConstantPool");
    }

    public void exitConstantPool(ConstantPool constantPool) {
        this.closeBlock();
    }

    public void enterEntry(Entry entry) {
        String string = entry.getClass().getName();
        this.openBlock(++this._entryCount + ": " + string.substring(string.lastIndexOf(46) + 1));
    }

    public void exitEntry(Entry entry) {
        this.closeBlock();
    }

    public void enterClassEntry(ClassEntry classEntry) {
        this.println("name=" + classEntry.getNameIndex());
    }

    public void enterDoubleEntry(DoubleEntry doubleEntry) {
        this.println("value=" + doubleEntry.getValue());
    }

    public void enterFieldEntry(FieldEntry fieldEntry) {
        this.println("class=" + fieldEntry.getClassIndex());
        this.println("nameAndType=" + fieldEntry.getNameAndTypeIndex());
    }

    public void enterFloatEntry(FloatEntry floatEntry) {
        this.println("value=" + floatEntry.getValue());
    }

    public void enterIntEntry(IntEntry intEntry) {
        this.println("value=" + intEntry.getValue());
    }

    public void enterInterfaceMethodEntry(InterfaceMethodEntry interfaceMethodEntry) {
        this.println("class=" + interfaceMethodEntry.getClassIndex());
        this.println("nameAndType=" + interfaceMethodEntry.getNameAndTypeIndex());
    }

    public void enterLongEntry(LongEntry longEntry) {
        this.println("value=" + longEntry.getValue());
    }

    public void enterMethodEntry(MethodEntry methodEntry) {
        this.println("class=" + methodEntry.getClassIndex());
        this.println("nameAndType=" + methodEntry.getNameAndTypeIndex());
    }

    public void enterNameAndTypeEntry(NameAndTypeEntry nameAndTypeEntry) {
        this.println("name=" + nameAndTypeEntry.getNameIndex());
        this.println("descriptor=" + nameAndTypeEntry.getDescriptorIndex());
    }

    public void enterStringEntry(StringEntry stringEntry) {
        this.println("index=" + stringEntry.getStringIndex());
    }

    public void enterUTF8Entry(UTF8Entry uTF8Entry) {
        this.println("value=" + uTF8Entry.getValue());
    }

    private void println(String string) {
        this._out.print(this._prefix);
        this._out.println(string);
    }

    private void openBlock(String string) {
        this.println(string + " {");
        this._prefix = this._prefix + "  ";
    }

    private void closeBlock() {
        this._prefix = this._prefix.substring(2);
        this.println("}");
    }

    public PrettyPrintVisitor() {
        this._out = new PrintWriter(System.out);
    }

    public PrettyPrintVisitor(PrintWriter printWriter) {
        this._out = printWriter;
    }
}

