/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR": "(błąd {0})",
    "NOT_FOUND_ERR": "Nie znaleziono pliku/folderu.",
    "NOT_READABLE_ERR": "Nie można odczytać pliku/folderu.",
    "EXCEEDS_MAX_FILE_SIZE": "Pliki większe niż {0} MB nie mogą być otwarte w {APP_NAME}.",
    "NO_MODIFICATION_ALLOWED_ERR": "Nie można zmodyfikować folderu docelowego.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE": "Nie masz uprawnień by modyfikować ten plik.",
    "CONTENTS_MODIFIED_ERR": "Plik został zmodyfikowany poza {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR": "Nieznany format kodowania",
    "ENCODE_FILE_FAILED_ERR": "Program {APP_NAME} nie może zakodować zawartości pliku.",
    "DECODE_FILE_FAILED_ERR": "Program {APP_NAME} nie może dekodować zawartości pliku.",
    "UNSUPPORTED_UTF16_ENCODING_ERR": "{APP_NAME} nie obsługuje obecnie plików tekstowych z kodowaniem UTF-16.",
    "FILE_EXISTS_ERR": "Plik lub folder już istnieje.",
    "FILE": "plik",
    "FILE_TITLE": "Plik",
    "DIRECTORY": "folder",
    "DIRECTORY_TITLE": "Katalog",
    "DIRECTORY_NAMES_LEDE": "Nazwy folderów",
    "FILENAMES_LEDE": "Nazwy plików",
    "FILENAME": "Nazwa pliku",
    "DIRECTORY_NAME": "Nazwa folderu",

    // Project error strings
    "ERROR_LOADING_PROJECT": "Błąd podczas ładowania projektu",
    "OPEN_DIALOG_ERROR": "Wystąpił błąd podczas wyświetlania okna otwierania pliku. (błąd {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR": "Wystąpił błąd przy próbie otwarcia folderu <span class='dialog-filename'>{0}</span>. (błąd {1})",
    "READ_DIRECTORY_ENTRIES_ERROR": "Wystąpił błąd podczas odczytu zawartości folderu <span class='dialog-filename'>{0}</span>. (błąd {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE": "Błąd podczas otwarcia pliku",
    "ERROR_OPENING_FILE": "Wystąpił błąd podczas próby otwarcia pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES": "Wystąpił błąd podczas otwierania plików:",
    "ERROR_RELOADING_FILE_TITLE": "Błąd podczas przeładowania zmian z dysku",
    "ERROR_RELOADING_FILE": "Błąd podczas przeładowania pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE": "Problem z zapisaniem pliku",
    "ERROR_SAVING_FILE": "Błąd podczas próby zapisu pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE": "Błąd podczas zmiany nazwy pliku {0}",
    "ERROR_RENAMING_FILE": "Błąd podczas próby zmiany nazwy pliku {2} <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT": "Plik lub folder nie jest częścią aktualnie otwartego projektu. Niestety, w tym momencie możesz zmienić nazwę tylko dla plików projektu.",
    "ERROR_DELETING_FILE_TITLE": "Błąd podczas usuwania pliku {0}",
    "ERROR_DELETING_FILE": "Błąd podczas próby usunięcia {2} <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE": "Nieprawidłowa nazwa pliku {0}",
    "INVALID_FILENAME_MESSAGE": "{0} nie może kończyć się kropką (.), zawierać żadnych zarezerwowanych słów ani żadnych z tych znaków: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS": "Plik lub folder o nazwie <span class='dialog-filename'>{0}</span> już istnieje.",
    "ERROR_CREATING_FILE_TITLE": "Nie można utworzyć pliku {0}",
    "ERROR_CREATING_FILE": "Błąd podczas próby stworzenia pliku {0} <span class='dialog-filename'>{1}</span>. {2}",
    "ERROR_MIXED_DRAGDROP": "Nie można otworzyć folderu podczas otwierana innych plików.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE": "Błąd podczas odczytywania konfiguracji klawiszy",
    "ERROR_KEYMAP_CORRUPT": "Twój plik z konfiguracją klawiszy nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić.",
    "ERROR_LOADING_KEYMAP": "Twój plik z konfiguracją klawiszy nie jest poprawnie zakodowanym plikiem UTF-8 i nie może zostać załadowany.",
    "ERROR_RESTRICTED_COMMANDS": "Nie możesz nadpisać skrótów do tych komend: {0}",
    "ERROR_RESTRICTED_SHORTCUTS": "Nie możesz nadpisać tych skrótów: {0}",
    "ERROR_MULTIPLE_SHORTCUTS": "Próbujesz przypisać kilka skrótów do następujących komend: {0}",
    "ERROR_DUPLICATE_SHORTCUTS": "Upewnij się, że następujące skróty są unikalne (nie nadpisują się): {0}",
    "ERROR_INVALID_SHORTCUTS": "Podane skróty są nieprawidłowe: {0}",
    "ERROR_NONEXISTENT_COMMANDS": "Próbujesz przypisać skróty do niestniejących komend: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE": "Błąd podczas wczytywania ustawień",
    "ERROR_PREFS_CORRUPT": "Twój plik ustawień nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić. Aby zastosować zmiany, uruchom ponownie {APP_NAME}.",
    "ERROR_PROJ_PREFS_CORRUPT": "Twój plik ustawień projektu nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić. Aby zastosować zmiany, musisz przeładować projekt.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE": "Oops! {APP_NAME} nie działa jeszcze w przeglądarkach.",
    "ERROR_IN_BROWSER": "{APP_NAME} został zbudowany w HTML, jednak na razie działa jako samodzielna aplikacja. Możesz użyć jej do edycji plików na dysku. Aby uruchomić {APP_NAME} użyj aplikacji dostępnej pod adresem <b>github.com/adobe/brackets-shell</b>.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE": "Błąd podczas indeksowania plików",
    "ERROR_MAX_FILES": "Ten projekt zawiera więcej niż 30.000 plików. Funkcje, które pracują na wielu plikach mogą być wyłączone lub zachowywać się tak, jakby projekt był pusty. <a href='https://github.com/adobe/brackets/wiki/Large-Projects'>Przeczytaj więcej nt. pracy z dużymi projektami</a>.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE": "Błąd podczas uruchamiania przeglądarki",
    "ERROR_CANT_FIND_CHROME": "Nie znaleziono przeglądarki Google Chrome. Upewnij się, że jest zainstalowana.",
    "ERROR_LAUNCHING_BROWSER": "Błąd podczas uruchamiania przeglądarki. (błąd {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE": "Błąd podglądu na żywo",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE": "Łączenie z przeglądarką",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE": "Aby podgląd na żywo mógł się połączyć, Chrome musi zostać zrestartowany z włączonym zdalnym debugowaniem.<br /><br />Czy chcesz zrestartować Chrome i uaktywnić zdalne debugowanie?<br /><br />",
    "LIVE_DEV_LOADING_ERROR_MESSAGE": "Nie można wczytać strony podglądu na żywo.",
    "LIVE_DEV_NEED_HTML_MESSAGE": "Aby uruchomić podgląd na żywo, otwórz plik HTML lub upewnij się, że w Twoim projekcie jest plik index.html.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE": "Aby uruchomić podgląd na żywo na plikach serwerowych, musisz podać główny adres dla tego projektu (Base URL).",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE": "Błąd przy próbie uruchomienia serwera HTTP dla podglądu na żywo. Spróbuj ponownie.",
    "LIVE_DEVELOPMENT_INFO_TITLE": "Witaj w podglądzie na żywo (Live Preview)!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE": "Podgląd na żywo został podłączony do twojej przeglądarki. Umożliwia on podgląd twojego pliku HTML w przeglądarce oraz aktualizuje go za każdym razem, gdy edytujesz swój kod.<br /><br />W aktualnej wersji {APP_NAME}, podgląd na żywo działa tylko w <strong>Google Chrome</strong> i aktualizuje w czasie rzeczywistym <strong>pliki CSS lub HTML</strong>. Zmiany w JavaScript są automatycznie odświeżane po zapisie pliku.<br /><br />(Zobaczysz tę wiadomość tylko raz.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING": "Więcej informacji znajdziesz na stronie <a href='{0}' title='{0}'>Troubleshooting Live Preview connection errors</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED": "Podgląd na żywo",
    "LIVE_DEV_STATUS_TIP_PROGRESS1": "Podgląd na żywo: łączenie\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2": "Podgląd na żywo: inicjalizacja\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED": "Rozłącz podgląd na żywo",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC": "Podgląd na żywo (zapisz plik by odświeżyć)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR": "Podgląd na żywo (bez odświeżania - wystąpiły błędy składniowe)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS": "Podgląd na żywo został wyłączony, ponieważ uruchomiono narzędzia dla programistów w przeglądarce",
    "LIVE_DEV_DETACHED_TARGET_CLOSED": "Podgląd na żywo został wyłączony, ponieważ strona została zamknięta w przeglądarce",
    "LIVE_DEV_NAVIGATED_AWAY": "Podgląd na żywo został wyłączony, ponieważ została załadowana strona nie należąca do aktualnego projektu",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON": "Podgląd na żywo został wyłączony z nieznanego powodu ({0})",

    "SAVE_CLOSE_TITLE": "Zapisz zmiany",
    "SAVE_CLOSE_MESSAGE": "Czy chcesz zapisać zmiany w dokumencie <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE": "Czy chcesz zapisać zmiany w następujących plikach?",
    "EXT_MODIFIED_TITLE": "Zmiany zewnętrzne",
    "CONFIRM_DELETE_TITLE": "Potwierdź usunięcie",
    "CONFIRM_FILE_DELETE": "Czy na pewno chcesz usunąć plik <span class='dialog-filename'>{0}</span>?",
    "CONFIRM_FOLDER_DELETE": "Czy na pewno chcesz usunąć folder <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE": "Plik został usunięty",
    "EXT_MODIFIED_WARNING": "<span class='dialog-filename'>{0}</span> został zmodyfikowany na dysku, poza {APP_NAME}.<br /><br />Czy chcesz zapisać plik i nadpisać te zmiany?",
    "EXT_MODIFIED_MESSAGE": "<span class='dialog-filename'>{0}</span> został zmodyfikowany na dysku, poza {APP_NAME}, ale zawiera też niezapisane zmiany w {APP_NAME}.<br /><br />Którą wersję chcesz zachować?",
    "EXT_DELETED_MESSAGE": "<span class='dialog-filename'>{0}</span> został usunięty z dysku, ale zawiera niezapisane zmiany w  {APP_NAME}.<br /><br />Czy chcesz zachować te zmiany?",
    
    // Window unload warning messages
    "WINDOW_UNLOAD_WARNING": "Czy na pewno chcesz przejść do innego adresu URL i opuścić program Brackets?",
    "WINDOW_UNLOAD_WARNING_WITH_UNSAVED_CHANGES": "Masz niezapisane zmiany! Czy na pewno chcesz przejść do innego adresu URL i opuścić program Brackets?",

    // Generic dialog/button labels
    "DONE": "Gotowe",
    "OK": "OK",
    "CANCEL": "Anuluj",
    "DONT_SAVE": "Nie zapisuj",
    "SAVE": "Zapisz",
    "SAVE_AS": "Zapisz jako\u2026",
    "SAVE_AND_OVERWRITE": "Nadpisz",
    "DELETE": "Usuń",
    "BUTTON_YES": "Tak",
    "BUTTON_NO": "Nie",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX": "{0} z {1}",
    "FIND_NO_RESULTS": "Brak wyników",
    "FIND_QUERY_PLACEHOLDER": "Szukaj\u2026",
    "FIND_HISTORY_MAX_COUNT": "Maksymalna liczba wyników wyszukiwania w historii wyszukiwania",
    "REPLACE_PLACEHOLDER": "Zamień na\u2026",
    "BUTTON_REPLACE_ALL": "Zastąp wszystko",
    "BUTTON_REPLACE_BATCH": "Zamień wiele\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES": "Zamień w wielu plikach\u2026",
    "BUTTON_REPLACE": "Zamień",
    "BUTTON_NEXT": "\u25B6",
    "BUTTON_PREV": "\u25C0",
    "BUTTON_NEXT_HINT": "Kolejne wystąpienie",
    "BUTTON_PREV_HINT": "Poprzednie wystąpienie",
    "BUTTON_CASESENSITIVE_HINT": "Uwzględniaj wielkość liter",
    "BUTTON_REGEXP_HINT": "Wyrażenie zwykłe",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Zamień bez cofania",
    "REPLACE_WITHOUT_UNDO_WARNING": "Ponieważ więcej niż {0} plików wymaga zmiany, {APP_NAME} zmodyfikuje pliki na dysku, które nie są otwarte.<br />Nie będziesz możlwiości cofnięcia nadpisanych zmian w tych plikach.",
    "BUTTON_REPLACE_WITHOUT_UNDO": "Zamień bez cofania",

    "OPEN_FILE": "Otwórz plik",
    "SAVE_FILE_AS": "Zapisz plik",
    "CHOOSE_FOLDER": "Wybierz folder",

    "RELEASE_NOTES": "Informacje o wydaniu",
    "NO_UPDATE_TITLE": "{APP_NAME} jest aktualny!",
    "NO_UPDATE_MESSAGE": "Aktualnie używasz najnowszej wersji {APP_NAME}.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL": "Zamień",
    "FIND_REPLACE_TITLE_WITH": "z",
    "FIND_TITLE_LABEL": "Znaleziono",
    "FIND_TITLE_SUMMARY": "&mdash; {0} {1} {2} w {3}",

    // Find in Files
    "FIND_NUM_FILES": "{0} {1}",
    "FIND_IN_FILES_SCOPED": "w <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE": "w projekcie",
    "FIND_IN_FILES_ZERO_FILES": "Filtr wyklucza wszystkie pliki {0}",
    "FIND_IN_FILES_FILE": "plik",
    "FIND_IN_FILES_FILES": "pliki",
    "FIND_IN_FILES_MATCH": "dopasowanie",
    "FIND_IN_FILES_MATCHES": "dopasowania",
    "FIND_IN_FILES_MORE_THAN": "Więcej niż ",
    "FIND_IN_FILES_PAGING": "{0} &mdash; {1}",
    "FIND_IN_FILES_FILE_PATH": "<span class='dialog-filename'>{0}</span> {2} <span class='dialog-path'>{1}</span>",
    "FIND_IN_FILES_EXPAND_COLLAPSE": "Naciśnij Ctrl/Cmd by rozwinąć/zwinąć wszystkie",
    "FIND_IN_FILES_INDEXING": "Indeksowanie do natychmiastowego wyszukiwania\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE": "Zamień błędy",
    "REPLACE_IN_FILES_ERRORS": "Poniższe pliki nie zostały zmienione, ponieważ ich treść zmieniła się po zakończeniu wyszukiwania lub nie mogły być zapisane.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE": "Błąd podczas pobierania informacji o aktualizacjach",
    "ERROR_FETCHING_UPDATE_INFO_MSG": "Wystąpił problem podczas pobierania informacji o najnowszej wersji aplikacji. Upewnij się, że masz połączenie z internetem i spróbuj ponownie",

    // File exclusion filters
    "NEW_FILE_FILTER": "Nowy filtr\u2026",
    "CLEAR_FILE_FILTER": "Nie wykluczaj plików",
    "NO_FILE_FILTER": "Brak wykluczonych plików",
    "EXCLUDE_FILE_FILTER": "Wyklucz {0}",
    "EDIT_FILE_FILTER": "Edytuj\u2026",
    "FILE_FILTER_DIALOG": "Edytuj wykluczenia",
    "FILE_FILTER_INSTRUCTIONS": "Wyklucz pliki/foldery pasujące do następujących nazw, wzorów lub <a href='{0}' title='{0}'>masek</a>. Każdą regułę umieść w osobnej linii.",
    "FILTER_NAME_PLACEHOLDER": "Nazwa wykluczenia (opcjonalnie)",
    "FILTER_NAME_REMAINING": "Pozostało znaków: {0}",
    "FILE_FILTER_CLIPPED_SUFFIX": "i {0} więcej",
    "FILTER_COUNTING_FILES": "Liczenie plików\u2026",
    "FILTER_FILE_COUNT": "Przeszukane zostanie {0} z {1} plików {2}",
    "FILTER_FILE_COUNT_ALL": "Przeszukane zostanie wszystkie {0} plików {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND": "Nie można użyć szybkiej edycji w tym miejscu",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES": "Szybka edycja CSS: zaznacz kursorem pojedynczą nazwę klasy",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND": "Szybka edycja CSS: niekompletny atrybut class",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND": "Szybka edycja CSS: niekompletny atrybut id",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR": "Szybka edycja CSS: zaznacz kursorem tag, klasę lub id",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX": "Szybka edycja funkcji czasowych CSS: nieprawidłowa składnia",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND": "Szybka edycja JS: zaznacz kursorem nazwę funkcji",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND": "Nie znaleziono dokumentacji dla tego elementu.",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING": "Ładowanie\u2026",
    "UNTITLED": "Bez tytułu",
    "WORKING_FILES": "Otwarte pliki",

    /**
     * MainViewManager
     */
    "TOP": "Panel górny",
    "BOTTOM": "Panel dolny",
    "LEFT": "Panel lewy",
    "RIGHT": "Panel prawy",

    "CMD_SPLITVIEW_NONE": "Bez podziału",
    "CMD_SPLITVIEW_VERTICAL": "Podziel pionowo",
    "CMD_SPLITVIEW_HORIZONTAL": "Podziel poziomo",
    "SPLITVIEW_MENU_TOOLTIP": "Podziel edytor pionowo lub poziomo",
    "GEAR_MENU_TOOLTIP": "Uporządkuj pliki",

    "SPLITVIEW_INFO_TITLE": "Plik jest już otwarty",
    "SPLITVIEW_MULTIPANE_WARNING": "Plik jest już otwarty w innym panelu. {APP_NAME} niedługo będzie pozwalał otwierać ten sam plik w wielu panelach. Do tego czasu plik będzie widoczny w panelu, w którym już jest otwarty.<br /><br />(Tę wiadomość zobaczysz tylko raz)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL": "Ctrl",
    "KEYBOARD_SHIFT": "Shift",
    "KEYBOARD_SPACE": "Spacja",
    "KEYBOARD_PAGE_UP": "Page Up",
    "KEYBOARD_PAGE_DOWN": "Page Down",
    "KEYBOARD_HOME": "Home",
    "KEYBOARD_END": "End",
    "KEYBOARD_INSERT": "Insert",
    "KEYBOARD_DELETE": "Delete",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION": "linia {0}, kolumna {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR": " \u2014 Zaznaczono {0} kolumnę",
    "STATUSBAR_SELECTION_CH_PLURAL": " \u2014 Zaznaczono {0} kolumn",
    "STATUSBAR_SELECTION_LINE_SINGULAR": " \u2014 Zaznaczono {0} linię",
    "STATUSBAR_SELECTION_LINE_PLURAL": " \u2014 Zaznaczono {0} linii",
    "STATUSBAR_SELECTION_MULTIPLE": " \u2014 {0} zaznaczeń",
    "STATUSBAR_INDENT_TOOLTIP_SPACES": "Kliknij, by zamienić wcięcia na spacje",
    "STATUSBAR_INDENT_TOOLTIP_TABS": "Kliknij, by zamienić wcięcia na tabulacje",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES": "Kliknij, by zmienić ilość spacji we wcięciu",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS": "Kliknij, by zmienić wielkość tabulacji",
    "STATUSBAR_SPACES": "Spacje:",
    "STATUSBAR_TAB_SIZE": "Tabulacje:",
    "STATUSBAR_LINE_COUNT_SINGULAR": "\u2014 {0} linia",
    "STATUSBAR_LINE_COUNT_PLURAL": "\u2014 {0} linii",
    "STATUSBAR_USER_EXTENSIONS_DISABLED": "Rozszerzenia wyłączone",
    "STATUSBAR_INSERT": "WST",
    "STATUSBAR_OVERWRITE": "OVR",
    "STATUSBAR_INSOVR_TOOLTIP": "Kliknij aby zmienić tryb wprowadzania: wstaw (INS) lub zastąp (OVR)",
    "STATUSBAR_LANG_TOOLTIP": "Kliknij aby zmienić rodzaj pliku (podświetlanie składni)",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP": "{0}. Naciśnij aby włączyć/wyłączyć panel raportów.",
    "STATUSBAR_DEFAULT_LANG": "(domyślnie)",
    "STATUSBAR_SET_DEFAULT_LANG": "Ustaw domyślny dla plików .{0}",
    "STATUSBAR_ENCODING_TOOLTIP": "Wybierz kodowanie",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE": "{0} problemów",
    "SINGLE_ERROR": "1 błąd {0}",
    "MULTIPLE_ERRORS": "{1} błędów {0} ",
    "NO_ERRORS": "Brak błędów {0} – dobra robota!",
    "NO_ERRORS_MULTIPLE_PROVIDER": "Brak błędów - dobra robota!",
    "LINT_DISABLED": "Linting jest wyłączony.",
    "NO_LINT_AVAILABLE": "Żaden linter nie jest dostępny dla {0}",
    "NOTHING_TO_LINT": "Brak plików do sprawdzenia.",
    "LINTER_TIMED_OUT": "{0} przekroczył limit czasu, czekał {1} ms",
    "LINTER_FAILED": "{0} zakończył z błędem: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU": "Plik",
    "CMD_FILE_NEW_UNTITLED": "Nowy",
    "CMD_FILE_NEW": "Nowy plik",
    "CMD_FILE_NEW_FOLDER": "Nowy folder",
    "CMD_FILE_OPEN": "Otwórz\u2026",
    "CMD_RECENT_FILES_OPEN": "Otwórz ostatnie\u2026",
    "CMD_ADD_TO_WORKING_SET": "Dodaj do folderu roboczego",
    "CMD_OPEN_DROPPED_FILES": "Otwórz przeciągnięte pliki",
    "CMD_OPEN_FOLDER": "Otwórz folder\u2026",
    "CMD_FILE_CLOSE": "Zamknij",
    "CMD_FILE_CLOSE_ALL": "Zamknij wszystko",
    "CMD_FILE_CLOSE_LIST": "Zamknij listę",
    "CMD_FILE_CLOSE_OTHERS": "Zamknij inne",
    "CMD_FILE_CLOSE_ABOVE": "Zamknij pliki powyżej",
    "CMD_FILE_CLOSE_BELOW": "Zamknij pliki poniżej",
    "CMD_FILE_SAVE": "Zapisz",
    "CMD_FILE_SAVE_ALL": "Zapisz wszystko",
    "CMD_FILE_SAVE_AS": "Zapisz jako\u2026",
    "CMD_LIVE_FILE_PREVIEW": "Podgląd na żywo",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE": "Podgląd na żywo (eksperymentalny)",
    "CMD_RELOAD_LIVE_PREVIEW": "Wymuś przeładowanie podglądu na żywo",
    "CMD_PROJECT_SETTINGS": "Ustawienia projektu\u2026",
    "CMD_FILE_RENAME": "Zmień nazwę",
    "CMD_FILE_DELETE": "Usuń",
    "CMD_INSTALL_EXTENSION": "Zainstaluj rozszerzenie\u2026",
    "CMD_EXTENSION_MANAGER": "Menedżer rozszerzeń\u2026",
    "CMD_FILE_REFRESH": "Odśwież",
    "CMD_QUIT": "Zakończ",
    // Used in native File menu on Windows
    "CMD_EXIT": "Wyjdź",

    // Edit menu commands
    "EDIT_MENU": "Edytuj",
    "CMD_UNDO": "Cofnij",
    "CMD_REDO": "Ponów",
    "CMD_CUT": "Wytnij",
    "CMD_COPY": "Kopiuj",
    "CMD_PASTE": "Wklej",
    "CMD_SELECT_ALL": "Zaznacz wszystko",
    "CMD_SELECT_LINE": "Zaznacz linię",
    "CMD_SPLIT_SEL_INTO_LINES": "Podziel zaznaczenie na linie",
    "CMD_ADD_CUR_TO_NEXT_LINE": "Dodaj kursor do następnej linii",
    "CMD_ADD_CUR_TO_PREV_LINE": "Dodaj kursor do poprzedniej linii",
    "CMD_INDENT": "Wcięcie",
    "CMD_UNINDENT": "Cofnij wcięcie",
    "CMD_DUPLICATE": "Powiel",
    "CMD_DELETE_LINES": "Usuń linię",
    "CMD_COMMENT": "Przełącz komentarz w wierszu",
    "CMD_BLOCK_COMMENT": "Przełącz komentarz blokowy",
    "CMD_LINE_UP": "Przenieś linię wyżej",
    "CMD_LINE_DOWN": "Przenieś linię niżej",
    "CMD_OPEN_LINE_ABOVE": "Otwórz linię wyżej",
    "CMD_OPEN_LINE_BELOW": "Otwórz linię niżej",
    "CMD_TOGGLE_CLOSE_BRACKETS": "Automatycznie zamykaj nawiasy",
    "CMD_SHOW_CODE_HINTS": "Pokaż podpowiedź",

    // Search menu commands
    "FIND_MENU": "Znajdź",
    "CMD_FIND": "Znajdź",
    "CMD_FIND_NEXT": "Znajdź następny",
    "CMD_FIND_PREVIOUS": "Znajdź poprzednie",
    "CMD_FIND_ALL_AND_SELECT": "Znajdź wszystkie i zaznacz",
    "CMD_ADD_NEXT_MATCH": "Dodaj następny wynik do zaznaczenia",
    "CMD_SKIP_CURRENT_MATCH": "Pomiń i dodaj następny wynik",
    "CMD_FIND_IN_FILES": "Szukaj w plikach",
    "CMD_FIND_IN_SUBTREE": "Szukaj w\u2026",
    "CMD_REPLACE": "Zamień",
    "CMD_REPLACE_IN_FILES": "Zamień w plikach",
    "CMD_REPLACE_IN_SUBTREE": "Zamień w\u2026",

    // View menu commands
    "VIEW_MENU": "Widok",
    "CMD_HIDE_SIDEBAR": "Ukryj pasek boczny",
    "CMD_SHOW_SIDEBAR": "Pokaż pasek boczny",
    "CMD_TOGGLE_SIDEBAR": "Przełącz pasek boczny",
    "CMD_TOGGLE_PANELS": "Przełącz panele",
    "CMD_TOGGLE_PURE_CODE": "Tryb bez przeszkadzania",
    "CMD_INCREASE_FONT_SIZE": "Zwiększ czcionkę",
    "CMD_DECREASE_FONT_SIZE": "Zmniejsz czcionkę",
    "CMD_RESTORE_FONT_SIZE": "Przywróć domyślny rozmiar czcionki",
    "CMD_SCROLL_LINE_UP": "Przewiń linię wyżej",
    "CMD_SCROLL_LINE_DOWN": "Przewiń linię niżej",
    "CMD_TOGGLE_LINE_NUMBERS": "Numery wierszy",
    "CMD_TOGGLE_ACTIVE_LINE": "Podświetl aktualną linię",
    "CMD_TOGGLE_WORD_WRAP": "Zawijanie tekstu",
    "CMD_LIVE_HIGHLIGHT": "Podświetlaj w podglądzie na żywo",
    "CMD_VIEW_TOGGLE_INSPECTION": "Sprawdzaj poprawność plików przy zapisie",
    "CMD_WORKINGSET_SORT_BY_ADDED": "Sortuj według dodanych",
    "CMD_WORKINGSET_SORT_BY_NAME": "Sortuj według nazwy",
    "CMD_WORKINGSET_SORT_BY_TYPE": "Sortuj według typu",
    "CMD_WORKING_SORT_TOGGLE_AUTO": "Automatyczne sortowanie",
    "CMD_THEMES": "Motywy\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU": "Nawigacja",
    "CMD_QUICK_OPEN": "Otwórz szybko",
    "CMD_GOTO_LINE": "Przejdź do wiersza",
    "CMD_GOTO_DEFINITION": "Znajdź szybko definicję",
    "CMD_GOTO_FIRST_PROBLEM": "Przejdź do pierwszego błędu",
    "CMD_TOGGLE_QUICK_EDIT": "Szybka edycja",
    "CMD_TOGGLE_QUICK_DOCS": "Szybkie dokumenty",
    "CMD_QUICK_EDIT_PREV_MATCH": "Poprzednie wystąpienie",
    "CMD_QUICK_EDIT_NEXT_MATCH": "Kolejne wystąpienie",
    "CMD_CSS_QUICK_EDIT_NEW_RULE": "Nowa reguła",
    "CMD_NEXT_DOC": "Następny dokument",
    "CMD_PREV_DOC": "Poprzedni dokument",
    "CMD_NAVIGATE_BACKWARD": "Przejdź wstecz",
    "CMD_NAVIGATE_FORWARD": "Przejdź do przodu",
    "CMD_NEXT_DOC_LIST_ORDER": "Następny dokument z listy",
    "CMD_PREV_DOC_LIST_ORDER": "Poprzedni dokument z listy",
    "CMD_SHOW_IN_TREE": "Pokaż w drzewie katalogów",
    "CMD_SHOW_IN_EXPLORER": "Pokaż w eksploratorze",
    "CMD_SHOW_IN_FINDER": "Pokaż w Finder",
    "CMD_SHOW_IN_OS": "Pokaż w systemie plików",
    "CMD_SWITCH_PANE_FOCUS": "Zmień panel",

    // Help menu commands
    "HELP_MENU": "Pomoc",
    "CMD_CHECK_FOR_UPDATE": "Sprawdź aktualizacje",
    "CMD_HOW_TO_USE_BRACKETS": "Jak używać {APP_NAME}",
    "CMD_SUPPORT": "Wsparcie {APP_NAME}",
    "CMD_SUGGEST": "Zaproponuj swój pomysł",
    "CMD_RELEASE_NOTES": "Informacje o wydaniu",
    "CMD_GET_INVOLVED": "Daj coś od siebie",
    "CMD_SHOW_EXTENSIONS_FOLDER": "Otwórz folder z rozszerzeniami",
    "CMD_HEALTH_DATA_STATISTICS": "Raportowanie",
    "CMD_HOMEPAGE": "Strona główna {APP_TITLE}",
    "CMD_TWITTER": "{TWITTER_NAME} na Twitterze",
    "CMD_ABOUT": "O programie",
    "CMD_OPEN_PREFERENCES": "Otwórz plik z ustawieniami",
    "CMD_OPEN_KEYMAP": "Otwórz plik z konfiguracją klawiszy",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD": "kompilacja eksperymentalna",
    "RELEASE_BUILD": "kompilacja",
    "DEVELOPMENT_BUILD": "kompilacja rozwojowa",
    "RELOAD_FROM_DISK": "Załaduj z dysku",
    "KEEP_CHANGES_IN_EDITOR": "Zachowaj zmiany w edytorze",
    "CLOSE_DONT_SAVE": "Zamknij (nie zapisuj)",
    "RELAUNCH_CHROME": "Zrestartuj Chrome",
    "ABOUT": "Opis",
    "CLOSE": "Zamknij",
    "ABOUT_TEXT_LINE1": "Wydanie {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP": "Czas kompilacji: ",
    "ABOUT_TEXT_LINE3": "Uwagi i warunki odnoszące się do oprogramowania firm trzecich znajdują się na: <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> i zostały dołączone jako odnośnik.",
    "ABOUT_TEXT_LINE4": "Dokumentacja i pliki źródłowe dostępne są pod adresem <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>",
    "ABOUT_TEXT_LINE5": "Stworzony z \u2764 oraz w JavaScript przez:",
    "ABOUT_TEXT_LINE6": "Mnóstwo ludzi (mamy problemy, by załadować teraz te wszystkie dane).",
    "ABOUT_TEXT_MDN_DOCS": "Dokumentacja MDN oraz logo graficzne MDN są udostępniane na licencji Creative Commons „Uznanie autorstwa”, <a href='{MDN_DOCS_LICENSE}'>CC-BY-SA 2.5 Unported</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP": "Dostępna jest nowa wersja {APP_NAME}! Kliknij tutaj i dowiedz się więcej.",
    "UPDATE_AVAILABLE_TITLE": "Dostępna nowa aktualizacja",
    "UPDATE_MESSAGE": "Hej, dostępna jest już nowa wersja {APP_NAME}. Oto kilka nowych funkcjonalności:",
    "GET_IT_NOW": "Pobierz teraz!",
    "PROJECT_SETTINGS_TITLE": "Ustawienia projektu dla: {0}",
    "PROJECT_SETTING_BASE_URL": "Adres podglądu na żywo",
    "PROJECT_SETTING_BASE_URL_HINT": "Aby użyć lokalnego serwera, wpisz odpowiedni adres, np. http://localhost:8000/",
    "BASEURL_ERROR_INVALID_PROTOCOL": "Protokół {0} nie jest wspierany przez podgląd na żywo&mdash;Użyj http lub https.",
    "BASEURL_ERROR_SEARCH_DISALLOWED": "Adres URL nie może zawierać parametrów wyszukiwania takich, jak \"{0}\".",
    "BASEURL_ERROR_HASH_DISALLOWED": "Adres URL nie może zawierać znaku hash: \"{0}\".",
    "BASEURL_ERROR_INVALID_CHAR": "Znaki specjalne takie, jak '{0}' muszą być zakodowane.",
    "BASEURL_ERROR_UNKNOWN_ERROR": "Nieznany błąd podczas parsowania adresu URL",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER": "<em>Kliknij w to okno, a następnie otwórz plik</em>",
    "FLIPVIEW_BTN_TOOLTIP": "Przenieś ten widok do: {0}",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME": "Aktualny motyw",
    "USE_THEME_SCROLLBARS": "Użyj pasków przewijania z motywu",
    "FONT_SIZE": "Rozmiar czcionki",
    "FONT_FAMILY": "Rodzina czcionek",
    "THEMES_SETTINGS": "Ustawienia motywów",

    // CSS Quick Edit
    "BUTTON_NEW_RULE": "Nowa reguła",

    // Extension Management strings
    "INSTALL": "Zainstaluj",
    "UPDATE": "Uaktualnij",
    "REMOVE": "Usuń",
    "DISABLE": "Wyłącz",
    "ENABLE": "Włącz",
    "OVERWRITE": "Nadpisz",
    "CANT_REMOVE_DEV": "Rozszerzenia w folderze \"dev\" muszą być usunięte ręcznie.",
    "CANT_UPDATE": "Aktualizacja nie jest kompatybilna z tą wersją {APP_NAME}.",
    "CANT_UPDATE_DEV": "Rozszerzenia w folderze \"dev\" nie mogą być automatycznie zaktualizowane.",
    "INSTALL_EXTENSION_TITLE": "Zainstaluj rozszerzenie",
    "UPDATE_EXTENSION_TITLE": "Aktualizuj rozszerzenie",
    "INSTALL_EXTENSION_LABEL": "Adres URL rozszerzenia",
    "INSTALL_EXTENSION_HINT": "Adres URL pliku zip z rozszerzeniem lub adres repozytorium na GitHub",
    "INSTALLING_FROM": "Instaluję rozszerzenie z {0}\u2026",
    "INSTALL_SUCCEEDED": "Instalacja zakończona!",
    "INSTALL_FAILED": "Instalacja nie powiodła się.",
    "CANCELING_INSTALL": "Anulowanie\u2026",
    "CANCELING_HUNG": "Anulowanie instalacji trwa zbyt długo. Możliwe, że wystąpił błąd wewnętrzny.",
    "INSTALL_CANCELED": "Instalacja anulowana.",
    "VIEW_COMPLETE_DESCRIPTION": "Pokaż cały opis",
    "VIEW_TRUNCATED_DESCRIPTION": "Pokaż skrócony opis",
    "SORT_EXTENSION_METHOD": "Sortowanie rozszerzeń według licznika pobrań lub daty publikacji",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE": "Pobrany plik nie jest poprawnym plikiem zip.",
    "MISSING_PACKAGE_JSON": "Pakiet nie zawiera pliku package.json.",
    "INVALID_PACKAGE_JSON": "Plik package.json nie jest poprawny (wystąpił błąd: {0}).",
    "MISSING_PACKAGE_NAME": "Plik package.json nie zawiera nazwy pakietu.",
    "BAD_PACKAGE_NAME": "{0} jest niepoprawną nazwą pakietu.",
    "MISSING_PACKAGE_VERSION": "Plik package.json nie zawiera wersji pakietu.",
    "INVALID_VERSION_NUMBER": "Numer wersji pakietu ({0}) jest niepoprawny.",
    "INVALID_BRACKETS_VERSION": "Ciąg kompatybilności z {APP_NAME} ({0}) jest nieprawidłowy.",
    "DISALLOWED_WORDS": "Słowa ({1}) są niedozwolone w polu {0}.",
    "NPM_INSTALL_FAILED": "Polecenie instalacji nie powiodło się: {0}",
    "API_NOT_COMPATIBLE": "Rozszerzenie nie jest kompatybilne z tą wersją {APP_NAME}. Jest zainstalowane w folderze z nieaktywnymi rozszerzeniami.",
    "MISSING_MAIN": "Pakiet nie zawiera pliku main.js.",
    "EXTENSION_ALREADY_INSTALLED": "Zainstalowanie tego rozszerzenia nadpisze to, które zainstalowano poprzednio. Czy nadpisać starsze rozszerzenie?",
    "EXTENSION_SAME_VERSION": "To rozszerzenie jest w tej samej wersji, co obecnie zainstalowane. Czy nadpisać zainstalowane rozszerzenie?",
    "EXTENSION_OLDER_VERSION": "To rozszerzenie jest w wersji {0}, czyli jest starsze niż obecnie zainstalowane ({1}). Czy nadpisać zainstalowane rozszerzenie?",
    "DOWNLOAD_ID_IN_USE": "Błąd wewnętrzny: taki plik już istnieje.",
    "NO_SERVER_RESPONSE": "Nie można połączyć z serwerem.",
    "BAD_HTTP_STATUS": "Nie znaleziono pliku na serwerze (HTTP {0}).",
    "CANNOT_WRITE_TEMP": "Nie można zapisać pobranego pliku w folderze tymczasowym.",
    "ERROR_LOADING": "Rozszerzenie napotkało błąd podczas uruchamiania.",
    "MALFORMED_URL": "Niepoprawny adres URL. Sprawdź czy został wpisany prawidłowo.",
    "UNSUPPORTED_PROTOCOL": "Adres URL musi zaczynać się od http lub https.",
    "UNKNOWN_ERROR": "Nieznany błąd wewnętrzny.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE": "Extension Manager",
    "EXTENSION_MANAGER_ERROR_LOAD": "Nie udało się dostać do rejestru rozszerzeń. Spróbuj ponownie później.",
    "INSTALL_EXTENSION_DRAG": "Przenieś plik .zip lub",
    "INSTALL_EXTENSION_DROP": "Przenieś plik .zip aby zainstalować",
    "INSTALL_EXTENSION_DROP_ERROR": "Instalacja/aktualizacja przerwana z powodu błędów:",
    "INSTALL_FROM_URL": "zainstaluj z adresu URL\u2026",
    "INSTALL_EXTENSION_VALIDATING": "Sprawdzanie\u2026",
    "EXTENSION_AUTHOR": "Autor",
    "EXTENSION_DATE": "Data",
    "EXTENSION_INCOMPATIBLE_NEWER": "To rozszerzenie wymaga nowszej wersji {APP_NAME}.",
    "EXTENSION_INCOMPATIBLE_OLDER": "To rozszerzenie działa tylko ze starszymi wersjami {APP_NAME}.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER": "Wersja {0} tego rozszerzenia wymaga nowszej wersji {APP_NAME}, ale możesz zainstalować starszą wersję {1}.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER": "Wersja {0} tego rozszerzenia wymaga starszej wersji {APP_NAME}, ale możesz zainstalować starszą wersję {1}.",
    "EXTENSION_NO_DESCRIPTION": "Brak opisu",
    "EXTENSION_MORE_INFO": "Więcej informacji\u2026",
    "EXTENSION_ERROR": "Błąd rozszerzenia",
    "EXTENSION_KEYWORDS": "Słowa kluczowe",
    "EXTENSION_TRANSLATED_USER_LANG": "Przetłumaczono na {0} języków, w tym twój",
    "EXTENSION_TRANSLATED_GENERAL": "Przetłumaczono na {0} języków",
    "EXTENSION_TRANSLATED_LANGS": "To rozszerzenie zostało przetłumaczone na języki: {0}",
    "EXTENSION_INSTALLED": "Zainstalowane",
    "EXTENSION_UPDATE_INSTALLED": "Aktualizacja rozszerzenia została pobrana i będzie zainstalowana po przeładowaniu {APP_NAME}.",
    "EXTENSION_SEARCH_PLACEHOLDER": "Szukaj",
    "EXTENSION_MORE_INFO_LINK": "Więcej",
    "BROWSE_EXTENSIONS": "Przeglądaj rozszerzenia",
    "EXTENSION_MANAGER_REMOVE": "Usuń rozszerzenie",
    "EXTENSION_MANAGER_REMOVE_ERROR": "Nie udało się usunąć rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "EXTENSION_MANAGER_UPDATE": "Aktualizuj rozszerzenie",
    "EXTENSION_MANAGER_UPDATE_ERROR": "Nie udało się zaktualizować rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "EXTENSION_MANAGER_DISABLE": "Wyłącz rozszerzenie",
    "EXTENSION_MANAGER_DISABLE_ERROR": "Nie udało się wyłączyć rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "MARKED_FOR_REMOVAL": "Zaznaczono do usunięcia",
    "UNDO_REMOVE": "Cofnij",
    "MARKED_FOR_UPDATE": "Zaznaczono do aktualizacji",
    "UNDO_UPDATE": "Cofnij",
    "MARKED_FOR_DISABLING": "Zaznaczono do wyłączenia",
    "UNDO_DISABLE": "Cofnij",
    "CHANGE_AND_RELOAD_TITLE": "Zmień rozszerzenia",
    "CHANGE_AND_RELOAD_MESSAGE": "Aby zaktualizować, usunąć lub wyłączyć zaznaczone rozszerzenia, {APP_NAME} musi zostać zrestartowany. Zostaniesz poproszony o zapisanie zmian.",
    "REMOVE_AND_RELOAD": "Usuń rozszerzenia i zrestartuj",
    "CHANGE_AND_RELOAD": "Zmień rozszerzenia i zrestartuj",
    "UPDATE_AND_RELOAD": "Zaktualizuj rozszerzenia i zrestartuj",
    "DISABLE_AND_RELOAD": "Wyłącz rozszerzenia i zrestartuj",
    "PROCESSING_EXTENSIONS": "Przetwarzanie\u2026",
    "EXTENSION_NOT_INSTALLED": "Nie można usunąć rozszerzenia {0}, ponieważ nie zostało zainstalowane.",
    "NO_EXTENSIONS": "Nie masz jeszcze żadnych rozszerzeń.<br>Użyj zakładki Dostępne (powyżej), aby zobaczyć listę.",
    "NO_EXTENSION_MATCHES": "Nie znaleziono pasujących rozszerzeń.",
    "REGISTRY_SANITY_CHECK_WARNING": "Uwaga: te rozszerzenia mogą pochodzić od innych autorów i mają pełne uprawnienia. Uważaj gdy instalujesz rozszerzenia z nieznanych źródeł.",
    "EXTENSIONS_INSTALLED_TITLE": "Zainstalowane",
    "EXTENSIONS_DEFAULT_TITLE": "Default",
    "EXTENSIONS_AVAILABLE_TITLE": "Dostępne",
    "EXTENSIONS_THEMES_TITLE": "Motywy",
    "EXTENSIONS_UPDATES_TITLE": "Aktualizacje",
    "EXTENSIONS_LAST_UPDATED": "Ostatnia aktualizacja",
    "EXTENSIONS_DOWNLOADS": "Do pobrania",

    "INLINE_EDITOR_NO_MATCHES": "Brak wyników.",
    "INLINE_EDITOR_HIDDEN_MATCHES": "Wszystkie wyniki zostały zwinięte. Rozwiń listę plików po prawej, by pokazać wyniki.",
    "CSS_QUICK_EDIT_NO_MATCHES": "Brak reguł.<br> Kliknij \"Nowa reguła\", aby ją utworzyć.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS": "W twoim projekcie brakuje stylów CSS.<br>Stwórz je, by móc dodawać reguły CSS.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON": "największy",

    /**
     * Unit names
     */
    "UNIT_PIXELS": "pikseli",

    // extensions/default/DebugCommands
    "DEBUG_MENU": "Debuguj",
    "ERRORS": "Błędy",
    "CMD_SHOW_DEV_TOOLS": "Pokaż narzędzia deweloperskie",
    "CMD_REFRESH_WINDOW": "Uruchom ponownie z rozszerzeniami",
    "CMD_RELOAD_WITHOUT_USER_EXTS": "Uruchom ponownie bez rozszerzeń",
    "CMD_NEW_BRACKETS_WINDOW": "Nowe okno",
    "CMD_LAUNCH_SCRIPT_MAC": "Zainstaluj skrót do wiersza poleceń",
    "CMD_SWITCH_LANGUAGE": "Zmień język",
    "CMD_RUN_UNIT_TESTS": "Uruchom testy",
    "CMD_SHOW_PERF_DATA": "Pokaż informacje o wydajności",
    "CMD_ENABLE_NODE_DEBUGGER": "Włącz debugger Node",
    "CMD_LOG_NODE_STATE": "Zapisz stan Node w konsoli",
    "CMD_RESTART_NODE": "Zrestartuj Node",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR": "Pokazuj błędy na pasku statusu",
    "CMD_OPEN_BRACKETS_SOURCE": "Otwórz kod źródłowy {APP_NAME}",

    "CREATING_LAUNCH_SCRIPT_TITLE": "Skrót do wiersza poleceń {APP_NAME}",
    "ERROR_CREATING_LAUNCH_SCRIPT": "Błąd podczas instalacji skrótu wiersza poleceń. Przeczytaj artykuł <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>z propozycjami rozwiązania tego problemu.</a>.<br/><br/>Powód: {0}",
    "ERROR_CLTOOLS_RMFAILED": "Nie można usunąć istniejącego dowiązania <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_MKDIRFAILED": "Nie można utworzyć katalogu <code>/usr/local/bin</code>.",
    "ERROR_CLTOOLS_LNFAILED": "Nie można utworzyć dowiązania <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_SERVFAILED": "Błąd wewnętrzny.",
    "ERROR_CLTOOLS_NOTSUPPORTED": "Skrót do wiersza poleceń nie jest dostępny w tym systemie.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS": "Udało się! Teraz możesz uruchamiać {APP_NAME} z wiersza poleceń: <code>brackets plik.txt</code> aby otworzyć plik lub <code>brackets folder</code> aby zmienić projekt. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Przeczytaj więcej</a> na temat używania {APP_NAME} w wierszu poleceń.",

    "LANGUAGE_TITLE": "Zmień język",
    "LANGUAGE_MESSAGE": "Język:",
    "LANGUAGE_SUBMIT": "Zrestartuj {APP_NAME}",
    "LANGUAGE_CANCEL": "Anuluj",
    "LANGUAGE_SYSTEM_DEFAULT": "Domyślny systemu",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION": "Ustawienia raportowania",
    "HEALTH_FIRST_POPUP_TITLE": "Raporty {APP_NAME}",
    "HEALTH_DATA_DO_TRACK": "Wysyłaj anonimowe informacje o tym, jak używam {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE": "Aby ciągle udoskonalać {APP_NAME}, co pewien czas wysyłamy <strong>anonimowe</strong> statystyki do Adobe na temat tego, jak korzystasz z edytora. Informacje te pomagają nam tworzyć lepsze funkcjonalności, wyszukiwać problemy czy poprawiać wygodę w korzystaniu z programu. <br><br>Możesz zobaczyć co przesyłamy lub wyłączyć przesyłanie danych w menu <strong>Pomoc > Raportowanie</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Przeczytaj więcej o raportach w {APP_NAME}</a>",
    "HEALTH_DATA_PREVIEW": "Raporty {APP_NAME}",
    "HEALTH_DATA_PREVIEW_INTRO": "<p>Aby ciągle udoskonalać {APP_NAME}, co pewien czas wysyłamy <strong>anonimowe</strong> statystyki do Adobe na temat tego, jak wykorzystujesz {APP_NAME}. Informacje te pomagają nam tworzyć lepsze funkcjonalności, znajdować problemy czy poprawiać wygodę w korzystaniu z programu. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Przeczytaj więcej o raportach w {APP_NAME}</a> oraz w jaki sposób pomaga to całej społeczności {APP_NAME}, jednocześnie dbając o twoją prywatność.</p><p>Poniżej możesz podejrzeć jakie dane zostaną przesłane w twoim następnym raporcie <em>jeżeli</em> jest u uaktywniony.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME": "Czas",
    "INLINE_TIMING_EDITOR_PROGRESSION": "Postęp",
    "BEZIER_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Przenieś zaznaczony punkt<br><kbd class='text'>Shift</kbd> Przenieś o 10 jednostek<br><kbd class='text'>Tab</kbd> Zmień punkt",
    "STEPS_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd> Zwiększ lub zmniejsz kroki<br><kbd>←</kbd><kbd>→</kbd> 'Start' lub 'End'",
    "INLINE_TIMING_EDITOR_INVALID": "Poprzednia wartość <code>{0}</code> jest niepoprawna, więc została zamieniona na <code>{1}</code>. Dokument zostanie uaktualniony podczas pierwszej edycji.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP": "Aktualny kolor",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP": "Orginalny kolor",
    "COLOR_EDITOR_RGBA_BUTTON_TIP": "Format RGBa",
    "COLOR_EDITOR_HEX_BUTTON_TIP": "Format Hex",
    "COLOR_EDITOR_HSLA_BUTTON_TIP": "Format HSLa",
    "COLOR_EDITOR_0X_BUTTON_TIP": "Format Hex (0x)",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR": "{0} (użyto {1} raz)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL": "{0} (użyto {1} razy)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION": "Przejdź do definicji",
    "CMD_SHOW_PARAMETER_HINT": "Pokaż podpowiedź (parametr)",
    "NO_ARGUMENTS": "<brak parametrów>",
    "DETECTED_EXCLUSION_TITLE": "Błąd podczas sprawdzania poprawności kodu JavaScript",
    "DETECTED_EXCLUSION_INFO": "{APP_NAME} napotkał problemy podczas przetwarzania pliku <span class='dialog-filename'>{0}</span>.<br><br>Plik nie będzie już przetwarzany w celu pokazywania podpowiedzi w kodzie, wykorzystywaniu Przejdź do definicji lub do Szybkiej Edycji. Aby przywrócić dla pliku te funkcjonalności, otwórz <code>.brackets.json</code> w swoim projekcie i edytuj plik <code>jscodehints.detectedExclusions</code>.<br><br>Jest to prawdopodobnie błąd {APP_NAME}. Jeżeli chcesz dostarczyć kopię tego pliku, prosimy <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>prześlij plik z błędem</a>.",

    // extensions/default/JSLint
    "JSLINT_NAME": "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW": "Szybki Podgląd po najechaniu na element",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS": "Ostatnie projekty",

    // extensions/default/MDNDocs
    "DOCS_MORE_LINK": "Czytaj więcej",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL": "Zwiń wszystko",
    "EXPAND_ALL": "Rozwiń wszystko",
    "COLLAPSE_CURRENT": "Zwiń element",
    "EXPAND_CURRENT": "Rozwiń element",

    // extensions/default/NavigationAndHistory
    "RECENT_FILES_DLG_HEADER": "Ostatnie pliki",
    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL": "Wyczyść",
    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE": "Wyczyść pliki spoza zbioru roboczego",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS": "użyj wartości „true”, aby automatycznie zamykać nawiasy okrągłe i kwadratowe oraz klamry ",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE": "użyj wartości „false”, aby usunąć pozycję „Zamknij pozostałe powyżej” z menu kontekstowego Pliki robocze",
    "DESCRIPTION_CLOSE_OTHERS_BELOW": "użyj wartości „false”, aby usunąć pozycję „Zamknij pozostałe poniżej” z menu kontekstowego Pliki robocze",
    "DESCRIPTION_CLOSE_OTHERS": "użyj wartości „false”, aby usunąć pozycję „Zamknij pozostałe” z menu kontekstowego Pliki robocze",
    "DESCRIPTION_CLOSE_TAGS": "Ustaw opcje zamykania znaczników",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS": "Tablica znaczników, które nie powinny być automatycznie zamykane",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING": "Zamykaj po wpisaniu znaku „>” znacznika otwierającego",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING": "Zamykaj po wpisaniu znaku „/” znacznika zamykającego",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS": "Tablica znaczników, które po otwarciu zawierają pusty wiersz",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD": "użyj wartości „true”, aby zawsze generować znaczniki sekcji zwijanych, gdy zmienia się poziom wcięcia",
    "DESCRIPTION_CODE_FOLDING_ENABLED": "użyj wartości „true”, aby umożliwić zwijanie kodu",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER": "użyj wartości „true”, aby znaczniki zwijania sekcji były widoczne tylko zatrzymaniu myszy nad marginesem",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL": "Ogranicza liczbę poziomów stosowanych przez funkcję Zwiń wszystko",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE": "Minimalna liczba wierszy, po której zostanie wyświetlona ikona sekcji zwijanej",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES": "użyj wartości „true”, aby zwinięte sekcje były zapamiętywane po zamknięciu i ponownym otwarciu pliku lub projektu",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "użyj wartości „true”, aby umożliwić zwijanie kodu w tekście zaznaczonym w edytorze",
    "DESCRIPTION_DISABLED_DEFAULT_EXTENSIONS": "Wyłączone rozszerzenia domyślne",
    "DESCRIPTION_ATTR_HINTS": "Włącz/wyłącz podpowiedzi do atrybutów HTML",
    "DESCRIPTION_CSS_PROP_HINTS": "Włącz/wyłącz podpowiedzi do właściwości CSS/LESS/SCSS",
    "DESCRIPTION_JS_HINTS": "Włącz/wyłącz podpowiedzi do kodu JavaScript",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS": "Włącz/wyłącz szczegóły typu danych w podpowiedziach do kodu JavaScript",
    "DESCRIPTION_PREF_HINTS": "Włącz/wyłącz podpowiedzi do kodu preferencji",
    "DESCRIPTION_SPECIAL_CHAR_HINTS": "Włącz/wyłącz podpowiedzi do encji HTML",
    "DESCRIPTION_SVG_HINTS": "Włącz/wyłącz podpowiedzi do kodu SVG",
    "DESCRIPTION_HTML_TAG_HINTS": "Włącz/wyłącz podpowiedzi do znaczników HTML",
    "DESCRIPTION_URL_CODE_HINTS": "Włącz/wyłącz podpowiedzi do adresów URL w plikach HTML oraz CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT": "Włącz/wyłącz funkcje przeciągania i upuszczania",
    "DESCRIPTION_HEALTH_DATA_TRACKING": "Włącz monitorowanie danych poprawności działania",
    "DESCRIPTION_HIGHLIGHT_MATCHES": "Umożliwia automatyczne wyróżnianie zgodnych łańcuchów w całym dokumencie",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN": "Wyróżniaj wszystkie łańcuchy zgodne z tokenem, w którym znajduje się obecnie kursor (nie trzeba zaznaczać)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY": "Wyróżniaj tylko wtedy, gdy zaznaczenie stanowi kompletny token",
    "DESCRIPTION_INSERT_HINT_ON_TAB": "użyj wartości „true”, aby po naciśnięciu klawisza Tab wstawiać wybraną obecnie podpowiedź do kodu",
    "DESCRIPTION_NO_HINTS_ON_DOT": "użyj wartości „true”, aby nie podpowiedzi do kodu JS nie były automatycznie wyświetlane po wpisaniu znaku . ",
    "DESCRIPTION_JSLINT_OPTIONS": "Obiekt z domyślnymi opcjami JSLint",
    "DESCRIPTION_JSLINT_OPTIONS_ASS": "użyj wartości „true”, aby umożliwić stosowanie wyrażeń przypisania",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE": "użyj wartości „true”, aby umożliwić stosowanie operatorów bitowych",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER": "użyj wartości „true”, jeśli standardowe wartości globalne przeglądarki powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE": "użyj wartości „true”, aby umożliwić stosowanie idiomów Google Closure",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE": "użyj wartości „true”, aby umożliwić stosowanie instrukcji „continue”",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH": "użyj wartości „true”, jeśli wartości globalne CouchDB powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG": "użyj wartości „true”, aby umożliwić stosowanie instrukcji debuggera",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL": "użyj wartości „true”, jeśli wartości globalne przeglądarki przydatne przy programowaniu powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ": "użyj wartości „true”, aby umożliwić stosowanie składni == oraz !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6": "użyj wartości „true”, jeśli wartości globalne ES6 powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL": "użyj wartości „true”, aby umożliwić stosowanie składni eval",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN": "użyj wartości „true”, aby umożliwić niefiltrowane „for ... in”",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT": "Ustaw określoną szerokość tabulatora",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR": "Maksymalna liczba zgłaszanych ostrzeżeń",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN": "Maksymalna liczba znaków w wierszu",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP": "użyj wartości „true”, aby umożliwić stosowanie konstruktorów niezapisanych wielkimi literami",
    "DESCRIPTION_JSLINT_OPTIONS_NODE": "użyj wartości „true”, jeśli wartości globalne Node.js powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN": "użyj wartości „true”, aby zezwalać na wiszące podkreślenie w identyfikatorach",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL": "użyj wartości „true”, aby zatrzymywać na pierwszym błędzie",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS": "użyj wartości „true”, aby umożliwić stosowanie składni ++ oraz --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP": "użyj wartości „true”, aby dopuszczać . oraz [^...]. w wyrażeniach RegExp",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO": "użyj wartości „true”, jeśli wartości globalne Rhino powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY": "użyj wartości „true”, aby zezwalać na brakującą dyrektywę „use strict”",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID": "użyj wartości „true”, jeśli można używać metod blokujących ('...Sync')",
    "DESCRIPTION_JSLINT_OPTIONS_SUB": "użyj wartości „true”, aby zezwalać na subskrypty nieefektywne",
    "DESCRIPTION_JSLINT_OPTIONS_TODO": "użyj wartości „true”, aby umożliwić stosowanie komentarzy TODO",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM": "użyj wartości „true”, aby zezwalać na nieużywane parametry",
    "DESCRIPTION_JSLINT_OPTIONS_VARS": "użyj wartości „true”, aby zezwalać na więcej niż 1 zmienną (var) w funkcji",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE": "użyj wartości „true”, aby ignorować reguły odstępów",
    "DESCRIPTION_LANGUAGE": "Ustawienie specyficzne dla języka",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS": "Dodatkowe odwzorowania między rozszerzeniem pliku a nazwą języka",
    "DESCRIPTION_LANGUAGE_FILE_NAMES": "Dodatkowe odwzorowania między nazwą pliku a nazwą języka",
    "DESCRIPTION_LINEWISE_COPY_CUT": "Kopiowanie lub wycinanie bez zaznaczenia spowoduje skopiowanie lub wycięcie całych wierszy, w których znajdują się kursory",
    "DESCRIPTION_INPUT_STYLE": "Określ sposób wprowadzania treści w usłudze CodeMirror: za pomocą domyślnego pola tekstowego lub za pomocą edytora (contenteditable) — opcja lepsza dla użytkowników czytników ekranowych, ale niestabilna",
    "DESCRIPTION_LINTING_ENABLED": "użyj wartości „true”, aby włączyć inspekcję kodu",
    "DESCRIPTION_ASYNC_TIMEOUT": "Czas w milisekundach, po którym upływa limit czasu linterów asynchronicznych",
    "DESCRIPTION_LINTING_PREFER": "Tablica linterów, które mają być uruchamiane na początku",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER": "użyj wartości „true”, aby włączyć eksperymentalną funkcję Podgląd aktywny",
    "DESCRIPTION_USE_PREFERED_ONLY": "użyj wartości „true”, aby uruchamiać tylko dostawców wskazanych w pliku linting.prefer ",
    "DESCRIPTION_MAX_CODE_HINTS": "Maksymalna liczba wyświetlanych jednocześnie podpowiedzi do kodu",
    "DESCRIPTION_PATH": "Ustawienia specyficzne dla ścieżki",
    "DESCRIPTION_PROXY": "Adres URL serwera proxy używanego do instalacji rozszerzeń",
    "DESCRIPTION_SCROLL_PAST_END": "użyj wartości „true”, aby umożliwić przewijanie poza koniec dokumentu",
    "DESCRIPTION_SHOW_CODE_HINTS": "użyj wartości „false”, aby wyłączyć wszystkie podpowiedzi do kodu",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING": "Utrzymuj widoczność migającego kursora, gdy jest zaznaczony tekst",
    "DESCRIPTION_SHOW_LINE_NUMBERS": "użyj wartości „true”, aby pokazywać numery wierszy w „marginesie” po lewej stronie kodu",
    "DESCRIPTION_SMART_INDENT": "Automatycznie dodawaj wcięcie podczas tworzenia nowego bloku",
    "DESCRIPTION_SOFT_TABS": "użyj wartości „false”, aby wyłączyć zachowanie tabulatorów miękkich",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST": "użyj wartości „true”, aby katalogi były sortowane na początku drzewa projektu",
    "DESCRIPTION_SPACE_UNITS": "Liczba spacji używana we wcięciach spacjami",
    "DESCRIPTION_STATIC_SERVER_PORT": "Numer portu, z którego ma korzystać wbudowany serwer dla funkcji Podgląd aktywny",
    "DESCRIPTION_STYLE_ACTIVE_LINE": "użyj wartości „true”, aby wyróżniać kolor tła w wierszu, w którym znajduje się kursor",
    "DESCRIPTION_TAB_SIZE": "Liczba spacji wyświetlanych dla tabulatorów",
    "DESCRIPTION_USE_TAB_CHAR": "użyj wartości „true”, aby używać tabulatorów zamiast spacji",
    "DESCRIPTION_UPPERCASE_COLORS": "użyj wartości „true”, aby generować wartości heksadecymalne kolorów wielkimi literami w Edytorze kolorów w wierszu",
    "DESCRIPTION_WORD_WRAP": "Zawijaj wiersze, które wykraczają poza szerokość okna",
    "DESCRIPTION_DETECTED_EXCLUSIONS": "Lista plików, dla których stwierdzono nieprawidłowe działanie mechanizmu Tern",
    "DESCRIPTION_INFERENCE_TIMEOUT": "Czas, po jakim mechanizm Tern zgłosi przekroczenie limitu czasu przy próbie interpretacji plików",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR": "użyj wartości „true”, aby pokazywać błędy na pasku stanu",
    "DESCRIPTION_QUICK_VIEW_ENABLED": "użyj wartości „true”, aby włączyć funkcję Przegląd",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW": "użyj wartości „true”, aby wyświetlać podglądy obrazów dla adresów URL z brakującymi rozszerzeniami",
    "DESCRIPTION_THEME": "Wybierz motyw programu {APP_NAME}",
    "DESCRIPTION_USE_THEME_SCROLLBARS": "użyj wartości „true”, aby zezwalać na niestandardowe paski przewijania",
    "DESCRIPTION_LINTING_COLLAPSED": "użyj wartości „true”, aby zwijać panel Linting",
    "DESCRIPTION_FONT_FAMILY": "Zmień rodzinę czcionek",
    "DESCRIPTION_FONT_SIZE": "Zmień rozmiar czcionki, np. 13 px",
    "DESCRIPTION_FIND_IN_FILES_NODE": "użyj wartości „true”, aby włączyć wyszukiwanie oparte na węzłach",
    "DESCRIPTION_FIND_IN_FILES_INSTANT": "użyj wartości „true”, aby włączyć wyszukiwanie bezpośrednie",
    "DESCRIPTION_FONT_SMOOTHING": "Tylko Mac: użyj wartości „subpixel-antialiased”, aby włączyć wygładzanie subpikselowe, albo wartości „antialiased”, aby użyć wygłaszania w skali szarości",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW": "użyj wartości „false”, aby wyłączyć otwieranie pliku preferencji w widoku podzielonym",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE": "użyj wartości „false”, aby otwierać plik preferencji użytkownika w okienku po lewej / na górze",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED": "użyj wartości „true”, aby zwijać panele po zamknięciu ostatniego pliku z danego panelu za pomocą przycisku zamykania w nagłówku tego panelu",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS": "Przełącz pokazywanie przycisków zamykania i przewracania w nagłówku",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT": "/*\n * Jest to plik tylko do odczytu zawierający preferencje\n * obsługiwane przez program {APP_NAME}.\n * Skorzystaj z tego pliku, aby zmodyfikować\n * własny plik preferencji „brackets.json”, otwarty w drugim okienku.\n * Więcej informacji na \n * temat korzystania z preferencji w programie {APP_NAME}: https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT": "Domyślny",
    "DESCRIPTION_PURE_CODING_SURFACE": "użyj wartości „true”, aby włączyć tryb samego kodu i ukryć wszystkie inne elementy interfejsu w programie {APP_NAME}",
    "DESCRIPTION_INDENT_LINE_COMMENT": "użyj wartości „true”, aby włączyć wcięcia dla komentarzy w wierszach",
    "DESCRIPTION_RECENT_FILES_NAV": "Włącz/wyłącz nawigację w ostatnich plikach",
    "DESCRIPTION_LIVEDEV_WEBSOCKET_PORT": "Port, na którym WebSocket Server obsługuje podgląd na żywo",
    "DESCRIPTION_LIVE_DEV_HIGHLIGHT_SETTINGS": "Ustawienia podświetlania w podglądzie na żywo",
    "DESCRIPTION_LIVEDEV_ENABLE_REVERSE_INSPECT": "„false” wyłącza inspekcję zwrotną podglądu na żywo",
    "DESCRIPTION_PHP_HINTS": "Włącz/wyłącz podpowiedzi do kodu PHP",
    "BROWSE_COMMAND_STRING": " Przeglądaj...",

    "COLOR_PICKER_CMD_STRING": " Próbnik kolorów...",
    "CHOOSE_ANOTHER_CC_LIBARAY": "Zmień bibliotekę",
    "EXTRACT_INSERT_SELECTED": " Wstaw wybrane",
    "DESCRIPTION_EMMET_PREFS": "Włącz/Wyłącz obsługę Emmet",
    "IMAGE_NOT_FOUND_ERR": "Nie znaleziono obrazu"
});
