/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR": "(chyba {0})",
    "NOT_FOUND_ERR": "Soubor nenalezen.",
    "NOT_READABLE_ERR": "Soubor nelze číst.",
    "EXCEEDS_MAX_FILE_SIZE": "Soubor větší než {0} MB nemůže být otevřen v aplikaci {APP_NAME}.",
    "NO_MODIFICATION_ALLOWED_ERR": "Cílová složka nemůže být změněna.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE": "Oprávnění neumožní provádět změny.",
    "CONTENTS_MODIFIED_ERR": "Soubor byl změněn mimo aplikaci {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR": "Neznámý formát kódování",
    "ENCODE_FILE_FAILED_ERR": "Aplikace {APP_NAME} nedokázala zakódovat obsah souboru.",
    "DECODE_FILE_FAILED_ERR": "Aplikace {APP_NAME} nedokázala dekódovat obsah souboru.",
    "UNSUPPORTED_UTF16_ENCODING_ERR": "Aplikace {APP_NAME} v tuto chvíli nepodporuje textové soubory kódované pomocí UTF-16.",
    "FILE_EXISTS_ERR": "Soubor již existuje.",
    "FILE": "souboru",
    "FILE_TITLE": "Soubor",
    "DIRECTORY": "složky",
    "DIRECTORY_TITLE": "Složka",
    "DIRECTORY_NAMES_LEDE": "Názvy složek",
    "FILENAMES_LEDE": "Názvy souborů",
    "FILENAME": "Název souboru",
    "DIRECTORY_NAME": "název složky",

    // Project error strings
    "ERROR_LOADING_PROJECT": "Chyba při otevírání projektu",
    "OPEN_DIALOG_ERROR": "Došlo k chybě při zobrazování dialogu Otevřít soubor. (chyba {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR": "Došlo k chybě při načítání adresáře <span class='dialog-filename'>{0}</span>. (chyba {1})",
    "READ_DIRECTORY_ENTRIES_ERROR": "Došlo k chybě při načítání obsahu složky <span class='dialog-filename'>{0}</span>. (chyba {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE": "Chyba při otevírání souboru",
    "ERROR_OPENING_FILE": "Došlo k chybě při otevírání souboru <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES": "Došlo k chybě při otevírání následujících souborů:",
    "ERROR_RELOADING_FILE_TITLE": "Chyba při načítání změn z disku",
    "ERROR_RELOADING_FILE": "Došlo k chybě při načítání souboru <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE": "Chyba při ukládání souboru",
    "ERROR_SAVING_FILE": "Došlo k chybě při ukládání souboru <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE": "Chyba při přejmenování {0}",
    "ERROR_RENAMING_FILE": "Došlo k chybě při přejmenování {2} <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT": "Soubor nebo složka není součástí aktuálně otevřeného projektu. V současné době je bohužel možné přejmenovat pouze projektové soubory.",
    "ERROR_DELETING_FILE_TITLE": "Chyba při mazání {0}",
    "ERROR_DELETING_FILE": "Došlo k chybě při mazání {2} <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE": "Špatný {0}",
    "INVALID_FILENAME_MESSAGE": "{0} nemohou obsahovat rezervovaná slova, končit tečkami (.) nebo obsahovat znaky: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS": "Soubor nebo složka se jménem <span class='dialog-filename'>{0}</span> již existuje.",
    "ERROR_CREATING_FILE_TITLE": "Chyba při vytváření {0}",
    "ERROR_CREATING_FILE": "Došlo k chybě při vytváření {0} <span class='dialog-filename'>{1}</span>. {2}",
    "ERROR_MIXED_DRAGDROP": "Nelze otevřít složku ve chvíli, kdy se otevírají jiné soubory.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE": "Chyba při čtení uživatelských klávesových zkratek",
    "ERROR_KEYMAP_CORRUPT": "Soubor s nastavením klávesových zkratek není platný soubor typu JSON. Soubor bude otevřen, abyste mohli opravit formát.",
    "ERROR_LOADING_KEYMAP": "Váš soubor s klávesovými zkratkami není platný UTF-8 soubor a nemůže být otevřen",
    "ERROR_RESTRICTED_COMMANDS": "Nemůžete změnit klávesové zkratky následujícím příkazům: {0}",
    "ERROR_RESTRICTED_SHORTCUTS": "Nemůžete změnit tyto klávesové zkratky: {0}",
    "ERROR_MULTIPLE_SHORTCUTS": "Vytváříte více klávesových zkratek pro tyto příkazy: {0}",
    "ERROR_DUPLICATE_SHORTCUTS": "Tyto příkazy mají stejnou klávesovou zkratku: {0}",
    "ERROR_INVALID_SHORTCUTS": "Tyto klávesové zkratky jsou neplatné: {0}",
    "ERROR_NONEXISTENT_COMMANDS": "Vytváříte klávesovou zkratku pro neexistující příkaz: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE": "Chyba při čtení nastavení",
    "ERROR_PREFS_CORRUPT": "Soubor s nastavením není platný soubor typu JSON. Soubor bude otevřen, abyste mohli opravit formát. Pro uložení změn budete muset restartovat aplikaci {APP_NAME}.",
    "ERROR_PROJ_PREFS_CORRUPT": "Soubor s preferencemi vašeho projektu neodpovídá validnímu JSON formátu. Tento soubor bude otevřen, abyste mohl formát opravit. K provedení změn bude nutné znovu načíst projekt.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE": "Ouha! {APP_NAME} ještě neběží v prohlížeči.",
    "ERROR_IN_BROWSER": "{APP_NAME} je vytvořen v HTML, ale nyní pracuje jako desktopová aplikace, takže ji můžete použít pro úpravu lokálních souborů. Prosím, použijte shell aplikace v repozitáři <b>github.com/adobe/brackets-shell</b> pro spuštění {APP_NAME}.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE": "Chyba při indexování souborů",
    "ERROR_MAX_FILES": "Tento projekt obsahuje více než 30.000 souborů. Funkce zpracovávající více souborů mohou být zablokované nebo se mohou chovat jako kdyby byl projekt prázdný. <a href='https://github.com/adobe/brackets/wiki/Large-Projects'>Čtěte více o práci s obřími projekty</a>.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE": "Chyba při spouštění prohlížeče",
    "ERROR_CANT_FIND_CHROME": "Prohlížeč Google Chrome nebyl nalezen. Přesvědčte se, že je nainstalován",
    "ERROR_LAUNCHING_BROWSER": "Došlo k chybě při spouštění prohlížeče. (chyba {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE": "Živý náhled - chyba",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE": "Připojování k prohlížeči",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE": "Aby se mohl živý náhled připojit, je třeba restartovat Chrome s povolenou možností vzdálené ladění.<br /><br />Chcete restartovat Chrome a povolit vzdálené ladění?<br /><br />",
    "LIVE_DEV_LOADING_ERROR_MESSAGE": "Nelze načíst stránku s živým náhledem",
    "LIVE_DEV_NEED_HTML_MESSAGE": "Otevřete HTML soubor pro zobrazení v živém náhledu.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE": "Pro spuštění živého náhledu se vzdáleným souborem, musíte specifikovat URL pro tento projekt.",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE": "Chyba při spouštění HTTP serveru pro soubory živého náhledu. Prosím, zkuste to znovu.",
    "LIVE_DEVELOPMENT_INFO_TITLE": "Vítejte v živém náhledu!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE": "Živý náhled připojí {APP_NAME} k vašemu prohlížeči. Spustí náhled HTML souboru, který se aktualizuje pokaždé, kdy editujete svůj kód.<br /><br />V této verzi {APP_NAME}, živý náhled funguje pouze v <strong>Google Chrome</strong> a aktualizuje změny v <strong>CSS souborech</strong>. Změny v HTML nebo JavaScript souborech jsou automaticky načteny, když soubor uložíte.<br /><br />(Tato zpráva se zobrazí pouze jednou.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING": "Pro více informací navštivte stránku <a href='{0}' title='{0}'>řešení problémů s připojením v Živém náhledu</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED": "Živý náhled",
    "LIVE_DEV_STATUS_TIP_PROGRESS1": "Živý náhled: Připojování\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2": "Živý náhled: Spouštění\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED": "Zrušit živý náhled",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC": "Živý náhled (uložte soubor k obnovení)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR": "Živý náhled (neaktualizováno kvůli chybě v syntaxi)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS": "Živý náhled byl zrušen, protože byly otevřeny vývojářské nástroje prohlížeče",
    "LIVE_DEV_DETACHED_TARGET_CLOSED": "Živý náhled byl zrušen, protože dokument byl zavřen v prohlížeči",
    "LIVE_DEV_NAVIGATED_AWAY": "Živý náhled byl zrušen, protože prohlížeč přešel na stránku, která není součástí projektu",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON": "Živý náhled byl zrušen z neznámého důvodu ({0})",

    "SAVE_CLOSE_TITLE": "Uložit změny",
    "SAVE_CLOSE_MESSAGE": "Chcete uložit změny v souboru <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE": "Chcete uložit změny v následujících souborech?",
    "EXT_MODIFIED_TITLE": "Externí změny",
    "CONFIRM_DELETE_TITLE": "Potvrdit smazání",
    "CONFIRM_FILE_DELETE": "Opravdu chcete odstranit soubor <span class='dialog-filename'>{0}</span>?",
    "CONFIRM_FOLDER_DELETE": "Opravdu chcete smazat složku <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE": "Soubor smazán",
    "EXT_MODIFIED_WARNING": "<span class='dialog-filename'>{0}</span> byl změněn mimo {APP_NAME}.<br /><br />Chcete uložit soubor a přepsat tyto změny?",
    "EXT_MODIFIED_MESSAGE": "<span class='dialog-filename'>{0}</span> byl změněn mimo {APP_NAME}, ale existují také neuložené změny v {APP_NAME}.<br /><br />Kterou verzi chcete zachovat?",
    "EXT_DELETED_MESSAGE": "<span class='dialog-filename'>{0}</span> byl smazán mimo {APP_NAME}, ale existují neuložené změny v {APP_NAME}.<br /><br />Chcete vaše změny zachovat?",
    
    // Window unload warning messages
    "WINDOW_UNLOAD_WARNING": "Opravdu chcete přejít na jinou adresu URL a opustit službu Brackets?",
    "WINDOW_UNLOAD_WARNING_WITH_UNSAVED_CHANGES": "Byly zjištěny neuložené změny. Opravdu chcete přejít na jinou adresu URL a opustit službu Brackets?",

    // Generic dialog/button labels
    "DONE": "Hotovo",
    "OK": "OK",
    "CANCEL": "Zrušit",
    "DONT_SAVE": "Neukládat",
    "SAVE": "Uložit",
    "SAVE_AS": "Uložit jako\u2026",
    "SAVE_AND_OVERWRITE": "Přepsat",
    "DELETE": "Odstranit",
    "BUTTON_YES": "Ano",
    "BUTTON_NO": "Ne",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX": "{0} z {1}",
    "FIND_NO_RESULTS": "Žádné výsledky",
    "FIND_QUERY_PLACEHOLDER": "Najít\u2026",
    "FIND_HISTORY_MAX_COUNT": "Maximální počet hledaných položek v historii vyhledávání",
    "REPLACE_PLACEHOLDER": "Nahradit s\u2026",
    "BUTTON_REPLACE_ALL": "Nahradit vše",
    "BUTTON_REPLACE_BATCH": "Vše\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES": "Nahradit\u2026",
    "BUTTON_REPLACE": "Nahradit",
    "BUTTON_NEXT": "\u25B6",
    "BUTTON_PREV": "\u25C0",
    "BUTTON_NEXT_HINT": "Další shoda",
    "BUTTON_PREV_HINT": "Předchozí shoda",
    "BUTTON_CASESENSITIVE_HINT": "Rozlišovat malá a VELKÁ",
    "BUTTON_REGEXP_HINT": "Regulární výraz",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Nahradit bez možnosti vrátit změny",
    "REPLACE_WITHOUT_UNDO_WARNING": "Protože musí být změněno více než {0} souborů, {APP_NAME} změní neotevřené soubory na disku.<br />Nebude možné vrátit změny v těchto souborech.",
    "BUTTON_REPLACE_WITHOUT_UNDO": "Nahradit bez možnosti vrátit změny",

    "OPEN_FILE": "Otevřít soubor",
    "SAVE_FILE_AS": "Uložit soubor",
    "CHOOSE_FOLDER": "Vyberte složku",

    "RELEASE_NOTES": "Poznámky k verzi",
    "NO_UPDATE_TITLE": "Vše je aktuální!",
    "NO_UPDATE_MESSAGE": "Verze {APP_NAME} je aktuální.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL": "Nahradit",
    "FIND_REPLACE_TITLE_WITH": "pomocí",
    "FIND_TITLE_LABEL": "Nalezeno",
    "FIND_TITLE_SUMMARY": "&mdash; {0} {1} {2} v {3}",

    // Find in Files
    "FIND_NUM_FILES": "{0} {1}",
    "FIND_IN_FILES_SCOPED": "v <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE": "v projektu",
    "FIND_IN_FILES_ZERO_FILES": "Filtr vyloučil všechny soubory {0}",
    "FIND_IN_FILES_FILE": "souboru",
    "FIND_IN_FILES_FILES": "souborů",
    "FIND_IN_FILES_MATCH": "výsledek",
    "FIND_IN_FILES_MATCHES": "výsledků",
    "FIND_IN_FILES_MORE_THAN": "více než ",
    "FIND_IN_FILES_PAGING": "{0} – {1}",
    "FIND_IN_FILES_FILE_PATH": "Soubor <span class='dialog-filename'>{0}</span> ve složce <span class='dialog-path'>{1}</span>",
    "FIND_IN_FILES_EXPAND_COLLAPSE": "Ctrl/Cmd klik pro rozbalení/sbalení všeho",
    "FIND_IN_FILES_INDEXING": "Indexování pro okamžité vyhledávání\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE": "Nahradit chyby",
    "REPLACE_IN_FILES_ERRORS": "Následující soubory nebyly změněny, protože se změnily po hledání nebo do nich nelze zapisovat.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE": "Chyba při získávání informací o aktualizaci",
    "ERROR_FETCHING_UPDATE_INFO_MSG": "Nelze získat aktualizace. Ujistěte se, že máte připojení k internetu a zkuste to znovu.",

    // File exclusion filters
    "NEW_FILE_FILTER": "Nová řada vyloučených souborů\u2026",
    "CLEAR_FILE_FILTER": "Nevylučovat soubory",
    "NO_FILE_FILTER": "Vyloučit soubory\u2026",
    "EXCLUDE_FILE_FILTER": "Vyloučit {0}",
    "EDIT_FILE_FILTER": "Upravit\u2026",
    "FILE_FILTER_DIALOG": "Upravit filtr",
    "FILE_FILTER_INSTRUCTIONS": "Vyloučit soubory a složky, které obsahují jakýkoliv z následujících řetězců / podřetězců nebo <a href='{0}' title='{0}'>vzorků</a>. Vložte každý řetězec na nový řádek.",
    "FILTER_NAME_PLACEHOLDER": "Pojmenujte řadu vyloučených souborů (nepovinné)",
    "FILTER_NAME_REMAINING": "Zbývající znaky: {0}",
    "FILE_FILTER_CLIPPED_SUFFIX": "a {0} více",
    "FILTER_COUNTING_FILES": "Počítání souborů\u2026",
    "FILTER_FILE_COUNT": "Povolit {0} z {1} souborů {2}",
    "FILTER_FILE_COUNT_ALL": "Povolit všechny {0} soubory {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND": "Rychlá úprava není dostupná pro aktuální pozici kurzoru",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES": "Rychlá úprava CSS: umístěte kurzor do jména třídy",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND": "Rychlá úprava CSS: nekompletní class atribut",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND": "Rychlá úprava CSS: nekompletní id atribut",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR": "Rychlá úprava CSS: umístěte kurzor do elementu, třídy nebo id",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX": "Rychlá úprava CSS časování: neplatná syntaxe",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND": "Rychlá úprava JS: umístěte kurzor do jména funkce",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND": "Rychlá dokumentace není dostupná pro aktuální pozici kurzoru",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING": "Načítání\u2026",
    "UNTITLED": "Nový",
    "WORKING_FILES": "Pracovní soubory",

    /**
     * MainViewManager
     */
    "TOP": "Nahoře",
    "BOTTOM": "Dole",
    "LEFT": "Vlevo",
    "RIGHT": "Vpravo",

    "CMD_SPLITVIEW_NONE": "Bez rozdělení",
    "CMD_SPLITVIEW_VERTICAL": "Vertikální rozdělení",
    "CMD_SPLITVIEW_HORIZONTAL": "Horizontální rozdělení",
    "SPLITVIEW_MENU_TOOLTIP": "Rozdělit editor horizontálně nebo vertikálně",
    "GEAR_MENU_TOOLTIP": "Nastavit pracovní plochu",

    "SPLITVIEW_INFO_TITLE": "Již otevřen",
    "SPLITVIEW_MULTIPANE_WARNING": "Soubor je již otevřen v jiném okně. {APP_NAME} bude brzy podporovat otevírání stejného souboru ve více oknech. Do té doby bude soubor zobrazen v již otevřeném okně.<br /><br />(Tuto zprávu uvidíte pouze jednou.)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL": "Ctrl",
    "KEYBOARD_SHIFT": "Shift",
    "KEYBOARD_SPACE": "Mezerník",
    "KEYBOARD_PAGE_UP": "PageUp",
    "KEYBOARD_PAGE_DOWN": "PageDown",
    "KEYBOARD_HOME": "Domovská stránka",
    "KEYBOARD_END": "End",
    "KEYBOARD_INSERT": "Vložit",
    "KEYBOARD_DELETE": "Odstranit",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION": "Řádek {0}, Sloupec {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR": " \u2014 Vybrán {0} sloupec",
    "STATUSBAR_SELECTION_CH_PLURAL": " \u2014 Vybrány {0} sloupce",
    "STATUSBAR_SELECTION_LINE_SINGULAR": " \u2014 Vybrán {0} řádek",
    "STATUSBAR_SELECTION_LINE_PLURAL": " \u2014 Vybrány {0} řádky",
    "STATUSBAR_SELECTION_MULTIPLE": " \u2014 {0} Vybráno",
    "STATUSBAR_INDENT_TOOLTIP_SPACES": "Přepnout odsazení na mezery",
    "STATUSBAR_INDENT_TOOLTIP_TABS": "Přepnout odsazení na tabulátory",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES": "Změnit počet mezer použitých pro odsazení",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS": "Změnit šířku tabulátoru",
    "STATUSBAR_SPACES": "Mezery:",
    "STATUSBAR_TAB_SIZE": "Velikost tabulátoru:",
    "STATUSBAR_LINE_COUNT_SINGULAR": "Řádek: {0}",
    "STATUSBAR_LINE_COUNT_PLURAL": "Řádky: {0}",
    "STATUSBAR_USER_EXTENSIONS_DISABLED": "Doplňky zakázány",
    "STATUSBAR_INSERT": "INS",
    "STATUSBAR_OVERWRITE": "PŘES",
    "STATUSBAR_INSOVR_TOOLTIP": "Klikněte pro přepnutí kurzoru mezi módem Insert (INS) a Overwrite (OVR)",
    "STATUSBAR_LANG_TOOLTIP": "Klikněte pro změnu typu souboru",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP": "{0}. Klikněte pro zapnutí panelu zpráv.",
    "STATUSBAR_DEFAULT_LANG": "(výchozí)",
    "STATUSBAR_SET_DEFAULT_LANG": "Nastavit jako výchozí pro .{0} soubory",
    "STATUSBAR_ENCODING_TOOLTIP": "Vyberte kódování",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE": "{0} chyb",
    "SINGLE_ERROR": "1 {0} chyba",
    "MULTIPLE_ERRORS": "{1} {0} chyby",
    "NO_ERRORS": "Žádné {0} chyby - dobrá práce!",
    "NO_ERRORS_MULTIPLE_PROVIDER": "Žádné chyby nenalezeny - dobrá práce!",
    "LINT_DISABLED": "Lintování je vypnuto",
    "NO_LINT_AVAILABLE": "Žádný linter není dostupný pro {0}",
    "NOTHING_TO_LINT": "Nic k lintování",
    "LINTER_TIMED_OUT": "{0} - vypršel časový limit po uplynutí {1} ms",
    "LINTER_FAILED": "{0} byl(a) ukončen(a) s chybou: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU": "Soubor",
    "CMD_FILE_NEW_UNTITLED": "Nový",
    "CMD_FILE_NEW": "Nový soubor",
    "CMD_FILE_NEW_FOLDER": "Nová složka",
    "CMD_FILE_OPEN": "Otevřít\u2026",
    "CMD_RECENT_FILES_OPEN": "Otevřít poslední...",
    "CMD_ADD_TO_WORKING_SET": "Přidat k pracovní sadě",
    "CMD_OPEN_DROPPED_FILES": "Otevřít opuštěné soubory",
    "CMD_OPEN_FOLDER": "Otevřít složku\u2026",
    "CMD_FILE_CLOSE": "Zavřít",
    "CMD_FILE_CLOSE_ALL": "Zavřít vše",
    "CMD_FILE_CLOSE_LIST": "Zavřít seznam",
    "CMD_FILE_CLOSE_OTHERS": "Zavřít ostatní",
    "CMD_FILE_CLOSE_ABOVE": "Zavřít ostatní výše",
    "CMD_FILE_CLOSE_BELOW": "Zavřít ostatní níže",
    "CMD_FILE_SAVE": "Uložit",
    "CMD_FILE_SAVE_ALL": "Uložit vše",
    "CMD_FILE_SAVE_AS": "Uložit jako\u2026",
    "CMD_LIVE_FILE_PREVIEW": "Živý náhled",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE": "Experimentální živý náhled",
    "CMD_RELOAD_LIVE_PREVIEW": "Vynutit obnovení živého náhledu",
    "CMD_PROJECT_SETTINGS": "Nastavení projektu\u2026",
    "CMD_FILE_RENAME": "Přejmenovat",
    "CMD_FILE_DELETE": "Odstranit",
    "CMD_INSTALL_EXTENSION": "Instalovat doplňky\u2026",
    "CMD_EXTENSION_MANAGER": "Správce doplňků\u2026",
    "CMD_FILE_REFRESH": "Obnovit",
    "CMD_QUIT": "Konec",
    // Used in native File menu on Windows
    "CMD_EXIT": "Konec",

    // Edit menu commands
    "EDIT_MENU": "Upravit",
    "CMD_UNDO": "Zpět",
    "CMD_REDO": "Znovu",
    "CMD_CUT": "Vyjmout",
    "CMD_COPY": "Kopírovat",
    "CMD_PASTE": "Vložit",
    "CMD_SELECT_ALL": "Vybrat vše",
    "CMD_SELECT_LINE": "Vybrat řádek",
    "CMD_SPLIT_SEL_INTO_LINES": "Rozdělit výběr na řádky",
    "CMD_ADD_CUR_TO_NEXT_LINE": "Přidat kurzor na další řádek",
    "CMD_ADD_CUR_TO_PREV_LINE": "Přidat kurzor na předcházející řádek",
    "CMD_INDENT": "Odsadit",
    "CMD_UNINDENT": "Vrátit odsazení",
    "CMD_DUPLICATE": "Duplikovat",
    "CMD_DELETE_LINES": "Smazat řádek",
    "CMD_COMMENT": "Komentář na řádku",
    "CMD_BLOCK_COMMENT": "Komentář v bloku",
    "CMD_LINE_UP": "Posunout řádek nahoru",
    "CMD_LINE_DOWN": "Posunout řádek dolů",
    "CMD_OPEN_LINE_ABOVE": "O řádek výše",
    "CMD_OPEN_LINE_BELOW": "O řádek níže",
    "CMD_TOGGLE_CLOSE_BRACKETS": "Uzavírat závorky",
    "CMD_SHOW_CODE_HINTS": "Zobrazit nápovědy kódu",

    // Search menu commands
    "FIND_MENU": "Hledat",
    "CMD_FIND": "Hledat",
    "CMD_FIND_NEXT": "Hledat další",
    "CMD_FIND_PREVIOUS": "Najít předchozí",
    "CMD_FIND_ALL_AND_SELECT": "Najít vše a vybrat",
    "CMD_ADD_NEXT_MATCH": "Přidat další shodu do výběru",
    "CMD_SKIP_CURRENT_MATCH": "Přeskočit a přidat další shodu do výběru",
    "CMD_FIND_IN_FILES": "Najít v souborech",
    "CMD_FIND_IN_SUBTREE": "Najít v\u2026",
    "CMD_REPLACE": "Nahradit",
    "CMD_REPLACE_IN_FILES": "Nahradit v souborech",
    "CMD_REPLACE_IN_SUBTREE": "Nahradit v\u2026",

    // View menu commands
    "VIEW_MENU": "Zobrazit",
    "CMD_HIDE_SIDEBAR": "Skrýt boční menu",
    "CMD_SHOW_SIDEBAR": "Zobrazit boční menu",
    "CMD_TOGGLE_SIDEBAR": "Zobrazit/skrýt boční menu",
    "CMD_TOGGLE_PANELS": "Zobrazit/skrýt panely",
    "CMD_TOGGLE_PURE_CODE": "Žádné rozptylování",
    "CMD_INCREASE_FONT_SIZE": "Zvětšit velikost písma",
    "CMD_DECREASE_FONT_SIZE": "Zmenšit velikost písma",
    "CMD_RESTORE_FONT_SIZE": "Obnovit velikost písma",
    "CMD_SCROLL_LINE_UP": "Posunout o řádek nahoru",
    "CMD_SCROLL_LINE_DOWN": "Posunout o řádek dolů",
    "CMD_TOGGLE_LINE_NUMBERS": "Čísla řádků",
    "CMD_TOGGLE_ACTIVE_LINE": "Zvýraznit aktivní řádek",
    "CMD_TOGGLE_WORD_WRAP": "Zalamování řádků",
    "CMD_LIVE_HIGHLIGHT": "Živé zvýraznění",
    "CMD_VIEW_TOGGLE_INSPECTION": "Lintovat soubory při uložení",
    "CMD_WORKINGSET_SORT_BY_ADDED": "Řadit podle data přidání",
    "CMD_WORKINGSET_SORT_BY_NAME": "Řadit podle jména",
    "CMD_WORKINGSET_SORT_BY_TYPE": "Řadit podle typu",
    "CMD_WORKING_SORT_TOGGLE_AUTO": "Automatické řazení",
    "CMD_THEMES": "Motivy\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU": "Navigace",
    "CMD_QUICK_OPEN": "Rychle otevřít",
    "CMD_GOTO_LINE": "Jít na řádek",
    "CMD_GOTO_DEFINITION": "Přejít na definici",
    "CMD_GOTO_FIRST_PROBLEM": "Přejít na první chybu/varování",
    "CMD_TOGGLE_QUICK_EDIT": "Rychlá úprava",
    "CMD_TOGGLE_QUICK_DOCS": "Rychlé dokumenty",
    "CMD_QUICK_EDIT_PREV_MATCH": "Předchozí shoda",
    "CMD_QUICK_EDIT_NEXT_MATCH": "Další shoda",
    "CMD_CSS_QUICK_EDIT_NEW_RULE": "Nové pravidlo",
    "CMD_NEXT_DOC": "Následující dokument",
    "CMD_PREV_DOC": "Předcházející dokument",
    "CMD_NAVIGATE_BACKWARD": "Přejít zpět",
    "CMD_NAVIGATE_FORWARD": "Přejít vpřed",
    "CMD_NEXT_DOC_LIST_ORDER": "Další dokument v seznamu",
    "CMD_PREV_DOC_LIST_ORDER": "Předchozí dokument v seznamu",
    "CMD_SHOW_IN_TREE": "Zobrazit stromovou strukturu",
    "CMD_SHOW_IN_EXPLORER": "Zobrazit v průzkumníkovi",
    "CMD_SHOW_IN_FINDER": "Zobrazit ve vyhledávači",
    "CMD_SHOW_IN_OS": "Zobrazit v OS",
    "CMD_SWITCH_PANE_FOCUS": "Přepnutí aktivního podokna",

    // Help menu commands
    "HELP_MENU": "Nápověda",
    "CMD_CHECK_FOR_UPDATE": "Zkontrolovat aktualizace",
    "CMD_HOW_TO_USE_BRACKETS": "Jak používat {APP_NAME}",
    "CMD_SUPPORT": "{APP_NAME} Podpora",
    "CMD_SUGGEST": "Navrhněte funkci",
    "CMD_RELEASE_NOTES": "Poznámky k verzi",
    "CMD_GET_INVOLVED": "Zapojte se",
    "CMD_SHOW_EXTENSIONS_FOLDER": "Zobrazit složku s doplňky",
    "CMD_HEALTH_DATA_STATISTICS": "Hlášení o zdraví",
    "CMD_HOMEPAGE": "Domovská stránka {APP_TITLE}",
    "CMD_TWITTER": "{TWITTER_NAME} na Twitteru",
    "CMD_ABOUT": "O aplikaci {APP_TITLE}",
    "CMD_OPEN_PREFERENCES": "Otevřít soubor s preferencemi",
    "CMD_OPEN_KEYMAP": "Otevřít uživatelské klávesové zkratky",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD": "experimentální sestavení",
    "RELEASE_BUILD": "sestavení",
    "DEVELOPMENT_BUILD": "vývojové sestavení",
    "RELOAD_FROM_DISK": "Načíst z disku",
    "KEEP_CHANGES_IN_EDITOR": "Ponechat změny v editoru",
    "CLOSE_DONT_SAVE": "Zavřít (neukládat)",
    "RELAUNCH_CHROME": "Restartovat Chrome",
    "ABOUT": "Co je",
    "CLOSE": "Zavřít",
    "ABOUT_TEXT_LINE1": "Vydání {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP": "vytvořeno: ",
    "ABOUT_TEXT_LINE3": "Oznámení, podmínky týkající se software třetích stran jsou umístěny na stránce <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> a začleněny prostřednictvím odkazu zde.",
    "ABOUT_TEXT_LINE4": "Dokumentace a zdrojový kód na stránce <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>.",
    "ABOUT_TEXT_LINE5": "Vytvořeno s \u2764 a pomocí JavaScriptu těmito lidmi:",
    "ABOUT_TEXT_LINE6": "Mnoho lidí (ale momentálně máme problém s načítáním dat).",
    "ABOUT_TEXT_MDN_DOCS": "MDN Docs a logo MDN využívají licenci Creative Commons Uveďte původ, <a href='{MDN_DOCS_LICENSE}'>CC-BY-SA 2.5 Unported</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP": "Je dostupná nová verze {APP_NAME}! Klikněte zde pro více informací.",
    "UPDATE_AVAILABLE_TITLE": "Dostupná aktualizace",
    "UPDATE_MESSAGE": "Nová verze {APP_NAME} je dostupná. Seznam některých vylepšení:",
    "GET_IT_NOW": "Stáhnout!",
    "PROJECT_SETTINGS_TITLE": "Nastavení projektu: {0}",
    "PROJECT_SETTING_BASE_URL": "URL Živého náhledu",
    "PROJECT_SETTING_BASE_URL_HINT": "(nechte prázdné pro URL souboru)",
    "BASEURL_ERROR_INVALID_PROTOCOL": "{0} protokol není podporován živým náhledem &mdash; prosím, použijte http: nebo https: .",
    "BASEURL_ERROR_SEARCH_DISALLOWED": "URL nemůže obsahovat výrazy pro hledání jako \"{0}\".",
    "BASEURL_ERROR_HASH_DISALLOWED": "URL nemůže obsahovat znaky jako \"{0}\".",
    "BASEURL_ERROR_INVALID_CHAR": "Zvláštní znaky jako '{0}' musí být zakódovány %.",
    "BASEURL_ERROR_UNKNOWN_ERROR": "Neznámá chyba při zpracování URL",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER": "<em>Otevřete soubor, zatímco tento panel je aktivní</em>",
    "FLIPVIEW_BTN_TOOLTIP": "Přepnout toto zobrazení na panel {0}",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME": "Aktuální motiv",
    "USE_THEME_SCROLLBARS": "Použít posuvníky motivu",
    "FONT_SIZE": "Velikost písma",
    "FONT_FAMILY": "Rodina písma",
    "THEMES_SETTINGS": "Nastavení motivů",

    // CSS Quick Edit
    "BUTTON_NEW_RULE": "Nové pravidlo",

    // Extension Management strings
    "INSTALL": "Instalovat",
    "UPDATE": "Aktualizovat",
    "REMOVE": "Odstranit",
    "DISABLE": "Zakázat",
    "ENABLE": "Povolit",
    "OVERWRITE": "Přepsat",
    "CANT_REMOVE_DEV": "Doplněk ve složce \"dev\" musí být smazán manuálně.",
    "CANT_UPDATE": "Aktualizace není kompatibilní s touto verzí {APP_NAME}.",
    "CANT_UPDATE_DEV": "Doplňky ve složce \"dev\" nemohou být aktualizovány automaticky.",
    "INSTALL_EXTENSION_TITLE": "Instalovat doplněk",
    "UPDATE_EXTENSION_TITLE": "Aktualizovat doplněk",
    "INSTALL_EXTENSION_LABEL": "URL adresa doplňku",
    "INSTALL_EXTENSION_HINT": "URL adresa zip archivu nebo GitHub repozitáře",
    "INSTALLING_FROM": "Instalace doplňku z {0}\u2026",
    "INSTALL_SUCCEEDED": "Instalace byla úspěšná!",
    "INSTALL_FAILED": "Instalace se nezdařila.",
    "CANCELING_INSTALL": "Rušení instalace\u2026",
    "CANCELING_HUNG": "Rušení instalace trvá dlouho. Mohlo dojít k interní chybě.",
    "INSTALL_CANCELED": "Instalace zrušena.",
    "VIEW_COMPLETE_DESCRIPTION": "Zobrazit úplný popis",
    "VIEW_TRUNCATED_DESCRIPTION": "Zobrazit zkrácený popis",
    "SORT_EXTENSION_METHOD": "Seřadit rozšíření podle atributu downloadCount nebo publishedDate",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE": "Stažený soubor není platný zip soubor.",
    "MISSING_PACKAGE_JSON": "Balíček neobsahuje žádný soubor JSON.",
    "INVALID_PACKAGE_JSON": "Package.json balíček není platný (chyba byla: {0}).",
    "MISSING_PACKAGE_NAME": "Package.json balíček nespecifikuje jméno souboru.",
    "BAD_PACKAGE_NAME": "{0} je neplatné jméno balíčku.",
    "MISSING_PACKAGE_VERSION": "Package.json balíček nespecifikuje verzi souboru.",
    "INVALID_VERSION_NUMBER": "Balíček verze ({0}) je neplatný.",
    "INVALID_BRACKETS_VERSION": "Řetězec kompatibility {0} pro {APP_NAME} je neplatný.",
    "DISALLOWED_WORDS": "Slova {1} nejsou povolena v {0} poli.",
    "NPM_INSTALL_FAILED": "Příkaz „npm install“ selhal: {0}",
    "API_NOT_COMPATIBLE": "Doplněk není kompatibilní s touto verzí {APP_NAME}. Naleznete jej ve složce disabled extensions.",
    "MISSING_MAIN": "Balíček neobsahuje soubor main.js.",
    "EXTENSION_ALREADY_INSTALLED": "Instalace tohoto balíčku přepíše již nainstalovaný doplněk. Chcete přepsat starý doplněk?",
    "EXTENSION_SAME_VERSION": "Tento balíček je stejná verze jako ta, kterou již máte nainstalovanou. Chcete přepsat existující doplněk?",
    "EXTENSION_OLDER_VERSION": "Tento balíček je verze {0}, která je starší než současně nainstalovaná verze ({1}). Chcete přepsat existující doplněk?",
    "DOWNLOAD_ID_IN_USE": "Interní chyba: ID stahování se již používá.",
    "NO_SERVER_RESPONSE": "Nelze se připojit na server.",
    "BAD_HTTP_STATUS": "Soubor nebyl nalezen (HTTP {0}).",
    "CANNOT_WRITE_TEMP": "Nelze uložit do dočasných souborů.",
    "ERROR_LOADING": "Při spuštění doplňku došlo k chybě.",
    "MALFORMED_URL": "URL adresa je neplatná. Ujistěte se, že jste adresu zadali správně.",
    "UNSUPPORTED_PROTOCOL": "URL adresa musí být http nebo https.",
    "UNKNOWN_ERROR": "Neznámá chyba.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE": "Extension Manager",
    "EXTENSION_MANAGER_ERROR_LOAD": "Nelze získat přístup k registru doplňků. Prosím, zkuste to znovu později.",
    "INSTALL_EXTENSION_DRAG": "Přetáhněte .zip zde nebo",
    "INSTALL_EXTENSION_DROP": "Pusťte .zip pro instalaci",
    "INSTALL_EXTENSION_DROP_ERROR": "Instalace/aktualizace byla zrušena kvůli následujících chyb:",
    "INSTALL_FROM_URL": "Instalovat z URL\u2026",
    "INSTALL_EXTENSION_VALIDATING": "Ověření\u2026",
    "EXTENSION_AUTHOR": "Autor",
    "EXTENSION_DATE": "Datum",
    "EXTENSION_INCOMPATIBLE_NEWER": "Tento doplněk požaduje novější verzi {APP_NAME}.",
    "EXTENSION_INCOMPATIBLE_OLDER": "Tento doplněk funguje pouze ve starší verzi {APP_NAME}.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER": "Verze {0} tohoto doplňku vyžaduje novější verzi {APP_NAME}. Můžete si ale nainstalovat dřívější verzi {1}.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER": "Verze {0} tohoto doplňku funguje pouze se starší verzí {APP_NAME}. Můžete si ale nainstalovat dřívější verzi {1}.",
    "EXTENSION_NO_DESCRIPTION": "Bez popisu",
    "EXTENSION_MORE_INFO": "Více informací\u2026",
    "EXTENSION_ERROR": "Chyba doplňku",
    "EXTENSION_KEYWORDS": "Klíčová slova",
    "EXTENSION_TRANSLATED_USER_LANG": "Přeloženo do {0} jazyků, včetně vašeho",
    "EXTENSION_TRANSLATED_GENERAL": "Přeloženo do {0} jazyků",
    "EXTENSION_TRANSLATED_LANGS": "Tento doplněk byl přeložen do těchto jazyků: {0}",
    "EXTENSION_INSTALLED": "Nainstalované",
    "EXTENSION_UPDATE_INSTALLED": "Aktualizace doplňku byla stažena a bude nainstalována při ukončení aplikace {APP_NAME}.",
    "EXTENSION_SEARCH_PLACEHOLDER": "Hledat",
    "EXTENSION_MORE_INFO_LINK": "Více",
    "BROWSE_EXTENSIONS": "Procházet doplňky",
    "EXTENSION_MANAGER_REMOVE": "Odstranit doplněk",
    "EXTENSION_MANAGER_REMOVE_ERROR": "Nelze odstranit jeden nebo více doplňků: {0}. Aplikace {APP_NAME} se i přesto restartuje.",
    "EXTENSION_MANAGER_UPDATE": "Aktualizovat doplněk",
    "EXTENSION_MANAGER_UPDATE_ERROR": "Nelze aktualizovat jeden nebo více doplňků: {0}. Aplikace {APP_NAME} se i přesto restartuje.",
    "EXTENSION_MANAGER_DISABLE": "Deaktivovat doplněk",
    "EXTENSION_MANAGER_DISABLE_ERROR": "Nelze deaktivovat jeden nebo více doplňků: {0}. Aplikace {APP_NAME} se i přesto restartuje.",
    "MARKED_FOR_REMOVAL": "Označeno k odstranění",
    "UNDO_REMOVE": "Zpět",
    "MARKED_FOR_UPDATE": "Označeno k aktualizaci",
    "UNDO_UPDATE": "Zpět",
    "MARKED_FOR_DISABLING": "Označeno k deaktivaci",
    "UNDO_DISABLE": "Zpět",
    "CHANGE_AND_RELOAD_TITLE": "Změnit doplňky",
    "CHANGE_AND_RELOAD_MESSAGE": "K aktualizaci, odstranění nebo deaktivaci označených doplňků je třeba restartovat aplikaci {APP_NAME}. Budete vyzváni k uložení změn.",
    "REMOVE_AND_RELOAD": "Odstranit doplňky a restartovat",
    "CHANGE_AND_RELOAD": "Změnit doplňky a restartovat",
    "UPDATE_AND_RELOAD": "Aktualizovat doplňky a restartovat",
    "DISABLE_AND_RELOAD": "Deaktivovat doplňky a restartovat",
    "PROCESSING_EXTENSIONS": "Zpracování změn doplňku\u2026",
    "EXTENSION_NOT_INSTALLED": "Doplněk {0} nemohl být odstraněn, protože nebyl nainstalován.",
    "NO_EXTENSIONS": "Žádný doplněk ještě nebyl nainstalován.<br>Klikněte na tlačítko Instalovat z URL pro zahájení instalace.",
    "NO_EXTENSION_MATCHES": "Žádný doplněk neodpovídá hledání.",
    "REGISTRY_SANITY_CHECK_WARNING": "POZNÁMKA: Tyto doplňky mohou pocházet od jiných autorů než {APP_NAME}. Buďte opatrní při instalaci doplňků z neznámých zdrojů.",
    "EXTENSIONS_INSTALLED_TITLE": "Nainstalované",
    "EXTENSIONS_DEFAULT_TITLE": "Výchozí",
    "EXTENSIONS_AVAILABLE_TITLE": "Dostupné",
    "EXTENSIONS_THEMES_TITLE": "Motivy",
    "EXTENSIONS_UPDATES_TITLE": "Aktualizace",
    "EXTENSIONS_LAST_UPDATED": "Poslední aktualizace",
    "EXTENSIONS_DOWNLOADS": "Stažené soubory",

    "INLINE_EDITOR_NO_MATCHES": "Žádné dostupné shody.",
    "INLINE_EDITOR_HIDDEN_MATCHES": "Všechny shody jsou sbalené. Pro prohlédnutí shod rozbalte soubory zobrazené vpravo.",
    "CSS_QUICK_EDIT_NO_MATCHES": "Neexistují žádné CSS předpisy odpovídající vašemu výběru.<br>Pro vytvoření předpisu klikněte na \"Nový předpis\".",
    "CSS_QUICK_EDIT_NO_STYLESHEETS": "Neexistují žádné soubory s kaskádovými styly ve vašem projektu.<br>Vytvořte nový soubor pro přidání CSS předpisů.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON": "největší",

    /**
     * Unit names
     */
    "UNIT_PIXELS": "pixely",

    // extensions/default/DebugCommands
    "DEBUG_MENU": "Ladit",
    "ERRORS": "Chyby",
    "CMD_SHOW_DEV_TOOLS": "Zobrazit nástroje pro vývojáře",
    "CMD_REFRESH_WINDOW": "Restartovat {APP_NAME}",
    "CMD_RELOAD_WITHOUT_USER_EXTS": "Restartovat bez doplňků",
    "CMD_NEW_BRACKETS_WINDOW": "Nové okno {APP_NAME}",
    "CMD_LAUNCH_SCRIPT_MAC": "Nainstalovat zástupce do příkazové řádky",
    "CMD_SWITCH_LANGUAGE": "Změnit jazyk",
    "CMD_RUN_UNIT_TESTS": "Spustit testy",
    "CMD_SHOW_PERF_DATA": "Zobrazit údaje o výkonnosti",
    "CMD_ENABLE_NODE_DEBUGGER": "Povolit Node Debugger",
    "CMD_LOG_NODE_STATE": "Uložit stav Node do konzole",
    "CMD_RESTART_NODE": "Restartovat Node",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR": "Zobrazit chyby ve stavovém řádku",
    "CMD_OPEN_BRACKETS_SOURCE": "Otevřít zdroj {APP_NAME}",

    "CREATING_LAUNCH_SCRIPT_TITLE": "Zástupce {APP_NAME} v příkazové řádce",
    "ERROR_CREATING_LAUNCH_SCRIPT": "Při instalaci zástupce do příkazové řádky se vyskytla chyba. Prosím vyzkoušejte řešení <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>na této stránce</a>.<br/><br/>Důvod: {0}",
    "ERROR_CLTOOLS_RMFAILED": "Nelze odstranit existující symbolický odkaz na <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_MKDIRFAILED": "Nelze vytvořit složku <code>/usr/local/bin</code>.",
    "ERROR_CLTOOLS_LNFAILED": "Nelze vytvořit symbolický odkaz na <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_SERVFAILED": "Interní chyba.",
    "ERROR_CLTOOLS_NOTSUPPORTED": "V tomto operačním systému nelze vytvořit zástupce do příkazové řádky.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS": "Hotovo! Nyní můžete jednoduše spustit {APP_NAME} z příkazové řádky: příkazem <code>brackets myFile.txt</code> otevřete soubor a příkazem <code>brackets myFolder</code> změníte projekt. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Na této stránce zjistíte více</a> o používání {APP_NAME} z příkazové řádky.",

    "LANGUAGE_TITLE": "Změnit jazyk",
    "LANGUAGE_MESSAGE": "Jazyk:",
    "LANGUAGE_SUBMIT": "Restartovat {APP_NAME}",
    "LANGUAGE_CANCEL": "Zrušit",
    "LANGUAGE_SYSTEM_DEFAULT": "Výchozí",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION": "Nastavení hlášení o zdraví",
    "HEALTH_FIRST_POPUP_TITLE": "Hlášení o zdraví {APP_NAME}",
    "HEALTH_DATA_DO_TRACK": "Sdílejte anonymní informace o používání {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE": "Kvůli vylepšování {APP_NAME} odesíláme společnosti Adobe pravidelně omezené <strong>anonymní</strong> statistiky o používání {APP_NAME}. Tyto informace pomáhají upřednostnit některé funkce, předcházet chybám a všimnout si nedostatků v použitelnosti.<br><br>Vaše data si můžete prohlédnout nebo zakázat jejich sdílení výběrem <strong>Nápověda > Hlášení o zdraví</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Zjistěte více ke hlášení o zdraví {APP_NAME}</a>",
    "HEALTH_DATA_PREVIEW": "Hlášení o zdraví {APP_NAME}",
    "HEALTH_DATA_PREVIEW_INTRO": "<p>Kvůli vylepšování {APP_NAME} odesíláme společnosti Adobe pravidelně omezené <strong>anonymní</strong> statistiky o používání {APP_NAME}. Tyto informace pomáhají upřednostnit některé funkce, předcházet chybám a všimnout si nedostatků v použitelnosti. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Zjistěte více ke hlášení o zdraví {APP_NAME}</a> a jak je pro komunitu {APP_NAME} prospěšné, zatímco je chráněno vaše soukromí.</p><p>Níže je náhled dat, která budou odeslána v příštím hlášení o zdraví, <em>pokud</em> je odesílání povoleno.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME": "Doba",
    "INLINE_TIMING_EDITOR_PROGRESSION": "Postup",
    "BEZIER_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Posunout vybraný bod<br><kbd class='text'>Shift</kbd> Posunout o deset jednotek<br><kbd class='text'>Tab</kbd> Vyměnit body",
    "STEPS_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd> Zvýšení nebo snížení kroků<br><kbd>←</kbd><kbd>→</kbd> 'Start' nebo 'End'",
    "INLINE_TIMING_EDITOR_INVALID": "Stará hodnota <code>{0}</code> není platná, proto zobrazená funkce byla změněna na <code>{1}</code>. Dokument bude aktualizován při první úpravě.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP": "Současná barva",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP": "Původní barva",
    "COLOR_EDITOR_RGBA_BUTTON_TIP": "RGBa formát",
    "COLOR_EDITOR_HEX_BUTTON_TIP": "Hex formát",
    "COLOR_EDITOR_HSLA_BUTTON_TIP": "HSLa formát",
    "COLOR_EDITOR_0X_BUTTON_TIP": "Hex (0x) formát",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR": "{0} (použito {1} krát)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL": "{0} (použito {1} krát)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION": "Přejít na definici",
    "CMD_SHOW_PARAMETER_HINT": "Zobrazit nápovědu parametru",
    "NO_ARGUMENTS": "<žádné parametry>",
    "DETECTED_EXCLUSION_TITLE": "Inferenční problém JavaScript souboru",
    "DETECTED_EXCLUSION_INFO": "{APP_NAME} narazil na problémy při zpracování <span class='dialog-filename'>{0}</span>.<br><br>Tento soubor nebude nadále používat nápovědy kódu, přechod na definici nebo rychlou úpravu. Pro opětovné zapnutí těchto funkcí, otevřete <code>.brackets.json</code> ve vašem projektu a upravte <code>jscodehints.detectedExclusions</code>.<br><br>Pravděpodobně je to chyba {APP_NAME}. Pokud můžete poskytnout kopii tohoto souboru, prosíme <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>nahlaste tuto chybu</a> s odkazem na daný soubor.",

    // extensions/default/JSLint
    "JSLINT_NAME": "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW": "Rychlý náhled",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS": "Nedávné projekty",

    // extensions/default/MDNDocs
    "DOCS_MORE_LINK": "Další informace",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL": "Skrýt vše",
    "EXPAND_ALL": "Rozbalit vše",
    "COLLAPSE_CURRENT": "Skrýt aktuální",
    "EXPAND_CURRENT": "Zobrazit aktuální",

    // extensions/default/NavigationAndHistory
    "RECENT_FILES_DLG_HEADER": "Poslední soubory",
    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL": "Vymazat",
    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE": "Vymazat soubory mimo pracovní sadu",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS": "true k automatickému uzavírání závorek",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE": "false k odebrání \"Zavřít ostatní výše\" z kontextového menu pracovních souborů",
    "DESCRIPTION_CLOSE_OTHERS_BELOW": "false k odebrání \"Zavřít ostatní níže\" z kontextového menu pracovních souborů",
    "DESCRIPTION_CLOSE_OTHERS": "false k odebrání \"Zavřít ostatní\" z kontextového menu pracovních souborů",
    "DESCRIPTION_CLOSE_TAGS": "Nastavit možnosti uzavírání značek",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS": "Pole značek, které by neměly být automaticky uzavírány",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING": "Zavřít, pokud je napsán > otevírací značky",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING": "Zavřít, pokud je napsán / uzavírací značky",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS": "Pole značek, do kterých je po jejich otevření vložen prázdný řádek",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD": "true k vygenerování záložek skrývajících kód vždy, když se změní úroveň odsazení",
    "DESCRIPTION_CODE_FOLDING_ENABLED": "true k povolení skrývání kódu",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER": "true k zobrazení záložek skrývajících kód pouze pokud přejedete myší nad okrajem",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL": "Limity, kolik úrovní do hloubky platí Skrýt vše",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE": "Nejmenší počet řádků, pro které se objeví ikona pro skrytí kódu",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES": "true k zapamatování skrytých částí pokud zavřete a znovu otevřete soubor nebo projekt",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "true k povolení skrývání kódu při výběru textu v editoru",
    "DESCRIPTION_DISABLED_DEFAULT_EXTENSIONS": "Výchozí rozšíření, která jsou zakázána",
    "DESCRIPTION_ATTR_HINTS": "Povolit/zakázat nápovědy HTML vlastností",
    "DESCRIPTION_CSS_PROP_HINTS": "Povolit/zakázat nápovědy CSS/LESS/SCSS hodnot",
    "DESCRIPTION_JS_HINTS": "Povolit/zakázat nápovědy v JavaScriptu",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS": "Povolit/zakázat detaily o datových typech v nápovědách kódu u JavaScriptu",
    "DESCRIPTION_PREF_HINTS": "Povolit/zakázat nápovědy v preferencích",
    "DESCRIPTION_SPECIAL_CHAR_HINTS": "Povolit/zakázat nápovědy HTML entit",
    "DESCRIPTION_SVG_HINTS": "Povolit/zakázat nápovědy v SVG",
    "DESCRIPTION_HTML_TAG_HINTS": "Povolit/zakázat nápovědy HTML značek",
    "DESCRIPTION_URL_CODE_HINTS": "Povolit/zakázat nápovědy adres URL v HTML & CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT": "Povolit/zakázat funkci Drag & Drop",
    "DESCRIPTION_HEALTH_DATA_TRACKING": "Povolit sledování hlášení o zdraví",
    "DESCRIPTION_HIGHLIGHT_MATCHES": "Povolit automatické zvýrazňování shodujících se výrazů v celém dokumentu",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN": "Zvýraznit všechny výrazy shodující se s výrazem, na kterém je aktuálně kurzor (není nutný výběr výrazu)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY": "Zvýraznit pouze pokud je výběr kompletním výrazem",
    "DESCRIPTION_INSERT_HINT_ON_TAB": "true k vložení aktuálně vybrané nápovědy při tabulátoru",
    "DESCRIPTION_NO_HINTS_ON_DOT": "true k zamezení automatického zobrazení nápověd JS kódu, jestliže je napsaná .",
    "DESCRIPTION_JSLINT_OPTIONS": "Objekt s výchozími možnostmi pro JSLint",
    "DESCRIPTION_JSLINT_OPTIONS_ASS": "true k povolení přiřazených výrazů",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE": "true k povolení bitových operátorů",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER": "true pokud by globální proměnné standardního prohlížeče měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE": "true k povolení idiomů Google Closure",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE": "true k povolení příkazu \"continue\"",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH": "true pokud by globální proměnné CouchDB měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG": "true k povolení příkazů debuggeru",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL": "true pokud by globální proměnné prohlížeče užitečné při vývoji měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ": "true k povolení == a !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6": "true pokud by globální proměnné ES6 měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL": "true k povolení eval",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN": "true k povolení nefiltrovaných \"for ... in\"",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT": "Nastavit vlastní šířku tabulátoru",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR": "Maximální počet hlášených varování",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN": "Maximální počet znaků na řádku",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP": "true k povolení nevyužitých konstruktorů",
    "DESCRIPTION_JSLINT_OPTIONS_NODE": "true pokud by globální proměnné Node.js měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN": "true k povolení přebývajících podtržítek v identifikátorech",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL": "true k zastavení na první chybě",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS": "true k povolení ++ a --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP": "true k povolení . a [^...]. v RegExpu",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO": "true pokud by globální proměnné Rhino měly být předdefinované",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY": "true k povolení chybějících `use strict`",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID": "true pokud může být použito blokování ('...Sync') metod.",
    "DESCRIPTION_JSLINT_OPTIONS_SUB": "true k povolení neefektivního indexování",
    "DESCRIPTION_JSLINT_OPTIONS_TODO": "true k povolení TODO komentářů",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM": "true k povolení nepoužitých parametrů",
    "DESCRIPTION_JSLINT_OPTIONS_VARS": "true k povolení více než 1 proměnné ve funkci",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE": "true k ignorování pravidel ohledně prázdných znaků",
    "DESCRIPTION_LANGUAGE": "Vlastní nastavení jazyků",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS": "Dodatečná mapování z přípony souboru na jméno jazyka",
    "DESCRIPTION_LANGUAGE_FILE_NAMES": "Dodatečná mapování z názvu souboru na jméno jazyka",
    "DESCRIPTION_LINEWISE_COPY_CUT": "Pokud se pokusíte kopírovat a vložit v situaci, kdy není označen žádný prvek, dojde ke zkopírování nebo vyjmutí celých řádků, na kterých se nachází kurzor",
    "DESCRIPTION_INPUT_STYLE": "Určuje způsob, jakým CodeMirror zpracovává vstupy a aktivní okna. Může se jednat o textovou oblast (výchozí nastavení) nebo „contenteditable“, který je lepší pro čtení z obrazovky (nestabilní).",
    "DESCRIPTION_LINTING_ENABLED": "true k povolení panelu zpráv",
    "DESCRIPTION_ASYNC_TIMEOUT": "Čas v milisekundách, po kterém vyprší asynchronní lintery",
    "DESCRIPTION_LINTING_PREFER": "Pole linterů spouštěných nejdříve",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER": "true k povolení experimentálního živého náhledu",
    "DESCRIPTION_USE_PREFERED_ONLY": "true ke spuštění poskytovatelů určených pouze v linting.prefer",
    "DESCRIPTION_MAX_CODE_HINTS": "Maximální počet současně zobrazených nápověd kódu",
    "DESCRIPTION_PATH": "Vlastní nastavení cest",
    "DESCRIPTION_PROXY": "URL proxy serveru použitého k instalaci doplňků",
    "DESCRIPTION_SCROLL_PAST_END": "true k povolení rolování za konec dokumentu",
    "DESCRIPTION_SHOW_CODE_HINTS": "false k zakázání všech nápověd kódu",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING": "Při výběru textu nechat zobrazený blikající kurzor",
    "DESCRIPTION_SHOW_LINE_NUMBERS": "true ke zobrazení čísel řádků na okraji vlevo od kódu",
    "DESCRIPTION_SMART_INDENT": "Automaticky odsadit při vytvoření nového bloku",
    "DESCRIPTION_SOFT_TABS": "false k zamezení nahrazování tabulátorů mezerami",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST": "true k řazení složek nahoru ve stromu souborů projektu",
    "DESCRIPTION_SPACE_UNITS": "Počet mezer použitých v odsazení mezerami",
    "DESCRIPTION_STATIC_SERVER_PORT": "Síťový port, který by zabudovaný server měl použít pro živý náhled",
    "DESCRIPTION_STYLE_ACTIVE_LINE": "true ke zvýraznění řádku, na kterém se nachází kurzor, barvou na pozadí",
    "DESCRIPTION_TAB_SIZE": "Počet zobrazených mezer místo tabulátoru",
    "DESCRIPTION_USE_TAB_CHAR": "true k používání tabulátorů místo mezer",
    "DESCRIPTION_UPPERCASE_COLORS": "true k vygenerování hex barev velkými písmeny v Inline Color Editor",
    "DESCRIPTION_WORD_WRAP": "Zalomit řádky přesahující šířku viewportu",
    "DESCRIPTION_DETECTED_EXCLUSIONS": "Seznam souborů, u kterých bylo zjištěno, že způsobují, že se Tern vymkne kontrole",
    "DESCRIPTION_INFERENCE_TIMEOUT": "Doba, po jejímž uplynutí Tern při snaze porozumět souborům vyprší",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR": "true ke zobrazení chyb ve stavovém řádku",
    "DESCRIPTION_QUICK_VIEW_ENABLED": "true k povolení rychlého náhledu",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW": "true ke zobrazení náhledů obrázků pro chybějící přípony URL",
    "DESCRIPTION_THEME": "Vybrat motiv {APP_NAME}",
    "DESCRIPTION_USE_THEME_SCROLLBARS": "true k povolení vlastních posuvníků",
    "DESCRIPTION_LINTING_COLLAPSED": "true ke skrytí panelu linteru",
    "DESCRIPTION_FONT_FAMILY": "Změnit písmo",
    "DESCRIPTION_FONT_SIZE": "Změnit velikost písma, např. 13px",
    "DESCRIPTION_FIND_IN_FILES_NODE": "true k povolení vyhledávání založeného na Node",
    "DESCRIPTION_FIND_IN_FILES_INSTANT": "true k povolení okamžitého vyhledávání",
    "DESCRIPTION_FONT_SMOOTHING": "Pouze pro Mac: \"subpixel-antialiased\" k povolení sub-pixel vyhlazování nebo \"antialiased\" k vyhlazování v odstínech šedi",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW": "false k zamezení otevírání souboru s preferencemi v rozděleném editoru",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE": "false k otevření souboru s preferencemi v levém/horním panelu",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED": "true ke skrytí panelů po zavření posledního souboru z panelu pomocí tlačítka na hlavičce panelu",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS": "Změňte ke zobrazení tlačítek zavřít a rozdělit ve hlavičce.",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT": "/*\n * Toto je soubor pouze ke čtení s preferencemi podporovanými\n * v {APP_NAME}.\n * Použijte tento soubor jako doporučení pro úpravu vašeho souboru s preferencemi\n * \"brackets.json\" otevřeném ve druhém panelu.\n * Pro více informací o úpravě preferencí\n * v {APP_NAME} se podívejte na webovou stránku https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT": "Výchozí",
    "DESCRIPTION_PURE_CODING_SURFACE": "true k povolení módu pouze s kódem a ke skrytí Všech dalších UI prvků v {APP_NAME}",
    "DESCRIPTION_INDENT_LINE_COMMENT": "jako pravdivý parametr, pokud chcete povolit odsazení řádku u komentářů",
    "DESCRIPTION_RECENT_FILES_NAV": "Povolit/zakázat navigaci v naposledy otevřených souborech",
    "DESCRIPTION_LIVEDEV_WEBSOCKET_PORT": "Port, kterým prochází WebSocket Server pro živé zobrazení náhledu",
    "DESCRIPTION_LIVE_DEV_HIGHLIGHT_SETTINGS": "Nastavení zvýraznění v živém náhledu",
    "DESCRIPTION_LIVEDEV_ENABLE_REVERSE_INSPECT": "nedošlo k zablokování zpětné kontroly živého náhledu",
    "DESCRIPTION_PHP_HINTS": "Povolit/zakázat našeptávání kódu PHP",
    "BROWSE_COMMAND_STRING": " Procházet...",

    "COLOR_PICKER_CMD_STRING": " Výběr barvy...",
    "CHOOSE_ANOTHER_CC_LIBARAY": "Změnit knihovnu",
    "EXTRACT_INSERT_SELECTED": " Vložit vybrané",
    "DESCRIPTION_EMMET_PREFS": "Povolit/zakázat nástroje Emmet",
    "IMAGE_NOT_FOUND_ERR": "Obrázek nebyl nalezen"
});
