## Opening issues

Before opening a new issue, please be sure to check out list of already open issues [here](https://github.com/zaggino/brackets-git/issues?state=open) so we can prevent having duplicates.
Always try to get as much relevant information from Brackets console (F12) as possible. To get more detailed output from console, turn on the DEBUG mode in Git settings dialog. (This mode will slow your extension down so don't forget to turn it off when you don't need it anymore)

## Pull requests

When creating a new functionality which isn't noted on GitHub, please open an issue for it before working on the code as others may have hints and suggestions to consider before writing the code. Also when fixing an issue, add a comment to the issue on GitHub before working on it so it doesn't happen that two people are working on the same thing at the same time.

Always check for syntax errors with `grunt test` or use some JSHint extension while editing the code.
Recommended are both [JSHint](https://github.com/cfjedimaster/brackets-jshint) and [InteractiveLinter](https://github.com/MiguelCastillo/Brackets-InteractiveLinter).

## Developing

To develop Brackets Git we use Brackets with some useful extensions and it's highly recommended you use them too:

- [JSHint](https://github.com/cfjedimaster/brackets-jshint)
- [Interactive Linter](https://github.com/MiguelCastillo/Brackets-InteractiveLinter)
- [LESS AutoCompile](https://github.com/jdiehl/brackets-less-autocompile)
- [Todo](https://github.com/mikaeljorhult/brackets-todo)
