/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, console */
/*jslint nomen: true */

function DeleteRuleCommand(socket, rule) {
    "use strict";
    this._socket = socket;
	this._rule = rule;
}

DeleteRuleCommand.prototype.execute = function () {
    "use strict";
    if (typeof this._socket.authorized !== "undefined" && this._socket.authorized === true) {
        var socketGroup = this._socket.request.group;
        if (socketGroup !== '') {
            this.socket.broadcast.to(socketGroup).emit('partial:refresh:delete:rule', this._rule);
        }
    }
};

function InsertRuleCommand(socket, rule) {
    "use strict";
    this._socket = socket;
	this._rule = rule;
}

InsertRuleCommand.prototype.execute = function () {
    "use strict";
    if (this._socket.authorized === true) {
        var socketGroup = this._socket.request.group;
        if (socketGroup !== '') {
            this._socket.broadcast.to(socketGroup).emit('partial:refresh:insert:rule', this._rule);
        }
    }
};

module.exports = {
    insertRule: InsertRuleCommand,
    deleteRule: DeleteRuleCommand
};