/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global Uint16Array, ArrayBuffer, module, require*/
/*jslint plusplus: true*/

var iconv = require('iconv-lite');
var charsetParser = require('charset-parser');

function arrayBuffer2String(buf) {
    'use strict';
    return String.fromCharCode.apply(null, new Uint16Array(buf));
}

function string2ArrayBuffer(str) {
    'use strict';
    var buf = new ArrayBuffer(str.length * 2), // 2 bytes for each char
        bufView = new Uint16Array(buf),
        i,
        strLen = str.length;
    
    for (i = 0; i < strLen; i++) {
        bufView[i] = str.charCodeAt(i);
    }
    return buf;
}

function arrayBuffer2StringWithEncoding(contentType, html, defaultEncoding) {
    'use strict';
    var charset = charsetParser(contentType, arrayBuffer2String(html), defaultEncoding);
    // decode binary with charset 
    return iconv.decode(html, charset);
}

module.exports = {
    string2ArrayBuffer: string2ArrayBuffer,
    arrayBuffer2String: arrayBuffer2String,
    arrayBuffer2StringWithEncoding: arrayBuffer2StringWithEncoding
};