/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, __dirname*/

var restify = require('restify'),
    validationError = {
        http_code: 400,
        http_message: 'Parameter not valid',
        log_message: 'Validation failed'
    };

module.exports = {
    fail: validationError,

    defineRoute: function (server, method, path, handler, pattern) {
        'use strict';
        pattern = pattern || {};
        pattern.params = pattern.params || {};
        pattern.params['*'] = null;
        pattern.query = pattern.query || {};
        pattern.query['*'] = null;
        pattern.body = pattern.body || module.exports.emptybody;

        server[method.toLowerCase()](path, function (req, res, next, invokeExtensionPoint) {
            var key,
                i,
                keysToDelete = [],
                request = {};
            
            if (req.params) {
                for (key in req.params) {
                    if (req.params.hasOwnProperty(key)) {
                        req.params[key] = decodeURIComponent(req.params[key]);
                    }
                }
            }
            if (req.query) {
                for (key in req.query) {
                    if (req.query.hasOwnProperty(key)) {
                        req.query[key] = decodeURIComponent(req.query[key]);
                    }
                }
            }

            if (req.headers && req.headers['content-disposition']) {
                req.headers['content-disposition'] = decodeURIComponent(req.headers['content-disposition']);
            }

            handler(req, res, next, invokeExtensionPoint);
        });
    },
    
    defineStaticRoute: function (server, method, path) {
        'use strict';
        server[method.toLowerCase()](path, restify.serveStatic({
	        'directory': __dirname + '/../../client-scripts',
	        'default': ''
        }));
    },
    
    defineDeviceAppRoute: function (server, method, path) {
        'use strict';
        server[method.toLowerCase()](path, restify.serveStatic({
	        'directory': __dirname + '/../../device-app',
	        'default': ''
        }));
    }
};