/*	
 Copyright 2013 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file has the implementation of for Dreamweaver side utility functions which are exposed to SelectorHud exrtension.
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global GenericLiveEditBridger,dw, DW_LIVEEDIT_CONSTANTS */

function SelectorHudBridger(documentDOM) {
    'use strict';
    this.logDebugMsg("creating SelectorHud Bridger");
    this.setDocumentDOM(documentDOM);
}

SelectorHudBridger.prototype = new GenericLiveEditBridger();
SelectorHudBridger.prototype.constructor = SelectorHudBridger;
SelectorHudBridger.prototype.baseClass = GenericLiveEditBridger.prototype.constructor;

/*
function:dwGetRelatedCSSFiles
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Returns related css files related to a document.

*/
SelectorHudBridger.prototype.dwGetRelatedCSSFiles = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwGetRelatedCSSFiles :callback Obj not present");
        return;
    }
    
    var cssFiles = dw.getRelatedCSSFiles(true);

    if (argObj.callback) {
        argObj.callback(cssFiles);
    }
};

/*
function:dwGetRelatedMediaQueries
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Returns media query related to a css file.

*/
SelectorHudBridger.prototype.dwGetRelatedMediaQueries = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwGetRelatedMediaQueries :callback Obj not present");
        return;
    }
    
    var relateMQ = dw.getRelatedMediaQueries(argObj.index);
    if (argObj.callback) {
        argObj.callback(relateMQ);
    }
};

/*
function:dwAddCssRule
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Adds neww css rule to document.

*/
SelectorHudBridger.prototype.dwAddCssRule = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwAddCssRule :callback Obj not present");
        return;
    }
    
    var cssRule = dw.addCSSRule(argObj.cssIndex, argObj.mediaIndex, argObj.selectorText);
    if (argObj.callback) {
        argObj.callback(cssRule);
    }
};

/*
function:dwGetNewCSSDialog
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Gets dialog to create new css file.

*/
SelectorHudBridger.prototype.dwGetNewCSSDialog = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwGetNewCSSDialog :callback Obj not present");
        return;
    }
    
    var dialogStr = dw.getNewCSSDialog(true);
    dw.setFocusToLiveView();
    if (argObj.callback) {
        argObj.callback(dialogStr);
    }
    
};

/*
function:dwGetNewMeidaQueryDialog
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Gets dialog to create new media query.

*/
SelectorHudBridger.prototype.dwGetNewMeidaQueryDialog = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwGetNewMeidaQueryDialog :callback Obj not present");
        return;
    }
    
    var dialogStr = dw.getNewMeidaQueryDialog(argObj.cssIndex, argObj.isStyleTagDefined);
    dw.setFocusToLiveView();
    if (argObj.callback) {
        argObj.callback(dialogStr);
    }
};

/*
function:dwDefineCSSRuleInPage
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Define a new css rule in page , that is in style tag inside HTML doc.

*/
SelectorHudBridger.prototype.dwDefineCSSRuleInPage = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwDefineCSSRuleInPage :callback Obj not present");
        return;
    }
    var cssRule = dw.defineCSSRuleInPage(argObj.selectorText);
    if (argObj.callback) {
        argObj.callback(cssRule);
    }
};
