/*	
 Copyright 2014 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file has the implementation of some functions used commonly in Javascript Programming
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50, continue: true */

var DwJSUtility = {
    
    // Array utility Methods
    filterUnique: function (value, index, self) {
        "use strict";
        // usage
        // var arr = ['dw', 2014, 'responsive', 2014, 'dw'];
        // var uniqueArr = arr.filter( filterUnique ); // returns ['dw', 2014, 'responsive'];
        // this would work for native data types like string, number
        return self.indexOf(value) === index;
    },
    
    sortByNumber: function (a, b) {
        // pass only strings that are valid numbers to this. to be used as arr.sort(sortByNumber)
        "use strict";
        var value1 = parseFloat(a, 10),
            value2 = parseFloat(b, 10);
        if (value1 < value2) {
            return -1;
        } else if (value1 === value2) {
            return 0;
        }
        return 1;
    },
    
    // Support string and int return types for the computed value
    getComputedCssPropValFromElem: function (elemNode, prop, expectedReturnType, fromParentWindow) {
        "use strict";
        
        var docWindow = window;
        if (typeof fromParentWindow !== "undefined" && fromParentWindow === true) {
            docWindow = window.parent;
        }
        var returnType = 'string';
        if (expectedReturnType === 'int') {
            returnType = 'int';
        }
        
        if (!elemNode) {
            if (returnType === "string") {
                return "";
            }
            return 0;
        }
        var strVal = '';
        var computedStyle = docWindow.getComputedStyle(elemNode);
        if (computedStyle) {
            strVal = computedStyle.getPropertyValue(prop);
        }
        if (returnType === 'string') {
            return strVal;
        }
        var intVal = parseInt(strVal, 10);
        if (isNaN(intVal)) {
            intVal = 0;
        }
        intVal = Math.floor(intVal);
        return intVal;
    }
};