/*	
 Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file contains some debug Utilities for ELV Extension
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50, continue: true */
/*global console */

var DebugUtils = {
    debug: false,
    
    /*
        function:log() - logs to the console if debugging is switched on.
        Arguments: none
        Return: none.
    */
    log: function (message) {
        "use strict";
        if (this.debug) {
            console.log(message);
        }
    },

    /*
        function:constructErrorLine() - private: construct the error line no. from the call stack
        Arguments: error string which was passed
        Return: formatted error string with the line no where the error occured.
    */
    constructErrorLine: function (error) {
        "use strict";
        var i = 3,
            sliceString = " at ",
            sliceStringLoc = -1,
            errorString = error.stack; // find out the line which has the error from the call stack, each function call separated by " at "
            /* SAMPLE ERROR STACK
            "Error
                at Object.DebugUtils.getErrorMessage (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/Utils/DebugUtils.js:56:19)
                at Object.DebugUtils.assert (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/Utils/DebugUtils.js:87:31)
                at ResponsiveFrameworkImpl (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/assets/js/ResponsiveFramework.js:26:24)
                at new BootstrapFrameworkImpl (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/assets/js/ResponsiveFramework.js:166:33)
                at ResponsiveAdapterImpl.constructResponsiveFramework (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/assets/js/ResponsiveAdapter.js:58:40)
                at new ResponsiveAdapterImpl (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/assets/js/ResponsiveAdapter.js:27:22)
                at new ResponsiveOverlay.ResponsiveLayoutManipulator.ResponsiveLayoutManipulatorImpl (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/assets/js/ResponsiveLayoutManipulator.js:28:34)
                at createResponsiveLayoutManipulator (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/ResponsiveLayoutManipulator.html:47:66)
                at onload (file:///C:/workspace/dreamweaver/Mainline/Dreamweaver/Targets/bin/Configuration/Shared/LiveEdit/Extensions/ResponsiveLayout/ResponsiveLayoutManipulator.html:61:141)"
                */
        
        
        while (i-- > 0) {
            sliceStringLoc = errorString.search(sliceString);
            errorString = errorString.slice(sliceStringLoc + sliceString.length);
        }
        sliceStringLoc = errorString.search(sliceString);
        errorString = errorString.slice(0, sliceStringLoc);
        return errorString;
    },
    
    /*
        function:getErrorMessage() - private: constructs the new error message with the line no. from the call stack
        Arguments: error string which was passed
        Return: formatted error string with the line no where the error occured.
    */
    getErrorMessage: function (message) {
        "use strict";
        var error = null;
        try {
            throw new Error(message);
        } catch (err) {
            error = err;
        }
        if (error) {
            message = message + "\r\nLine No.: " + this.constructErrorLine(error);
        }
        
        return message;
    },

    /*
        function:logError() - public: logs the error to the console
        Arguments: error string which was passed
        Return: none
    */
    logError: function (message) {
        "use strict";
        if (message && typeof message === "string") {
            console.error(message);
        }
    },

    /*
        function:assert() - public: Assert to the user in debug mode with the Assertion Failure and the line no. where Assertion failed
        Arguments: error string which was passed
        Return: none
    */
    assert: function (result) {
        "use strict";
        if (this.debug && !result) {
            var errMsg = this.getErrorMessage("");
            alert("ASSERT: " + errMsg);
        }
    }
};