/*    
 Copyright 2013 Adobe Systems Incorporated.  All rights reserved. 
    Purpose- This file contains all the Constants that are used in LiveEditing Feature
*/
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*jshint -W100 */

var DW_LIVEEDIT_CONSTANTS = {
    GlobalContainerDiv: "dw-container-div",
    ContainerDiv: "dw-div",
    TextContainer: "DW_SPAN",
	NonBreakingSpace: "&nbsp;",
	MarkupForLessThan: "&lt;",
	MarkupForGreatorThan: "&gt;",
    HudTextEdit: "Text Edit",
    HudEditableRegion: "Editable Regions",
    Extensions: "Extensions",
	TextEditScriptStyleID: "TextEditOverlayStyles",
    SelectionSyncBridge: "SelSyncBrdg",
    //this string should match with LiveEditUtils.h:LIVE_EDIT_EXTENSIONS_RESOURCE_PATH_PLACEHOLDER
    ExtensionsResourcePathPlaceHolder: "dwExtensionsResourcePath",
	//this string should match with LiveEditUtils.h:PARTIAL_REFRESH_PRIMARY_TITANDOC_IDENTIFIER
    PartialRefreshPrimaryTitanDocIdentifier: "dwPartialRefreshPrimaryTitanDocIdentifier",
    EditableRegionBeginText: " InstanceBeginEditable ",
    EditableRegionEndText: " InstanceEndEditable",
    OverlayBorderWidth: 1,
    none: "none",
    DWUniqueId: "data_liveedit_tagid",
    DWTempId: "data_temp_dwid",
    DWSpanId: "DW_SPAN_ID",
    FontStyleId : "FONT_STYLE_ID",
    FontWeightId : "FONT_WEIGHT_ID",
	AttrbuteID:	"id",
    EnterKeyCode: 13,
	BackSpace: 8,
	DeleteKey: 46,
    Up: 38,
    Down: 40,
    Right: 39,
    Left: 37,
    OverlayCSS_TextEdit: "overlay_textEdit",
    DisableSelectionOnBody_TextEdit : "disable_selection",
    TabKeyCode: 9,
    SpaceKeyCode: 32,
    EscapeKeyCode: 27,
	NBSPCharCode: 160,
    HTMLTagName: "HTML",
    TableDataTagName: "TD",
	TableHeaderTagName: "TH",
    ImgTagName: "img",
    AltTagName: "alt",
    InputTagName: "INPUT",
    TextAreaTagName: "TEXTAREA",
    LabelTagName: "LABEL",
    OverlayPadding_Left: 2,
    OverlayPadding_Right: 4,
    OverlayPadding_Top: 0,
    OverlayPadding_Bottom: 0,
    ThresholdForDoubleClick: 400,
    textEditedInLiveView: "textEditLiveView",
    textEditEventCategory: "endAction",
	ParentNotMatching: "Parent not Matching",
	RedrawTimeOut: 20,
    DwImageHud: "dwImageHud",
    DwTextHud: "dwTextHud",
    DwEshHud: "editableSelectors",
    DwLiveDragFeedbackExtensionId: "liveDragFeedback",
    DwSelectorHud: "dwSelectorHud",
    HudSelectorHud: "Selector Hud",
    DevicePreview: "Device Preview",
    MaxArraySizeForBridging: 100
};

// Inspect Mode Constants
var DW_INSPECT_CONST = {
	ExtID: "InspectModeUI",
	DWInspectId: "data_dw_inspect_tagid",
	InspectModeOff: 0,
	InspectModeMouseOver: 1,
	InspectModeWithGuides: 2,
	InspectModeWithoutGuides: 3,
    InspectModeLast: 4,
	contentColor: "rgba(111, 168, 220, 0.6588235294117647)",
	contentOutlineColor: "#095394",
	paddingColor: "rgba(147, 196, 125, 0.5490196078431373)",
	borderColor: "rgba(255, 229, 153, 0.6588235294117647)",
	marginColor: "rgba(246, 178, 107, 0.6588235294117647)",
	eventTargetColor: "rgba(0, 0, 0, 0)",
	guidGenericColor: "rgba(255, 255, 255, 0)",
	guidContentOutlineColor: "#2D8CEB"
};

// Possible values for Inspect with Guid
// Taken from enum WebSettingsInspectHighlightPosition in WebKit/public/web/DWInspectSettings.h 
var DW_INSPECT_INSERT_POSITION = {
	none: 0,
	left: 1,
	top: 2,
	right: 3,
	bottom: 4,
	inside: 5
};

// Possible values for ShowInsertHighlight position
// Taken from enum WebSettingsLiveGuidesPosition in WebKit/public/web/DWInspectSettings.h 
var DW_VISUAL_DOM_POSITIONS = {
    NoInput: -1,
	NoGuides: 0,
	Before: 1,
	After: 2,
	Nest: 3
};

var DW_LIVEEDIT_EVENTS = {
    SetElement: "SetElement",
    Destroy: "Destroy",
    Commit: "Commit",
    Draw: "Draw",
    Escape: "Escape",
    POSTEscape: "POSTEscape",
    DoubleClick: "Double Click",
    SingleClick: "Single Click",
    ElementChanged: "ElementChanged", //Trigger this event if any edit operation change display rect of any element.
    EditOpFailed: "EditOpFailed", //Trigger this event when anything like edit operation is canceled and want to ER HUD back.
    EditingText: "EditingText", //Trigger this event to hide all the ER HUDs.
    SaveDocument: "Save Document",
	EnterTextEdit : "EnterTextEdit",
    ViewLostFocus: "View Lost Focus", //Live view has lost focus
    RefreshDocument: "RefreshDocument"
};

//
// Constant values for text editing.
//
var DW_LIVE_TEXT_EDIT = {
    QuatationChar: 34,
    ApostropheChar: 39,
    AmpersandChar: 38,
    LessThanChar: 60,
    GreaterThanChar: 62,
    EntityCodeStart: 161, // ISO 8859-1 Symbols begining code
    Triple_Click_Position_Threshold: 10,
    Triple_Click_Interval_Threshold: 350,
    Triple_Click_Selection_Threshold: 10
};

var DW_LIBRARY_ITEM = {
    Begin: " #BeginLibraryItem ",
    End: " #EndLibraryItem "
};

DW_LIVE_TEXT_EDIT.TagsWhereRunsMaySwap = [
	"UL",
	"OL"
];

DW_LIVE_TEXT_EDIT.WhiteSpaceChars = [
    9, // Tab
    10, // New Line (LF)
    32 // Blank Space
];

DW_LIVE_TEXT_EDIT.TagsNeedsRedraw = [
	"LI",
	"TD",
    "TH",
    "TR"
];

DW_LIVE_TEXT_EDIT.BlockInclusionList = [
    "P",
    "H1",
	"H2",
	"H3",
	"H4",
	"H5",
	"H6",
	"LI",
	"LEGEND",
	"ADDRESS",
	"LABEL"
];

//
// Below tags creates nested p tags as their childs when enter is pressed.
//
// TODO: All the below tags have been removed from BlockInclusionList.
//  So it should be empty array. But leaving this tags wouldn't make any
//  effect in enter key handling. Have to clean up later.
DW_LIVE_TEXT_EDIT.TagsThatCreatesPTagsOnEnter = [
	"BODY",
	"DIV",
	"HEADER",
	"HGROUP",
	"ASIDE",
	"ARTICLE",
	"SECTION",
	"FOOTER",
	"NAV",
	"TR",
    "MAIN"
];

DW_LIVE_TEXT_EDIT.LeaveEnterKeyPressBehaviourToBrowser = [
	"LABEL"
];

DW_LIVE_TEXT_EDIT.InlineTextElements = [
    "STRONG",
    "EM",
    "BR",
    "TIME",
    "B",
    "BIG",
    "I",
    "SMALL",
    "TT",
    "ABBR",
    "ACRONYM",
    "CITE",
    "CODE",
    "DFN",
    "KBD",
    "SAMP",
    "VAR",
    "A",
    "BDO",
    "Q",
    "SPAN",
    "SUB",
    "SUP",
    "FONT",
    "U",
	"INS",
	"DEL",
	"STRIKE",
    "IMG",
	"WBR",
	"S",
	"MARK",
	"BDI",
	"BLACKFACE"
    // Following tags are not included in grouping
    //"BUTTON",
    //"INPUT",
    //"LABEL",
    //"SELECT",
    //"TEXTAREA",
    //"OBJECT",
    //"MAP",
    //"SCRIPT",
];

DW_LIVE_TEXT_EDIT.DynamicTags = [
    "<?php",
    "<%",
    "<cf"
];

DW_LIVE_TEXT_EDIT.DynamicTypes = [
    "php",
    "jsp",
    "cfm",
    "php_mysql",
    "asp"
];

DW_LIVE_TEXT_EDIT.NoFocusOnSandwichIconClickTags = [
    "p",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "pre"
];

//
// List of actions that we do after browser handles enter key press.
//
var ENTER_POST_PROCESSING_ACTIONS = {
	ChangeCurrentNodeContentToNBSP:                0,
	ChangePreviousSiblingContentToNBSP:            1,
	ChangeCurrentNodeToParaAndChangeContentToNBSP: 2,
	CreateNestedPTagsAndInsertThemToOrignalParent: 3
};

DW_LIVE_TEXT_EDIT.Entities = {
    "&quot;" : 34,
    "&apos;" : 39,
    "&pound;" : 163,
    "&yen;"  : 165,
    "&sect;" : 167,
    "&uml;"  : 168,
    "&iexcl;" : 161,
    "&cent;" : 162,
    "&copy;" : 169,
    "&laquo;" : 171,
    "&not;"  : 172,
    "&reg;"  : 174,
    "&deg;"  : 176,
    "&plusmn;" : 177,
    "&acute;" : 180,
    "&micro;" : 181,
    "&para;" : 182,
    "&middot;" : 183,
    "&cedil;": 184,
    "&raquo;": 187,
    "&iquest;": 191,
    "&Agrave;": 192,
    "&Aacute;": 193,
    "&Acirc;": 194,
    "&Atilde;": 195,
    "&Auml;": 196,
    "&Aring;": 197,
    "&AElig;": 198,
    "&Ccedil;": 199,
    "&Egrave;": 200,
    "&Eacute;": 201,
    "&Ecirc;": 202,
    "&Euml;" : 203,
    "&Igrave;" : 204,
    "&Iacute;" : 205,
    "&Icirc;" : 206,
    "&Iuml;" : 207,
    "&Ntilde;" : 209,
    "&Ograve;" : 210,
    "&Oacute;" : 211,
    "&Ocirc;" : 212,
    "&Otilde;" : 213,
    "&Ouml;" : 214,
    "&Oslash;" : 216,
    "&Ugrave;" : 217,
    "&Uacute;" : 218,
    "&Ucirc;" : 219,
    "&Uuml;" : 220,
    "&szlig;" : 223,
    "&agrave;" : 224,
    "&aacute;" : 225,
    "&acirc;" : 226,
    "&atilde;" : 227,
    "&auml;" : 228,
    "&aring;" : 229,
    "&aelig;" : 230,
    "&ccedil;" : 231,
    "&egrave;" : 232,
    "&eacute;" : 233,
    "&ecirc;" : 234,
    "&euml;" : 235,
    "&igrave;" : 236,
    "&iacute;" : 237,
    "&icirc;" : 238,
    "&iuml;" : 239,
    "&ntilde;" : 241,
    "&ograve;" : 242,
    "&oacute;" : 243,
    "&ocirc;" : 244,
    "&otilde;" : 245,
    "&ouml;" : 246,
    "&divide;" : 247,
    "&oslash;" : 248,
    "&ugrave;" : 249,
    "&uacute;" : 250,
    "&ucirc;" : 251,
    "&uuml;" : 252,
    "&yuml;" : 255,
    "&curren;" : 164,
    "&brvbar;" : 166,
    "&ordf;" : 170,
    "&shy;"  : 173,
    "&macr;" : 175,
    "&sup1;" : 185,
    "&sup2;" : 178,
    "&sup3;" : 179,
    "&ordm;" : 186,
    "&frac14;" : 188,
    "&frac12;" : 189,
    "&frac34;" : 190,
    "&times;" : 215,
    "&ETH;"  : 208,
    "&Yacute;" : 221,
    "&THORN;" : 222,
    "&eth;"  : 240,
    "&yacute;" : 253,
    "&thorn;" : 254
};

var DW_EDITABLE_REGION_CONSTS = {
    EditableRegionBegin: " InstanceBeginEditable ",
    EditableRegionEnd: " InstanceEndEditable",
    EditableRegionHudCss: "dw_editableRgnHudDiv",
    EditableRgnOverlayCss: "overlay_editableRgn",
    EditableRgnName: "name"
};

//
// Constants for editable selectors
//
var DW_EDITABLE_SELECTORS_CONSTS = {
    DwSelectorContainerClassName: "selectorsContainer",
    DwSelectorNameClassName: "selector"
};

// Constants for Image and Text HUD
var DW_AUX_HUD_CONSTS = {
    DwInputTypeNoUndo: "CantHandleUndo"
};


var DWLE_FILEPATHS = {
    AppLiveEditPath: "/Shared/LiveEdit",
    UserLiveEditPath: "Shared/LiveEdit",
    LiveViewExtensionsListFile: "/LiveViewExtensions.xml",
    ExtensionsFolder: "/Extensions",
    OverLayCss: "/overlay.css",
    EditableRegionCss: "/TemplateInstanceEditableRgn.css"
};

var RESPONSIVE_FRAMEWORK = {
    "ExtensionId": "ResponsiveLayout",
    "frameworkPath": "/ResponsiveLayout/assets/resource/"
};

/* These strings should match with event strings in LiveEditUpdateUtils.cpp*/
var DW_EVENTS = {
    SelectionChanged: "dw_selection_changed",
    DisableExtensions: "disable_extensions",
    EnableExtensions: "enable_extensions",
    Textedit_selection_change : "textedit_selection_change",
    Textedit_make_bold: "textedit_make_bold",
    TextEdit_make_italic : "textedit_make_italic",
	ShowHelp: "show_help",
    PartialRefreshComplete: "partial_refresh_complete",
    StylesReloaded: "liveview_styles_reloaded",
    LiveResizeEnabled: "live_resize_enabled",
    LiveResizeDisabled: "live_resize_disabled",
    ShowHud : "show_hud_for_IAM"
};

var DW_EVENTS_PARAM = {
    CodeViewEdit: "code_view_edit",
    DragEnter: "live_view_drag_enter"
};

/* Headlight Logging Data for In-Context Text Editing */
var DW_ICE_HEADLIGHTS = {
    ELV_LVE: "ELV LVE",
    DWShortcuts: "DWShortcuts",
    OTH_ELV: "OTH ELV",
    StartEditing: "LVE StartEditing",
    SelectAll: "LVE SelectAll",
    NewTagCreatedViaEnter: "LVE NewTagCreatedViaEnter",
    Canceled: "LVE Canceled",
    TemplateEdited:	"LVE TemplateEdited",
    DynamicPageEdited: "LVE <File Type>Edited",
    TableEdited: "LVE TableEdited",
    CommitFailed: "LVE CommitFailed",
    InlineTagEdited_Pre: "LVE ",
    InlineTagEdited_Post: " TagEdited",
    LibEdited: "LVE LibEdited",
    ToolingToggledInOrangeHUD: "LVE ToolingToggledInOrangeHUD",
    CssElementEdited: "LVE <CSS>ElementEdited",
    RightClickDone: "LVE RightClickDone",
    Commit: "LVE Commit",
    lveFgEdited: "LVE FluidGrid Edited",
    lvePreString: "LVE ",
    lvePostStringDynamic: "Edited Dynamic",
    lvePostStringStatic: "Edited Static",
    lveTableEdited: "LVE TableEdited"
};

var DW_LIVEEDIT_DEBUGGING = false;
