// Copyright 2001-2007 Adobe Systems Incorporated.  All rights reserved.

//---------------     API FUNCTIONS    ---------------

function isDOMRequired() { 
	// Return false, indicating that this object is available in code view.
	return false;
}

function isAsset() {
	return true;
}

function objectTag(assetArgs) {
	var rtnStr="";

	var prefixScriptStr = "";
	var postScriptStr = "";

	if (dwscripts.isXSLTDoc())
	{
		//add CDATA to pre , post parts
		prefixScriptStr = "<![CDATA[\n";
		postScriptStr = "]]>\n";
	}

  // If we're an asset tag, then just set the src of the script tag
  // to the parameter passed in and return
  if (assetArgs)
  {
    var	dotIndex = assetArgs.lastIndexOf('.');
    var ext;
    if (dotIndex != -1)
    {
  	ext = assetArgs.substr(dotIndex+1);
  	ext = ext.toLowerCase();
    }
    if (ext && ext == "js")
      rtnStr = '<script type="text/javascript" src="' + assetArgs + '">' + prefixScriptStr + postScriptStr + '<\/script>';
    else
      rtnStr = '<script src="' + assetArgs + '">' + prefixScriptStr +  postScriptStr + '<\/script>'; 
  }
  else
  {
	var script_src = dw.browseForFileURL();

	if(script_src != '')
	{
		rtnStr = '<script type="text/javascript" src="' + script_src + '">' + prefixScriptStr + postScriptStr + '<\/script>';
	}
		
  }

  return rtnStr;
}
