/*	
 Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/
// JavaScript Document

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global document, dwBridge, UI_HTML_CONSTANTS, curNddOptions, DW_NDD_CONSTANTS, LABEL_CONSTANTS, getLocalizedString, dwLog,
MouseEvent, containerWidth, containerHeight*/

//global vars
var m_attachCssListArray;
var m_dtdComboValues;
var m_defaultBootstrapVersion = 4;

var uiSelectionState =
	{	layoutType: "none", // or "bootstrap"
        layoutVersion: m_defaultBootstrapVersion,
		title: "",
		docType: DW_NDD_CONSTANTS.DocTypeDefault,
		breakPointsType : DW_NDD_CONSTANTS.BuildNewBootstrap,
		screenSm : DW_NDD_CONSTANTS.ScreenSmDefault, // default small-min
        screenMd : DW_NDD_CONSTANTS.ScreenMdDefault, // default medium-min
        screenLg : DW_NDD_CONSTANTS.ScreenLgDefault, // default large-min
        screenXl : DW_NDD_CONSTANTS.ScreenXlDefault, // default large-min
		numberOfCol : DW_NDD_CONSTANTS.NumberOfColDefault, // default number of coloumns
		gutterWidth : DW_NDD_CONSTANTS.GutterWidthDefault, // default gutter width
		includePreBuilt : true,
		existingCSS : "",
		uploadPSD : false
		};

/*
Utility function to string middle trunction
*/
function truncateStringMiddle(str, maxLen) {
	'use strict';
	if (!str) {
		return str;
	}

	if (str.length <= maxLen || maxLen < 5) {
		return str;
	}

	var subLen = Math.ceil((maxLen - 3) / 2);
	var rightIndex = str.length - subLen;
	return str.substring(0, subLen) + '...' + str.substring(rightIndex, rightIndex + subLen);
}

/*
To open a help url from dw
*/
function openHelpPage() {
    "use strict";
    if (dwBridge) {
        dwBridge.openDWHelpPage(DW_NDD_CONSTANTS.BootstrapHelpUrl);
    }
}

/*
To open a help url from dw
*/
function openKBArticle() {
	"use strict";
    if (dwBridge) {
        dwBridge.openDWHelpPage(DW_NDD_CONSTANTS.BootstrapKBArticleUrl);
    }
}

/*
Hide bar error message
*/
function hideBarErrorMessage() {
	"use strict";
	var msgElm = document.getElementById('msgBox');
	if (!msgElm) {
		return;
	}

	msgElm.style.display = "none";
	window.removeEventListener("mouseup", hideBarErrorMessage);
}

/*
Set Bar Error message
*/
function showBarErrorMessage(msg) {
	"use strict";
	var msgElm = document.getElementById('msgBox');
    var msgHolder = document.getElementById('boostrapErrorContent');
	if (!msgElm || !msgHolder) {
		return;
	}

	var tabWidth =  containerWidth,
		tabContent = document.getElementById('tabscontent'),
        button = document.getElementById('showAdvanceSettingsText'),
        msgLeft = 0,
        msgTop = 0;
	if (tabContent && button) {
		tabWidth = tabContent.offsetWidth;
        msgLeft = tabContent.offsetLeft;
        msgTop = button.getBoundingClientRect().top;
	}

	msgHolder.innerHTML = msg;
	msgElm.style.display = "table";
	msgElm.style.left = msgLeft + 'px';
	msgElm.style.top = msgTop + 'px';
	msgElm.style.width = tabWidth + 'px';

	var kblink = document.getElementById("kblink");
	if (kblink) {
		kblink.addEventListener("click", openKBArticle, false);
	}

	window.addEventListener("mouseup", hideBarErrorMessage, false);
}

/*
Set Error message
*/
function setErrorMessage(msg, element) {
	"use strict";
	if (element) {
		element.setAttribute('invalid', "");
		element.title =  msg;
		element.focus();
	}
}

/*
Reset error message
*/
function resetErrorMessage(element) {
	"use strict";
	if (element) {
		element.removeAttribute('invalid');
		element.title =  "";
	}
}

/*
Set Existing CSS Path
*/
function setExistingCSSPath(path) {
	'use strict';
	if (!path) {
		return;
	}
	var trunPath = truncateStringMiddle(path, 29),
		elem = document.getElementById(UI_HTML_CONSTANTS.existingBootstrap);
	elem.checked = true;
	elem = document.getElementById(UI_HTML_CONSTANTS.bootstrapPath);
	elem.value = trunPath;
	elem.setAttribute('title', path);
	uiSelectionState.existingCSS = path;
	uiSelectionState.breakPointsType = DW_NDD_CONSTANTS.UseExistingBootstrap;
}

/*
Utility function to browse for bootstrap*.css file.
*/
function browseForBootstrapCSS() {
	'use strict';
	var argObj = {};
    if (curNddOptions && !curNddOptions.isWinOS) {
        argObj.filter = DW_NDD_CONSTANTS.FILTER_MAC;
    } else {
        argObj.filter = DW_NDD_CONSTANTS.FILTER;
    }
	argObj.operation = "select_forceAbsolutePath";
	argObj.subOp = getLocalizedString("Select_bootstrap_CSS");
	argObj.callback = setExistingCSSPath;
	dwBridge.browseForFileURL(argObj);
}

/*
Sets the title in uiSelectionState when title is changed
*/
function setTitle() {
    "use strict";
    var titleElem = document.getElementById(UI_HTML_CONSTANTS.titleId);
    uiSelectionState.title = titleElem.value;
}

/*
Sets the selected doctype when it is changed through dtd combobox
*/
function dtdChanged() {
	"use strict";
	var dtdelem = document.getElementById(UI_HTML_CONSTANTS.dtdId);
    var selItem = dtdelem.value;
	var i, index = 0;
    for (i = 0; i < m_dtdComboValues.length; ++i) {
        if (selItem === m_dtdComboValues[i]) {
			index = i;
			break;
		}
    }
	uiSelectionState.docType = index;
}

function updateCustomOptions(bsVersion)
{
    "use strict";
    var version = m_defaultBootstrapVersion;
    if(bsVersion != undefined)
    {
        var tmp = parseInt(bsVersion);
        if(!isNaN(tmp))
        version = tmp;
    }

    var smScreen = document.getElementById(UI_HTML_CONSTANTS.screenSmall);
    var mdScreen = document.getElementById(UI_HTML_CONSTANTS.screenMedium);
    var lScreen = document.getElementById(UI_HTML_CONSTANTS.screenLarge);
    var xlScreen = document.getElementById(UI_HTML_CONSTANTS.screenExtraLarge);
    var xlScreenrow = document.getElementById(UI_HTML_CONSTANTS.xlScreen);
    var xlScreenLabel = document.getElementById(LABEL_CONSTANTS.extraLargeLabel);
    var xlScreenLinked1 = document.getElementById(UI_HTML_CONSTANTS.xlScreenLinked1);
    var xlScreenLinked2 = document.getElementById(UI_HTML_CONSTANTS.xlScreenLinked2);
    if(BootstrapData && BootstrapData.ScreenBreakpointDefaults && BootstrapData.ScreenBreakpointDefaults.length > version)
    {
        uiSelectionState.screenSm = smScreen.value = BootstrapData.ScreenBreakpointDefaults[version].ScreenSmDefault;
        uiSelectionState.screenMd = mdScreen.value = BootstrapData.ScreenBreakpointDefaults[version].ScreenMdDefault;
        uiSelectionState.screenLg = lScreen.value = BootstrapData.ScreenBreakpointDefaults[version].ScreenLgDefault;
        uiSelectionState.screenXl = xlScreen.value = BootstrapData.ScreenBreakpointDefaults[version].ScreenXlDefault;
    }
    //uiSelectionState.screenXl undefined means we are in bootstrap version 3.x.x
    var display = uiSelectionState.screenXl?"table-cell":"none";
    xlScreenrow.style.display = xlScreenLabel.style.display = display; 
    xlScreenLinked1.style.display = xlScreenLinked2.style.display = display;
}

/*
Called when None tab is selected
*/
function noneSelected() {
    "use strict";
	uiSelectionState.layoutType = "none";

    var bootstrapHelpLinkElem = document.getElementById(UI_HTML_CONSTANTS.bootstrapHelpLink);
    if (bootstrapHelpLinkElem) {
        bootstrapHelpLinkElem.style.display = "none";
    }
}

/*
Called when 'Bootstrap' tab is selected
*/
function bootstrapSelected() {
    "use strict";
	uiSelectionState.layoutType = "bootstrap";

    var bootstrapHelpLinkElem = document.getElementById(UI_HTML_CONSTANTS.bootstrapHelpLink);
    if (bootstrapHelpLinkElem) {
        bootstrapHelpLinkElem.style.display = "inline";
    }
}

/*
Populates the dtd combobox with dtdCombpValues
params:
    dtdComboValues : Array of docType names
*/
function populateDtdComboBox(dtdObj) {
    "use strict";
    if (dtdObj) {
        var dtdComboValues = dtdObj.dtdItemsArray;
        var dtdCombo = document.getElementById(UI_HTML_CONSTANTS.dtdId);
        var selIndex = (dtdObj.dtdSelectedIndex === -1) ? uiSelectionState.docType : dtdObj.dtdSelectedIndex;
        
        dtdCombo.items.clear();
        
        var i;
        for (i = 0; i < dtdComboValues.length; ++i) {
            var selected = (i == selIndex);
            dtdCombo.items.add({
              content: {
                innerHTML: dtdComboValues[i]
              },
              value: dtdComboValues[i],
              selected : selected
            });
        }

        m_dtdComboValues = dtdComboValues;
        uiSelectionState.docType = selIndex;
    }
}

/*
Utility function to string start trunction
*/
function truncateStringStart(str, maxLen) {
    "use strict";
    if (!str) {
		return str;
	}

	if (str.length <= maxLen || maxLen < 5) {
		return str;
	}

    var strTemp;
    var ellipses = "...";
    if (str.substring(0, 3) === ellipses) {
        strTemp = str.substring(3, str.length);
    } else {
        strTemp = str;
    }

    var numOfCharsToRemove = ellipses.length + str.length - maxLen;
    return ellipses + str.substring(numOfCharsToRemove, str.length);
}

/*
Function to enable delete button
arg: button to be enabled
*/
function enableDeleteButton(deleteBtnElem) {
    "use strict";
    deleteBtnElem.disabled = false;
    deleteBtnElem.classList.remove("deleteIconDisabled");
    deleteBtnElem.classList.add("deleteIconEnabled");
}

/*
Function to disable delete button
arg: button to be disabled
*/
function disableDeleteButton(deleteBtnElem) {
    "use strict";
    deleteBtnElem.disabled = true;
    deleteBtnElem.classList.remove("deleteIconEnabled");
    deleteBtnElem.classList.add("deleteIconDisabled");
}

function refreshAttachCssListIn(attachCssListObj, elemId) {
    "use strict";
    var elem = document.getElementById(elemId);
    var i;
    if (elem && elem.items) {
        if (attachCssListObj) {
            var attachCssListValues = attachCssListObj.attachCssItems;
            var attachCssListTooltips = attachCssListObj.attachCssItemsTooltip;

            elem.items.clear();

            for (i = 0; i < attachCssListValues.length; ++i) {
                var maxLen = (curNddOptions && !curNddOptions.isWinOS) ? DW_NDD_CONSTANTS.AttachCssMaxLenMac : DW_NDD_CONSTANTS.AttachCssMaxLenWin;
                elem.items.add({
                    content: {
                        innerHTML: truncateStringStart(attachCssListValues[i], maxLen)
                    },
                    value: truncateStringStart(attachCssListValues[i], maxLen),
                    title: attachCssListTooltips[i]
                });
            }
            
            if (attachCssListValues.length === 0) {
                var deleteBtnNone = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveId);
                var deleteBtnBS = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveBootstrap);
                disableDeleteButton(deleteBtnNone);
                disableDeleteButton(deleteBtnBS);
            }
        }
    }
}

/*
Function to refresh the attachCssList with attachCssListValues
params:
    attachCssListValues : Array of CSS filenames
*/
function refreshAttachCssList(attachCssListObj) {
    "use strict";
    refreshAttachCssListIn(attachCssListObj, UI_HTML_CONSTANTS.attachCssListId);
    refreshAttachCssListIn(attachCssListObj, UI_HTML_CONSTANTS.attachCssListBootstrap);
}

/*
Calls the bridging function getDWAttachCssListItems to get list of CSS filenames attached
*/
function getAttachCssList() {
    "use strict";
    if (dwBridge) {
        var argObject;
        argObject = {};
        argObject.callback = refreshAttachCssList;
        dwBridge.getDWAttachCssListItems(argObject);
    }
}

/*
On click of add Css button, this function is called
*/
function onAttachCssAddClick() {
    "use strict";
    if (dwBridge) {
        var argObject;
        argObject = {};
        argObject.callback = getAttachCssList;
        dwBridge.onDWCssAddBtnClick(argObject);
    }
}

/*
Function to be called when an item in attachCssList is clicked
*/
function onAttachCssListSelect(event, otherListBoxId) {
    "use strict";
    var attachCssListBox = event.currentTarget;
    var otherListBox = document.getElementById(otherListBoxId);
    if (attachCssListBox && otherListBox) {
        var numOfCssFiles = attachCssListBox.items.length;
        var options = attachCssListBox.items.getAll(), otherListOptions = otherListBox.items.getAll(), count = 0, i, selectedOptionsArray = [];
        
        for (i = 0; i < options.length; i++) {
            if (options[i].selected) {
                selectedOptionsArray.push(i);
                count++;
                otherListOptions[i].selected = true;
            } else {
                otherListOptions[i].selected = false;
            }
        }
        
        if (dwBridge) {
            dwBridge.onDWCssListSelect(selectedOptionsArray);
        }

        var deleteBtnNone = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveId);
        var deleteBtnBS = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveBootstrap);
        if (count > 0) {
            enableDeleteButton(deleteBtnNone);
            enableDeleteButton(deleteBtnBS);
        } else {
            disableDeleteButton(deleteBtnNone);
            disableDeleteButton(deleteBtnBS);
        }
    }
}

/*
Function to be called when an item in attachCssList of none tab is clicked
*/
function onAttachCssListNoneSelect(event) {
    "use strict";
    //handle either click or keys arrowUp(keyCode=38) and arrowDown(keyCode=40)
    if (event.type === "click" || event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        onAttachCssListSelect(event, UI_HTML_CONSTANTS.attachCssListBootstrap);
    }
}

/*
Function to be called when an item in attachCssList of bootstrap tab is clicked
*/
function onAttachCssListBootstrapSelect(event) {
    "use strict";
    //handle either click or keys arrowUp(keyCode=38) and arrowDown(keyCode=40)
    if (event.type === "click" || event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        onAttachCssListSelect(event, UI_HTML_CONSTANTS.attachCssListId);
    }
}

/*
On clicking remove Css button, this function is called.
*/
function onAttachCssRemoveClick() {
    "use strict";
    if (dwBridge) {
        var argObject;
        argObject = {};
        argObject.callback = getAttachCssList;
        dwBridge.onDWCssRemoveBtnClick(argObject);
    }
}

function showHide() {
    "use strict";
    var elem = document.getElementById(UI_HTML_CONSTANTS.advanceSettingsContent);
    if (elem) {
        var customizeTextDescElem = document.getElementById(UI_HTML_CONSTANTS.customizeTextDesc);

        if (elem.style.display === "table") {
            elem.style.display = "none";

            elem = document.getElementById(LABEL_CONSTANTS.screenLabel);
            if (elem) {
                elem.style.display = "none";
            }

            elem = document.getElementById(LABEL_CONSTANTS.gridLabel);
            if (elem) {
                elem.style.display = "none";
            }

            elem = document.getElementById(UI_HTML_CONSTANTS.customizeText);
            if (elem) {
                elem.classList.remove("hideLink");
                elem.classList.add("showLink");
            }

            if (customizeTextDescElem) {
                customizeTextDescElem.style.display = "table-row";
            }
        } else {
            elem.style.display = "table";

            elem = document.getElementById(LABEL_CONSTANTS.screenLabel);
            if (elem) {
                elem.style.display = "table-cell";
            }

            elem = document.getElementById(LABEL_CONSTANTS.gridLabel);
            if (elem) {
                elem.style.display = "table-cell";
            }

            elem = document.getElementById(UI_HTML_CONSTANTS.customizeText);
            if (elem) {
                elem.classList.remove("showLink");
                elem.classList.add("hideLink");
            }

            if (customizeTextDescElem) {
                customizeTextDescElem.style.display = "none";
            }
            updateCustomOptions(uiSelectionState.layoutVersion);
        }
    }
}
function validateNumOfColumns(val) {
    "use strict";
    if (!isNaN(val) && isFinite(val)) {
        var minVal = BootstrapData.NumberOfColMin;
        var maxVal = BootstrapData.NumberOfColMax;
        if (val >= minVal && val <= maxVal) {
            return true;
        }
    }

    return false;
}

function validateGutterWidth(val) {
    "use strict";
    if (!isNaN(val) && isFinite(val)) {
        var minVal = BootstrapData.GutterWidthMin;
        var maxVal = BootstrapData.GutterWidthMax;
        if (val >= minVal && val <= maxVal) {
            return true;
        }
    }

    return false;
}

function validateScreenSmall(val) {
    "use strict";
    var mediumVal = 0;

    var screenMediumInput = document.getElementById(UI_HTML_CONSTANTS.screenMedium);
    if (screenMediumInput) {
        mediumVal = screenMediumInput.value;
    }

    if (!isNaN(val) && isFinite(val) && (val < mediumVal)) {
        return true;
    }

    return false;
}

function validateScreenMedium(val) {
    "use strict";
    var smallVal = 0, largeVal = 0;

    var screenSmallInput = document.getElementById(UI_HTML_CONSTANTS.screenSmall);
    if (screenSmallInput) {
        smallVal = screenSmallInput.value;
    }

    var screenLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenLarge);
    if (screenLargeInput) {
        largeVal = screenLargeInput.value;
    }

    if (!isNaN(val) && isFinite(val) && val > smallVal && val < largeVal) {
        return true;
    }

    return false;
}

function validateScreenLarge(val) {
    "use strict";
    var mediumVal = 0, xLargeVal = DW_NDD_CONSTANTS.ScreenXlDefault;

    var screenMediumInput = document.getElementById(UI_HTML_CONSTANTS.screenMedium);
    if (screenMediumInput) {
        mediumVal = screenMediumInput.value;
    }

    var xlScreenrow = document.getElementById(UI_HTML_CONSTANTS.xlScreen);
    if(xlScreenrow && xlScreenrow.style.display === "none")
    {
        if (!isNaN(val) && isFinite(val) && val > mediumVal) {
            return true;
        }
    }
    else
    {
        var screenXLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenExtraLarge);

        if (screenXLargeInput) {
            xLargeVal = screenXLargeInput.value;
        }
        if (!isNaN(val) && isFinite(val) && val > mediumVal && val < xLargeVal) {
            return true;
        }
    }

    return false;
}

function validateScreenExtraLarge(val) {
    "use strict";
    var largeVal = 0;

    var screenLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenLarge);
    if (screenLargeInput) {
        largeVal = screenLargeInput.value;
    }

    if (!isNaN(val) && isFinite(val) && val > largeVal) {
        return true;
    }

    return false;
}

function numOfColumnEdited(event) {
    "use strict";
    var numOfColmn = document.getElementById(UI_HTML_CONSTANTS.noOfColumn);
    if (numOfColmn) {
        var val = Number(numOfColmn.value);
        if (validateNumOfColumns(val)) {
            uiSelectionState.numberOfCol = val;
			resetErrorMessage(numOfColmn);
        } else {
			// reset values only on blur (keyCode === 0)
			if (event && event.keyCode === 0) {
				numOfColmn.value = uiSelectionState.numberOfCol;
			}
			var msg = getLocalizedString("Value_out_of_range");
			msg = msg.replace("%1", BootstrapData.NumberOfColMin);
			msg = msg.replace("%2", BootstrapData.NumberOfColMax);
			setErrorMessage(msg, numOfColmn);
        }
    }
}

function gutterWidthEdited(event) {
    "use strict";
    var gutterWidth = document.getElementById(UI_HTML_CONSTANTS.gutterWidth);
    if (gutterWidth) {
        var val = Number(gutterWidth.value);
        if (validateGutterWidth(val)) {
            uiSelectionState.gutterWidth = val;
			resetErrorMessage(gutterWidth);
        } else {
			// reset values only on blur (keyCode === 0)
			if (event && event.keyCode === 0) {
				gutterWidth.value = uiSelectionState.gutterWidth;
			}
			var msg = getLocalizedString("Value_out_of_range");
			msg = msg.replace("%1", BootstrapData.GutterWidthMin);
			msg = msg.replace("%2", BootstrapData.GutterWidthMax);
			setErrorMessage(msg, gutterWidth);
        }
    }
}

function screenSmallEdited(event) {
    "use strict";
    var screenSmallInput = document.getElementById(UI_HTML_CONSTANTS.screenSmall);
    if (screenSmallInput) {
        var val = Number(screenSmallInput.value);
        if (validateScreenSmall(val)) {
            uiSelectionState.screenSm = val;
            resetErrorMessage(screenSmallInput);
        } else {
            // reset values only on blur (keyCode === 0)
            if (event && event.keyCode === 0) {
                screenSmallInput.value = uiSelectionState.screenSm;
            }
            setErrorMessage(getLocalizedString("Small_screen_value_error"), screenSmallInput);
        }
    }
}

function screenMediumEdited(event) {
    "use strict";
    var screenMediumInput = document.getElementById(UI_HTML_CONSTANTS.screenMedium);
    if (screenMediumInput) {
        var val = Number(screenMediumInput.value);
        if (validateScreenMedium(val)) {
            uiSelectionState.screenMd = val;
			resetErrorMessage(screenMediumInput);
        } else {
			// reset values only on blur (keyCode === 0)
			if (event && event.keyCode === 0) {
				screenMediumInput.value = uiSelectionState.screenMd;
			}
			setErrorMessage(getLocalizedString("Medium_screen_value_error"), screenMediumInput);
        }
    }
}

function screenLargeEdited(event) {
    "use strict";
    var screenLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenLarge);
    if (screenLargeInput) {
        var val = Number(screenLargeInput.value);
        if (validateScreenLarge(val)) {
            uiSelectionState.screenLg = val;
			resetErrorMessage(screenLargeInput);
        } else {
			// reset values only on blur (keyCode === 0)
			if (event && event.keyCode === 0) {
				screenLargeInput.value = uiSelectionState.screenLg;
			}
			setErrorMessage(getLocalizedString("Large_screen_value_error"), screenLargeInput);
        }
    }
}

function screenExtraLargeEdited(event) {
    "use strict";
    var screenXLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenExtraLarge);
    if (screenXLargeInput) {
        var val = Number(screenXLargeInput.value);
        if (validateScreenExtraLarge(val)) {
            uiSelectionState.screenXl = val;
            resetErrorMessage(screenXLargeInput);
        } else {
            // reset values only on blur (keyCode === 0)
            if (event && event.keyCode === 0) {
                screenXLargeInput.value = uiSelectionState.screenXl;
            }
            setErrorMessage(getLocalizedString("Large_screen_value_error"), screenXLargeInput);
        }
    }
}

function generateBootStrapSelected() {
    "use strict";
    if (uiSelectionState.breakPointsType === DW_NDD_CONSTANTS.BuildNewBootstrap) {
        return;
    }

    var elem;
    elem = document.getElementById(UI_HTML_CONSTANTS.customizeText);
    if (elem) {
        elem.classList.remove("hideLink");
        elem.classList.add("showLink");
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.showAdvanceSettingsText);
    if (elem) {
        elem.style.display = "table-row";
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.customizeTextDesc);
    if (elem) {
        elem.style.display = "table-row";
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.useExistingBox);
    if (elem) {
        elem.style.display = "none";
    }
    uiSelectionState.breakPointsType = DW_NDD_CONSTANTS.BuildNewBootstrap;
}


function existingBootStrapSelected() {
    "use strict";
    var elem;
    elem = document.getElementById(UI_HTML_CONSTANTS.showAdvanceSettingsText);
    if (elem) {
        elem.style.display = "none";
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.customizeTextDesc);
    if (elem) {
        elem.style.display = "none";
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.advanceSettingsContent);
    if (elem) {
        elem.style.display = "none";
    }

    elem = document.getElementById(LABEL_CONSTANTS.screenLabel);
    if (elem) {
        elem.style.display = "none";
    }

    elem = document.getElementById(LABEL_CONSTANTS.gridLabel);
    if (elem) {
        elem.style.display = "none";
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.useExistingBox);
    if (elem) {
        elem.style.display = "table-row";
    }

    uiSelectionState.breakPointsType = DW_NDD_CONSTANTS.UseExistingBootstrap;
}

function onbrowseBootstrapCssKeyup(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        browseForBootstrapCSS();
    }
}

function onAttachCssAddKeyup(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        onAttachCssAddClick();
    }
}

function onAttachCssRemoveKeyup(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        onAttachCssRemoveClick();
    }
}

/*
Function to check/uncheck the state of a checkbox
*/
function onCheckBoxPress(event) {
    "use strict";
    event.target.checked = !event.target.checked;
}

/*
Function to handle keydown on extract checkbox
*/
function onExtractCBKeydown(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.TabKeyCode && !event.shiftKey) {
        //Check if tab is pressed and if yes, set the focus back to one of controls in NDD
        if (dwBridge) {
            dwBridge.setFocusToNddControl();
        }
    }
}

/*
Function to handle keyup on extract checkbox
*/
function onExtractCBKeyup(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        //bug 3988070 : On Mac: check/uncheck the checkbox through 'Spacebar' doesn't work
        onCheckBoxPress(event);
    }
}

/*
Function to handle keydown on prebuiltLayout
*/
function onPrebuiltLayoutKeyup(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        //bug 3988070 : On Mac: check/uncheck the checkbox through 'Spacebar' doesn't work
        onCheckBoxPress(event);
    }
}

/*
Function to handle 'Spacebar' keypress on customize
*/
function onCustomizePress(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.SpacebarKeyCode) {
        showHide();
    }
}

/*
Function to handle keydown on first control in each tab in browserview
*/
function onFirstControlKeyDown(event) {
    "use strict";
    if (event.keyCode === DW_NDD_CONSTANTS.TabKeyCode && event.shiftKey) {
        //if shift tab is pressed, set the focus back to one of controls in NDD
        if (dwBridge) {
            dwBridge.setFocusToHtmlSubCategory();
        }
    }
}

/*
Function to attach eventListners to different controls
*/
function attachEventListeners() {
    "use strict";
    
    var tabs = document.getElementById("tabView");
    if(tabs) {
        tabs.addEventListener("coral-tabview:change", displayPage);
    }
    
    var isMac = (curNddOptions && !curNddOptions.isWinOS);
    var attachCssAddBtn = document.getElementById(UI_HTML_CONSTANTS.attachCssAddId);
    if (attachCssAddBtn) {
        attachCssAddBtn.addEventListener("click", onAttachCssAddClick);
        attachCssAddBtn.addEventListener("keyup", onAttachCssAddKeyup);
    }

    var attachCssListBox = document.getElementById(UI_HTML_CONSTANTS.attachCssListId);
    if (attachCssListBox) {
        attachCssListBox.addEventListener("click", onAttachCssListNoneSelect);
        attachCssListBox.addEventListener("keyup", onAttachCssListNoneSelect);
    }

    var attachCssRemoveBtn = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveId);
    if (attachCssRemoveBtn) {
        attachCssRemoveBtn.addEventListener("click", onAttachCssRemoveClick);
        attachCssRemoveBtn.addEventListener("keyup", onAttachCssRemoveKeyup);
    }

    var attachCssAddBootstrap = document.getElementById(UI_HTML_CONSTANTS.attachCssAddBootstrap);
    if (attachCssAddBootstrap) {
        attachCssAddBootstrap.addEventListener("click", onAttachCssAddClick);
        attachCssAddBootstrap.addEventListener("keyup", onAttachCssAddKeyup);
    }

    var attachCssRemoveBootstrap = document.getElementById(UI_HTML_CONSTANTS.attachCssRemoveBootstrap);
    if (attachCssRemoveBootstrap) {
        attachCssRemoveBootstrap.addEventListener("click", onAttachCssRemoveClick);
        attachCssRemoveBootstrap.addEventListener("keyup", onAttachCssRemoveKeyup);
    }

    var attachCssListBootstrap = document.getElementById(UI_HTML_CONSTANTS.attachCssListBootstrap);
    if (attachCssListBootstrap) {
        attachCssListBootstrap.addEventListener("click", onAttachCssListBootstrapSelect);
        attachCssListBootstrap.addEventListener("keyup", onAttachCssListBootstrapSelect);
    }

    var titleInput = document.getElementById(UI_HTML_CONSTANTS.titleId);
    if (titleInput) {
        if (isMac) {
            titleInput.addEventListener("keyup", setTitle);
        } else {
            titleInput.addEventListener("blur", setTitle);
        }
        titleInput.addEventListener("keydown", onFirstControlKeyDown);
    }

    var dtdelem = document.getElementById(UI_HTML_CONSTANTS.dtdId);
    if (dtdelem) {
		dtdelem.addEventListener("change", dtdChanged);
    }

    var generateBootStrapElem = document.getElementById(UI_HTML_CONSTANTS.generateBootstrap);
    if (generateBootStrapElem) {
        generateBootStrapElem.addEventListener("click", generateBootStrapSelected);
        generateBootStrapElem.addEventListener("keydown", onFirstControlKeyDown);
    }

    var existingBootStrapElem = document.getElementById(UI_HTML_CONSTANTS.existingBootstrap);
    if (existingBootStrapElem) {
        existingBootStrapElem.addEventListener("click", existingBootStrapSelected);
        existingBootStrapElem.addEventListener("keydown", onFirstControlKeyDown);
    }

	var elem = document.getElementById(UI_HTML_CONSTANTS.dwBootCSSSrcBtn);
    if (elem) {
        elem.addEventListener("click", browseForBootstrapCSS);
        elem.addEventListener("keyup", onbrowseBootstrapCssKeyup);
    }
    
    if (isMac) {
        elem = document.getElementById(UI_HTML_CONSTANTS.prebuiltLayout);
        if (elem) {
            elem.addEventListener("keyup", onPrebuiltLayoutKeyup);
        }
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.customizeText);
    if (elem) {
        elem.addEventListener("keyup", onCustomizePress);
    }
    
    elem = document.getElementById(UI_HTML_CONSTANTS.customizeTextDesc);
    if (elem) {
        elem.addEventListener("keyup", onCustomizePress);
    }

    var numOfColmn = document.getElementById(UI_HTML_CONSTANTS.noOfColumn);
    if (numOfColmn) {
		numOfColmn.addEventListener("blur", numOfColumnEdited);
		numOfColmn.addEventListener("keyup", numOfColumnEdited);
    }

    var gutterWidth = document.getElementById(UI_HTML_CONSTANTS.gutterWidth);
    if (gutterWidth) {
		gutterWidth.addEventListener("blur", gutterWidthEdited);
		gutterWidth.addEventListener("keyup", gutterWidthEdited);
    }

    var screenSmallInput = document.getElementById(UI_HTML_CONSTANTS.screenSmall);
    if (screenSmallInput) {
		screenSmallInput.addEventListener("blur", screenSmallEdited);
		screenSmallInput.addEventListener("keyup", screenSmallEdited);
    }

    var screenMediumInput = document.getElementById(UI_HTML_CONSTANTS.screenMedium);
    if (screenMediumInput) {
		screenMediumInput.addEventListener("blur", screenMediumEdited);
		screenMediumInput.addEventListener("keyup", screenMediumEdited);
    }

    var screenLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenLarge);
    if (screenLargeInput) {
		screenLargeInput.addEventListener("blur", screenLargeEdited);
		screenLargeInput.addEventListener("keyup", screenLargeEdited);
    }
    
    var screenXLargeInput = document.getElementById(UI_HTML_CONSTANTS.screenExtraLarge);
    if (screenXLargeInput) {
        screenXLargeInput.addEventListener("blur", screenExtraLargeEdited);
        screenXLargeInput.addEventListener("keyup", screenExtraLargeEdited);
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.extractCBNone);
    if (elem) {
        elem.addEventListener("keydown", onExtractCBKeydown);
        if (isMac) {
            elem.addEventListener("keyup", onExtractCBKeyup);
        }
    }
    
    elem = document.getElementById(UI_HTML_CONSTANTS.extractCBBootstrap);
    if (elem) {
        elem.addEventListener("keydown", onExtractCBKeydown);
        if (isMac) {
            elem.addEventListener("keyup", onExtractCBKeyup);
        }
    }
}

/*
Function to get uiSelectionState which contains info about the different controls needed to create new document
*/
function getSelectedNewDocPreference() {
	"use strict";
    var elem;
    if (uiSelectionState.layoutType === "none") {
        elem = document.getElementById(UI_HTML_CONSTANTS.extractCBNone);
    } else {
        elem = document.getElementById(UI_HTML_CONSTANTS.extractCBBootstrap);
        uiSelectionState.docType = DW_NDD_CONSTANTS.DocTypeDefault;
    }
    if (elem && elem.checked) {
        uiSelectionState.uploadPSD = true;
    }

    elem = document.getElementById(UI_HTML_CONSTANTS.prebuiltLayout);
    if (elem) {
        uiSelectionState.includePreBuilt = elem.checked;
    }

	if (dwLog) {
		dwLog(JSON.stringify(uiSelectionState));
	}
	return uiSelectionState;
}

function setBootstrapVersion(majorVersion)
{
    if(majorVersion != undefined)
    {
        var tmp = parseInt(majorVersion);
        if(!isNaN(tmp))
        uiSelectionState.layoutVersion = tmp;
    }
}
/*
Function to select bootstrap tab (dispatching a click event to select that tab)
*/
function selectBootstrapTab() {
    "use strict";
    var bootstrapTab = document.getElementById(UI_HTML_CONSTANTS.bootStrapTabId);

    if (bootstrapTab) {
        var event = new MouseEvent('click', {
                'view': window,
                'bubbles': true,
                'cancelable': true
            });
        bootstrapTab.dispatchEvent(event);
    }
}

function setFocusToLastControlInBrowser() {
    "use strict";
    var elem;
    if (uiSelectionState.layoutType === "none") {
        elem = document.getElementById(UI_HTML_CONSTANTS.extractCBNone);
    } else {
        elem = document.getElementById(UI_HTML_CONSTANTS.extractCBBootstrap);
    }
    
    if (elem) {
        elem.focus();
    }
}

function initBootstrapControls() {
	"use strict";
	if (!curNddOptions) {
		return;
	}
	if (curNddOptions.bootstrapInUse) {
		setExistingCSSPath(curNddOptions.bootstrapInUse);
        existingBootStrapSelected();
	} else {
		document.getElementById(UI_HTML_CONSTANTS.generateBootstrap).checked = true;
	}

    if(curNddOptions.getActiveBootstrapVersion != undefined )
    {
        var ver = parseInt(curNddOptions.getActiveBootstrapVersion);
        if(!isNaN(ver))
            uiSelectionState.layoutVersion = ver;
    }

    updateCustomOptions(uiSelectionState.layoutVersion);

    var elem = document.getElementById(UI_HTML_CONSTANTS.prebuiltLayout);
    if (elem) {
        if (curNddOptions.bIncludePrebuiltLayout) {
            elem.checked = true;
        } else {
            elem.checked = false;
        }
    }
}

/*
* Function to set placeholder text for different controls in UI
*/
function addHintTextForControls() {
    "use strict";
    var elem = document.getElementById(UI_HTML_CONSTANTS.titleId);
    if (elem) {
        elem.placeholder = getLocalizedString("Title_hint_text");
    }
    
    //set placeholder text for bootstrap path input box
    elem = document.getElementById(UI_HTML_CONSTANTS.bootstrapPath);
    if (elem) {
        elem.placeholder = getLocalizedString("Bootstrap_browse_hint_text");
    }
}

/*
* Sets the localized label for an element
*/
function setLabelForElement(elemId, stringId) {
    "use strict";
    var elem = document.getElementById(elemId);
    if (elem) {
        elem.innerHTML = getLocalizedString(stringId);
    }
}

/*
* Function to add all the labels used in UI
*/
function addLabels() {
    "use strict";
    setLabelForElement(UI_HTML_CONSTANTS.htmlNoneTabId, "None");
    setLabelForElement(LABEL_CONSTANTS.bootstrapTabLabel, "Bootstrap");
    setLabelForElement(LABEL_CONSTANTS.bootstrapErrorLabel, "Bootstrap");

    //none tab labels
    setLabelForElement(LABEL_CONSTANTS.titleLabel, "Title");
    setLabelForElement(LABEL_CONSTANTS.docTypeLabel, "Doc_Type");
    setLabelForElement(LABEL_CONSTANTS.attachCssNoneLabel, "Attach_CSS");
    setLabelForElement(LABEL_CONSTANTS.extractNoneLabel, "Extract_banner");

    //bootstrap tab labels
    setLabelForElement(LABEL_CONSTANTS.bootstrapCssLabel, "Bootstrap_CSS");
    setLabelForElement(LABEL_CONSTANTS.bootstrapVersionLabel, "Bootstrap_Version");
    setLabelForElement(LABEL_CONSTANTS.createNewLabel, "Create_new");
    setLabelForElement(LABEL_CONSTANTS.useExistingLabel, "Use_existing");
    setLabelForElement(LABEL_CONSTANTS.attachCssBSLabel, "Attach_CSS");
    setLabelForElement(LABEL_CONSTANTS.deisgnLabel, "Desing");
    setLabelForElement(LABEL_CONSTANTS.prebuiltLayoutLabel, "Include_prebuilt_layout");
    setLabelForElement(UI_HTML_CONSTANTS.customizeText, "Customize");
    setLabelForElement(LABEL_CONSTANTS.customizeDescLabel, "Customize_desc_text");
    setLabelForElement(LABEL_CONSTANTS.columnLabel, "Columns");
    setLabelForElement(LABEL_CONSTANTS.gutterLabel, "Gutter");
    setLabelForElement(LABEL_CONSTANTS.screenLabel, "Screen");
    setLabelForElement(LABEL_CONSTANTS.gridLabel, "Grid_system");
    setLabelForElement(LABEL_CONSTANTS.smallLabel, "Small_screen");
    setLabelForElement(LABEL_CONSTANTS.mediumLabel, "Medium_screen");
    setLabelForElement(LABEL_CONSTANTS.largeLabel, "Large_screen");
    setLabelForElement(LABEL_CONSTANTS.extraLargeLabel, "Extra_Large_screen");
    setLabelForElement(LABEL_CONSTANTS.extractBootstrapLabel, "Extract_banner");
}

/*
* Sets the localized tooltip for an element
*/
function setTooltipForElement(elemId, stringId) {
    "use strict";
    var elem = document.getElementById(elemId);
    if (elem) {
        elem.title = getLocalizedString(stringId);
    }
}

/*
* Function to add all the tooltips
*/
function addTooltips() {
    "use strict";
    setTooltipForElement(UI_HTML_CONSTANTS.htmlNoneTabId, "None_tab_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.bootStrapTabId, "Bootstrap_tab_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.dwBootCSSSrcBtn, "Select_bootstrap_CSS_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.attachCssAddId, "Attach_CSS_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.attachCssAddBootstrap, "Attach_CSS_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.attachCssRemoveId, "Delete_CSS_tooltip");
    setTooltipForElement(UI_HTML_CONSTANTS.attachCssRemoveBootstrap, "Delete_CSS_tooltip");
}

function initPlatformSpecificUI() {
    "use strict";

    document.body.style.width = containerWidth + 'px';
    document.body.style.height = containerHeight + 'px';
    document.getElementById("tabContainer").style.width = containerWidth + 'px';
    document.getElementById("tabContainer").style.height = containerHeight + 'px';
    document.getElementById("tabscontent").style.height = (containerHeight - 73) + 'px'; // 73 is height of tabs including padding
    
    if (curNddOptions && curNddOptions.isWinOS) {
        // 27 is padding left/right + adjustment width for container border to appear correctly
	    document.getElementById("tabscontent").style.width = (containerWidth - 27) + 'px';
    }
}

/*
Initializer function called when iframe is loaded
*/
function initMainUI() {
    "use strict";
    if (dwBridge) {
        var argObject;
        argObject = {};
        argObject.callback = populateDtdComboBox;
        dwBridge.getDWDTDItems(argObject);
    }

    addLabels();
    addTooltips();
    addHintTextForControls();
    initPlatformSpecificUI();
    getAttachCssList();
    attachEventListeners();
	initBootstrapControls();

    if (curNddOptions && (curNddOptions.lastHtmlOptionSelected === 2 || curNddOptions.selectedTab === 2)) {
        selectBootstrapTab();
	}
}

// on click of one of tabs
function displayPage(event) {
	"use strict";

    var ident = event.detail.selection.getAttribute("data-tabNum");

    if (ident === "1") {
        noneSelected();
    } else if (ident === "2") {
        bootstrapSelected();
    }
}

window.onload = function () {
    "use strict";
	parent.postMessage({msg: "initIFrame", id: UI_HTML_CONSTANTS.detailFrameId}, "*");
};

window.onDWThemeChange = function(theme) {
    "use strict";
    var container  = document.getElementById("tabContainer");
    if (container && theme) {
        window.setCoralThemeForElement(container, theme);
    }
};