/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true*/

define([
    "jquery",
    "underscore",
    "backbone",
    "Constants",
    "plugin-dependencies"
], function ($, _, Backbone, Constants, deps) {
    "use strict";

    var ErrorMessageController = Backbone.Model.extend({

        getErrorMessageForWorkerResult: function (inJSONResultsData, inAssetName) {

            var errCode = inJSONResultsData.errorCode,
                errMsg = inJSONResultsData.errorMessage;

            if (errCode === null || errCode === undefined) {
                return deps.translate("UNKNOWN_ERROR_GENERATING_EXTRACT_DATA");
            }

            if (errCode === Constants.WorkerErrorCodes.UNSUPPORTED_INPUTFMT) {
                return deps.translate("COULD_NOT_PROCES_FILE_FILENAME_UNSUPPORTED_IMAGE_FORMAT", inAssetName);
            }

            if (errCode === Constants.WorkerErrorCodes.NOINPUTFILE) {
                return deps.translate("NO_FILES_SPECIFIED_FOR_PROCESSING");
            }

            if (errCode === Constants.WorkerErrorCodes.GRAPHITE_PROCESSING) {
                switch (errMsg) {
                case Constants.WorkerErrorMsgs.GR_JSONGENERATION:
                    return deps.translate("ERROR_GENERATING_EXTRACT_DATA_FOR_ASSET_NAME", inAssetName);
                case Constants.WorkerErrorMsgs.GR_THUMBNAIL:
                    return deps.translate("ERROR_GENERATING_THUMBNAIL_FOR_ASSET_NAME", inAssetName);
                case Constants.WorkerErrorMsgs.GR_SPRITESHEET:
                    return deps.translate("ERROR_GENERATING_EXTRACT_SPRITES_FOR_ASSET_NAME", inAssetName);
                case Constants.WorkerErrorMsgs.GR_UNKNOWNENCODING:
                    return deps.translate("ERROR_CREATING_ASSET_UNKNOWN_ENCODING");
                case Constants.WorkerErrorMsgs.GR_MISSINGLAYERSPEC:
                    return deps.translate("ERROR_CREATING_ASSET_MISSING_LAYER_SPECIFICATION");
                case Constants.WorkerErrorMsgs.GR_CREATINGASSET:
                    return deps.translate("ERROR_CREATING_ASSET_ERROR_ENCODING_ASSET");
                default:
                    // fall through, but make lint happy
                }
            }
 
            if (errCode === Constants.WorkerErrorCodes.GRAPHITE_REJECTED) {
                var matches = errMsg.match(/File rejected - too many layers \((\d+)\/(\d+)\)/);
                if (matches) {
                    var layerCount = matches[1];
                    var layerLimit = matches[2];
                    return deps.translate("CURRENTLY_PROCESSING_LIMITED_TO_COUNT_FILES_WITH_COUNT_LAYERS_OR_LESS_FILE_CONTAIN_COUNT_LAYERS_REDUCE_LAYERS", layerLimit, inAssetName, layerCount);
                }

                // fail of some sort. Be generic.
                return deps.translate("FILES_EXCEED_MAXIMUM_LAYERS_SUPPORTED_REDUCE_LAYERS_TRY_AGAIN");
            }

            return deps.translate("ERROR_GENERATING_EXTRACT_DATA_FOR_ASSET_NAME", inAssetName);
        }
    });

    return new ErrorMessageController();
});
