define([
    'jquery'
], function ($) {
    'use strict';
    var ScrollableItem = {

        scrollIntoView: function (options) {
            var element = this.$el[0];
            var parent = this.findScrollableParent(element);

            var parentBox = parent.getBoundingClientRect();
            var elementBox = element.getBoundingClientRect();
            var elementBottom = elementBox.bottom;
            if (options && options.itemHeight) {
                elementBottom = elementBox.top + options.itemHeight;
            }

            var newScrollPos = 0;
            var diff = 0;
            // check if the layer element is out of view above or below
            if (elementBox.top < parentBox.top) {
                // Scroll it into view at the topmost position
                newScrollPos = parent.scrollTop + (elementBox.top - parentBox.top);
            } else if (elementBottom > parentBox.bottom) {
                diff = elementBottom - parentBox.bottom;
                // Scroll it into view at the bottom-most position but make sure it doesn't go above the top
                if ((elementBox.top - diff) < parentBox.top) {
                    newScrollPos = parent.scrollTop + (elementBox.top - parentBox.top);
                } else {
                    newScrollPos = parent.scrollTop + diff;
                }
            }
            if (newScrollPos !== 0) {
                $(parent).animate({scrollTop: newScrollPos});
            }
        },

        findScrollableParent: function (element) {
            var style;
            var parent = element;
            do {
                parent = parent.parentElement;
                style = getComputedStyle(parent);
            } while (parent !== document.body && style.overflow !== "auto" && style.overflow !== "scroll");

            return parent;
        }

    };

    return ScrollableItem;
});
