/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true, document: true*/
// This is a temporary inclusion until CCweb.view_context_menu() gets rearchitected
// https://git.corp.adobe.com/Stormcloud/sonar/issues/3119
define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/Constants',
    'parfait/ContextMenuView'
], function ($, _, Backbone, Constants, ContextMenuView) {
    'use strict';

    var DwContextMenuView = ContextMenuView.extend({
        placeMenu: function () {
            var togglePos = this.$toggle.position(),
                offsetParent = this.$toggle.offsetParent(),
                scrollTop = offsetParent ? offsetParent.scrollTop() : 0,
                scrollLeft = offsetParent ? offsetParent.scrollLeft() : 0;
            
            if (this.position === Constants.MenuPosition.TOP) {
                this.$el.css('top', togglePos.top + scrollTop);
                this.$el.css('left', togglePos.left);
            } else if (this.position === Constants.MenuPosition.BELOW) {
                this.$el.css('top', togglePos.top + this.$toggle.outerHeight() + scrollTop);
                this.$el.css('left', togglePos.left);
            } else if (this.position === Constants.MenuPosition.BELOW_RIGHT_ALIGN) {
                this.$el.css('top', togglePos.top + this.$toggle.outerHeight() + scrollTop);
                this.$el.css('left', togglePos.left + this.$toggle.outerWidth() + scrollLeft - this.$el.width() - 3);
            }
        },

        open: function () {

            if (!this.enabled) { return false; }
            
            this.placeMenu();
            this.$toggle.addClass('menu-open');
            this.$toggle.unbind(this.toggleEvent, this.open);
            this.$el.css('opacity', 0);
            this.render();
            this.$after.after(this.$el);
            this.trigger('show', this.$el, this.$toggle);
            this.$el.find('a').bind(this.itemEvent, this.handleSelect);
            this.$el.bind(this.blurEvent, this.stopClickProp);
            $(document.body).bind(this.blurEvent, this.close);
            window.graphite.events.on("dismiss-context-menu", this.close, this);
            window.graphite.events.on('document-mousedown', this.handleMouseDown, this);
            this.isOpen = true;

            this.placeMenu();
            this.$el.animate({ opacity: 1 }, 150);

            //We want to capture any mouse down in the context menu is up so that we can dismiss ourselves
            // when there's a click somewhere else.
            window.addEventListener('mousedown', this.handleDocumentMouseDown, true);
            return false;

        },

        close: function () {
            //Remove the mouse down event handler on window before doing anything else
            window.removeEventListener('mousedown', this.handleDocumentMouseDown, true);
            if (this.isOpen === false) { return; }
            
            this.$toggle.removeClass('menu-open');
            this.$el.remove();
            this.trigger('hide');
            this.$el.find('a').unbind(this.itemEvent, this.handleSelect);
            this.$el.unbind(this.blurEvent, this.stopClickProp);
            window.graphite.events.off("dismiss-context-menu", this.close, this);
            window.graphite.events.off('document-mousedown', this.handleMouseDown, this);
            $(document.body).unbind(this.blurEvent, this.close);
            this.isOpen = false;

            var self = this;
            _.delay(function () { self.$toggle.bind(self.toggleEvent, self.open); }, 200);

            return false;

        },

        remove: function () {
            window.graphite.events.off(null, null, this);
            this.$toggle.unbind(this.toggleEvent, this.open);
            this.$el.removeData().unbind();
            this.$el.empty();
            this.undelegateEvents();
            this.unbind();
            this.stopListening();
            
            Backbone.View.prototype.remove.apply(this, arguments);
        },
        
        handleDocumentMouseDown: function (evt) {
            window.graphite.events.trigger("document-mousedown", evt);
        },
        
        handleMouseDown: function (evt) {
            var $target = $(evt.target);
            if (!this.$el.has($target).length) {
                this.close();
            }
        }
        
        
    });
    
    return DwContextMenuView;
});