/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, document: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'text!ccweb.files.extract/views/templates/cssCopyPopupGroupItemTemplate.html',
    'text!ccweb.files.extract/views/templates/cssCopyPopupSingleItemTemplate.html',
    'text!ccweb.files.extract/views/templates/cssCopyPopupSelectAllOptionTemplate.html',
    'ccweb.files.extract/utils/TemplateUtil',
    'ccweb.files.extract/models/UserSettingsModel'
], function ($, _, Backbone, CssCopyPopupGroupItemTemplate, CssCopyPopupSingleItemTemplate, CssCopyPopupSelectAllOptionTemplate, TemplateUtil, UserSettingsModel) {
    "use strict";

    var CopyCssPopupView = Backbone.View.extend({
        
        order: ['layoutCss', 'textCss', 'borderCss', 'backgroundCss', 'inlineCss', 'other'],
        
        copyDisabled: false,
        
        events: {
            "click .select-all-check": "handleSelectAllCheck",
            "click .copy-css-check": "handleCheck",
            "click .unit-type-button": "handleUnitTypeClick"
        },

        initialize: function () {
            this.render();
        },
        
        remove: function () {
            // COMPLETELY UNBIND THE VIEW
			this.undelegateEvents();
            this.$el.removeData().unbind();
			this.$el.empty();
            this.unbind();
            this.stopListening();
            // Remove view from DOM
            return Backbone.View.prototype.remove.apply(this, arguments);
        },
        
        handleSelectAllCheck: function (event) {
            var $checkBox = $(event.target);
            
            if ($checkBox.prop('checked')) {
                this.render(true, true);
            } else {
                this.$el.find('.copy-css-check').prop('checked', false);
            }
            this.disableCSSCopy(!$checkBox.prop('checked'));
            event.stopPropagation();
        },
        
        disableCSSCopy: function (isDisabled) {
            this.model.set("isDisabled", isDisabled);
            if (isDisabled) {
                window.graphite.events.trigger("disable-css-copy");
            } else {
                window.graphite.events.trigger("enable-css-copy");
            }
        },
        
        handleUnitTypeClick: function (event) {
            var clickedButtonStr = $(event.target).html(),
                $rootElement = $(event.target).parent().parent();
            
            UserSettingsModel.set('preferredMeasurementUnits', clickedButtonStr);
            this.updateWidthHeightValues(clickedButtonStr, $rootElement);
        },
        
        handleCheck: function (event) {
            var $checkBox = $(event.target),
                $cssGroup = $checkBox.parent().parent(),
                propertyName = $checkBox.parent().find('.property-name').text(),
                propertyValue = $(event.target).parent().find('.property-value').text(),
                $inlineItems,
                maximumSelectableElementsLength = this.model.getAllCssItemsLength(),
                currentSelectedElementsLength = 0,
                checkboxesArray = Array.prototype.slice.call(this.$el.find('.copy-css-check'), 0);
            
            checkboxesArray.forEach(function (checkbox) {
                checkbox = $(checkbox);
                if (checkbox.is(':checked')) {
                    currentSelectedElementsLength++;
                }
            });
            
            this.disableCSSCopy(currentSelectedElementsLength === 0);

            if (currentSelectedElementsLength < maximumSelectableElementsLength) {
                this.$el.find('.select-all-check').prop('checked', false);
            } else {
                this.$el.find('.select-all-check').prop('checked', true);
            }
            
            if ($cssGroup.hasClass('inline-css') && $checkBox.prop('checked')) {
                Array.prototype.slice.call(
                    this.$el.find('.inline-css'),
                    0
                ).forEach(function (inlineElementsBlockNode) {
                    Array.prototype.slice.call(
                        $(inlineElementsBlockNode).find('.css-property-item'),
                        0
                    ).forEach(function (cssItemNode) {
                        if ($(cssItemNode).find('.property-name').text() === propertyName) {
                            $(cssItemNode).find('.copy-css-check').prop('checked', false);
                        }
                    });
                });
                $checkBox.prop('checked', true);
            }
        },
        
        updateWidthHeightValues: function (currentUnitStr, $rootElement) {
            //get the width and height value fields and the px/% buttons
            var $propertyItems = $rootElement.find('.css-property-item'),
                unitTypeButtonElems = $rootElement.find('.unit-type-button'),
                cssPropertiesData = this.model.get('cssPropertiesData'),
                width = "",
                height = "",
                selectedUnitIndex = (currentUnitStr === "px") ? 0 : 1;
            
            if (unitTypeButtonElems.length < 2) {
                return;
            }
            
            if (selectedUnitIndex === 0) {
                //get px values for width and height
                width = this.model.getValueForPropertyInGroup('width', 'layoutCss');
                height = this.model.getValueForPropertyInGroup('height', 'layoutCss');
            } else {
                //get % values for width and height
                width = this.model.getValueForPropertyInGroup('width%', 'percentValues');
                height = this.model.getValueForPropertyInGroup('height%', 'percentValues');
            }
            
            //update the value fields for width and height
            Array.prototype.slice.call(
                $propertyItems,
                0
            ).forEach(function (cssItemNode) {
                if ($(cssItemNode).find('.property-name').text() === "width") {
                    $(cssItemNode).find('.property-value').html(width);
                } else if ($(cssItemNode).find('.property-name').text() === "height") {
                    $(cssItemNode).find('.property-value').html(height);
                }
            });
            
            //set the unit type as selected            
            $(unitTypeButtonElems[selectedUnitIndex]).addClass('unit-type-button-selected');
            $(unitTypeButtonElems[1 - selectedUnitIndex]).removeClass('unit-type-button-selected');
        },
        
        createUnitTypeButtons : function ($rootElement) {
            //create px button along with 'width' 
            // and % button with 'height'
            var $propertyItems = $rootElement.find('.css-property-item');
            Array.prototype.slice.call(
                $propertyItems,
                0
            ).forEach(function (cssItemNode) {
                if ($(cssItemNode).find('.property-name').text() === "width") {
                    var $pxButton = $(document.createElement('span'));
                    $pxButton.html("px");
                    $pxButton.addClass('unit-type-button');
                    $pxButton.addClass('pixel-button');
                    $(cssItemNode).append($pxButton);
                } else if ($(cssItemNode).find('.property-name').text() === "height") {
                    var $percentButton = $(document.createElement('span'));
                    $percentButton.html("%");
                    $percentButton.addClass('unit-type-button');
                    $(cssItemNode).append($percentButton);
                }
            });
        },
        
        renderInlineData: function (inlineData) {
            var self = this,
                template,
                $template,
                cssBlock,
                checkedInlineProperties = false;
            
            inlineData.forEach(function (inlineBlock, index) {
                if (inlineBlock.length) {
                    cssBlock = {
                        key: 'inline' + index,
                        propertyItems: inlineBlock
                    };
                    template = TemplateUtil.createTemplate(CssCopyPopupGroupItemTemplate, cssBlock);
                    $template = $(template);
                    $template.addClass('inline-css');
                    if (!index) {
                        $template.find('.copy-css-check').prop('checked', true);
                        if (!checkedInlineProperties) {
                            checkedInlineProperties = true;
                        }
                    }
                    self.$el.append($template);
                }
            });
            //Return if there were any checked properties
            return checkedInlineProperties;
        },
        
        render: function (shouldCheckLayout, shouldCheckSelectAll) {
            var template,
                cssPropertiesData = this.model.get('cssPropertiesData'),
                itemsLength = this.model.getAllCssItemsLength(),
                cssBlock,
                $template,
                checkedProperties = false,
                $selectAllCheck,
                self = this;
            
            self.$el.html('');
            
            if (itemsLength > 1) {
                // Create 'select all' group
                template = TemplateUtil.createTemplate(CssCopyPopupSelectAllOptionTemplate, null);
                $template = $(template);
                $selectAllCheck = $template.find('.select-all-check');
                if (shouldCheckSelectAll !== undefined) {
                    $selectAllCheck.prop('checked', shouldCheckSelectAll);
                } else if (cssPropertiesData.layoutCss.length) {
                    $selectAllCheck.prop('checked', false);
                } else {
                    $selectAllCheck.prop('checked', true);
                }
                $template.addClass('remove-border');
                self.$el.append($template);
                
                // Add the rest of the groups
                this.order.forEach(function (key) {
                    if (key === 'inlineCss') {
                        var checkedInlineProperties = self.renderInlineData(cssPropertiesData[key]);
                        checkedProperties = checkedProperties || checkedInlineProperties;
                    } else if (cssPropertiesData[key].length) {
                        cssBlock = {
                            key: key,
                            propertyItems: cssPropertiesData[key]
                        };
                        template = TemplateUtil.createTemplate(CssCopyPopupGroupItemTemplate, cssBlock);
                        $template = $(template);
                        if (key !== 'layoutCss' || shouldCheckLayout) {
                            $template.find('.copy-css-check').prop('checked', true);
                            if (!checkedProperties) {
                                checkedProperties = true;
                            }
                        }
                        if (key === 'layoutCss') {
                            //create px/% buttons and update the values
                            self.createUnitTypeButtons($template);
                            var lastUsedUnitType = UserSettingsModel.get('preferredMeasurementUnits');
                            self.updateWidthHeightValues(lastUsedUnitType, $template);
                        }
                        self.$el.append($template);
                    }
                });
                this.disableCSSCopy(!checkedProperties);
            } else {
                this.order.forEach(function (key) {
                    if (key === 'inlineCss') {
                        self.renderInlineData(cssPropertiesData[key]);
                    } else if (cssPropertiesData[key].length) {
                        cssBlock = {
                            key: key,
                            propertyItems: cssPropertiesData[key]
                        };
                        
                        // Make single item template instead of group
                        template = TemplateUtil.createTemplate(CssCopyPopupSingleItemTemplate, cssBlock);
                        $template = $(template);
                        if (key !== 'layoutCss' || shouldCheckLayout) {
                            $template.find('.copy-css-check').prop('checked', true);
                        }
                        $template.addClass('remove-border');
                        self.$el.append($template);
                    }
                });
            }
        }
    });

    return CopyCssPopupView;

});
