/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite*/

define([
    'jquery',
    'underscore',
    'ccweb.files.extract/controllers/SelectionController',
    'ccweb.files.extract/controllers/DetailsController',
    'ccweb.files.extract/models/LayerModelMap',
    'ccweb.files.extract/models/LayerModel',
    'ccweb.files.extract/utils/MeasurementUtil',
    'parfait/FlattenedAssetController'
], function ($, _, SelectionController, DetailsController, LayerModelMap, LayerModel, MeasurementUtil, FlattenedAssetController) {
    'use strict';

    var DwFlattenedAssetController = $.extend(FlattenedAssetController, {
        invalidateSprite: function (model) {
            var psdModelID = SelectionController.getPSDModel().id,
                layerCompId = SelectionController.getPSDModel().get('layerCompId'),
                spriteInfo = this.deriveSpriteInfo(model, psdModelID),
                refreshRequest,
                cachedImage = this.cachedImages[spriteInfo.key()],
                self = this;

            if (!cachedImage && this.isOriginalPSDVisibility(model)) {
                // For initial state obtain sprite from our DetailsController
                cachedImage = {
                    image: DetailsController.spriteSheets[model.get('flattenedSprite').sheetID],
                    bounds: model.get('flattenedSprite').bounds
                };
                this.cachedImages[spriteInfo.key()] = cachedImage;
            }

            if (spriteInfo.visibleLayers && spriteInfo.visibleLayers.length === 0) {
                this.replaceFlattenedSprite(model, null);
            } else if (cachedImage && cachedImage.image.complete) {
                this.replaceFlattenedSprite(model, cachedImage.image, cachedImage.bounds);
            } else {
                refreshRequest = {};
                refreshRequest.model = model;
                refreshRequest.psdModelID = psdModelID;
                refreshRequest.psdPath = SelectionController.getPSDModel().get("path");
                refreshRequest.layerCompId = layerCompId;
                refreshRequest.info = spriteInfo;
                refreshRequest.delayTimer = setTimeout(function () {
                    self.activateRequest(refreshRequest);
                }, this.requestDelay);
                this.queueRequest(refreshRequest);
            }
        },

        /**
         * Once our lazy-load timeout has expired, fire off
         * the actual image request.
         * @param request
         */
        activateRequest: function (request) {
            var self = this,
                imageLoaded = function () {
                    self.imageLoaded(request);
                },
                imageError = function (result) {
                    self.imageError(request);
                };

            request.image = graphite.serverAPI.getDerivedSpriteImage(request.psdPath, request.layerCompId, request.info.visibleLayers, imageLoaded, imageError);
            request.delayTimer = null;
        }

    });

    return DwFlattenedAssetController;
});
