/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

function MetricsController() {
    'use strict';
    this.mergeParams = function (params) {
        var thisParam,
            returnParams = {};
        for (thisParam in this.defaultParams) {
            if (this.defaultParams.hasOwnProperty(thisParam)) {
                returnParams[thisParam] = this.defaultParams[thisParam];
            }
        }
        for (thisParam in params) {
            if (params.hasOwnProperty(thisParam)) {
                returnParams[thisParam] = params[thisParam];
            }
        }
        return returnParams;
    };
    
    this.trackDebugEvent = function (eventData) {
        var debugParams = {};
        debugParams.eventcategory = "Debug";
        debugParams.eventname = eventData.eventname;
        debugParams.subevent = eventData.subevent;
        window.DWDevicePreviewCallJsBridgingFunction("logPreviewEvent", debugParams);
    };
            
    this.trackEvent = function (eventName, eventParams, isError) {
        var baseEvent = isError ? "RWD_DevicePreview_Error" : "RWD_DevicePreview",
            eventMap,
            eventInfo,
            params = eventParams || {},
            mergedParams,
            subEvent;

        eventMap = {
            "short-url-clicked"                     : {event : baseEvent, subevent: "ConnectionStart_ShortLink"},
            "connection-success-short-link"         : {event : baseEvent, subevent: "Connection_Successful_ShortLink"},
            "connection-success-qrcode"             : {event : baseEvent, subevent: "Connection_Successful_QRCode"},
            "connection-success-manually"           : {event : baseEvent, subevent: "Connection_Successful_Manually"},
            "render-success"                        : {event : baseEvent, subevent: "Success:Rendered_Success"},
            "login-success"                         : {event : baseEvent, subevent: "LoginSuccessful"},
            "context-menu-copy-url"                 : {event : baseEvent, subevent: "CopyURLIconClicked"},
            "inspect-clicked"                       : {event : baseEvent, subevent: "InspectClicked"},
            "meta-data"                             : {event : baseEvent, subevent: "MetaData"},
            "metadata-overlay-shown"                : {event : baseEvent, subevent: "DeviceMetaData_OverlayShown"},
            "preview-service-failure"               : {event : baseEvent, subevent: "CCPreviewServiceFailure"},
            "firewall-error"                        : {event : baseEvent, subevent: "FirewallIssue"}
        };

        eventInfo = eventMap[eventName];

        if (eventInfo) {

            mergedParams = this.mergeParams(params);
            subEvent = eventInfo.subevent;
            
            if (mergedParams.formatSubEvent) {
                if (mergedParams.formatSubEvent.length) {
                    try {
                        subEvent = window.preview.utils.sprintf(subEvent, mergedParams.formatSubEvent);
                    } catch (e) {
                        //console.error("Format specifer error in metrics proxy model for Event: " + eventInfo.event + " SubEvent: " + eventInfo.subevent);
                    }
                }
                delete mergedParams.formatSubEvent;
            }

            mergedParams.subevent = subEvent;

            // eventname (subevent has already been embedded)
            mergedParams.eventname = eventInfo.event;

            mergedParams.eventcategory = "RWD";
            
            // Now post our event
            if (mergedParams.hasOwnProperty('dataGroup')) {
                window.DWDevicePreviewCallJsBridgingFunction("logDataGroupPreviewEvent", mergedParams);
            } else {
                window.DWDevicePreviewCallJsBridgingFunction("logPreviewEvent", mergedParams);
            }
        }
    };
}
window.preview.metricsController = window.preview.metricsController || new MetricsController();
